/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.bus.QBusSimpleSlave;
import bk2010.sound.AY8910;

public final class AZAY
extends QBusSimpleSlave {
    final AY8910 synthA;
    final AY8910 synthB;

    public AZAY(AY8910 synthA, AY8910 synthB) {
        this.synthA = synthA;
        this.synthB = synthB;
    }

    @Override
    public int getBaseAddress() {
        return 65146;
    }

    @Override
    public int getNumWords() {
        return 2;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public void reset() {
    }

    @Override
    public int peekWord(int addr) {
        return 0;
    }

    private void writeAY(AY8910 synth, short data, int mask) {
        if (synth == null) {
            return;
        }
        if ((mask & 1) != 0) {
            synth.setRegIndex(data & 0xFF);
        }
        if ((mask & 2) != 0) {
            synth.writeReg((byte)(data >> 8));
        }
    }

    @Override
    public boolean writeWord(int addr, short data) {
        if ((addr & 2) == 0) {
            this.writeAY(this.synthB, data, 3);
        } else {
            this.writeAY(this.synthA, data, 3);
        }
        return true;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        int mask = 1 + (addr & 1);
        if ((addr & 2) == 0) {
            this.writeAY(this.synthB, data, mask);
        } else {
            this.writeAY(this.synthA, data, mask);
        }
        return true;
    }
}

