/*
 * Decompiled with CFR 0.152.
 */
package bk2010.util;

import bk2010.util.LogObserver;
import java.util.ArrayList;
import java.util.Arrays;

public final class LogBuffer {
    public static final int DEFAULT_DEPTH = 10000;
    private int historyDepth;
    private String[] lines;
    private volatile int usedDepth;
    private ArrayList<LogObserver> observers = new ArrayList();
    private Object updateLock = new Object();

    public LogBuffer() {
        this(10000);
    }

    public LogBuffer(int maxHistoryDepth) {
        this.historyDepth = maxHistoryDepth;
        this.lines = new String[this.historyDepth];
        Arrays.fill(this.lines, "");
    }

    public int size() {
        return this.usedDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int erase() {
        Object object = this.updateLock;
        synchronized (object) {
            int wereMessages = this.usedDepth;
            this.usedDepth = 0;
            Arrays.fill(this.lines, "");
            return wereMessages;
        }
    }

    public String getLine(int index) {
        if (index < 0) {
            index += this.usedDepth;
        }
        if (index >= this.usedDepth) {
            return "";
        }
        return this.lines[index];
    }

    public String getlastLine() {
        return this.getLine(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(LogObserver observer) {
        if (observer != null) {
            Object object = this.updateLock;
            synchronized (object) {
                if (this.observers.contains(observer)) {
                    return;
                }
                this.observers.add(observer);
            }
        }
    }

    public boolean removeObserver(LogObserver observer) {
        return this.observers.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String append(String s) {
        String message = s == null ? "(null log message)" : s;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.usedDepth < this.lines.length) {
                this.lines[this.usedDepth++] = message;
            }
        }
        for (LogObserver observer : this.observers) {
            observer.logUpdateNotification(this, message);
        }
        return s;
    }
}

