/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.AudioPlayerKt;
import audio.AudioSystem;
import audio.ProgressUpdater;
import audio.VorbisTrack;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0017\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010#\u001a\u00020\u001aJ\u0006\u0010$\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020 J\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Laudio/AudioRenderer;", "", "track", "Laudio/VorbisTrack;", "<init>", "(Laudio/VorbisTrack;)V", "format", "", "source", "buffers", "Ljava/nio/IntBuffer;", "pcm", "Ljava/nio/ShortBuffer;", "bufferOffset", "", "getBufferOffset", "()J", "setBufferOffset", "(J)V", "offset", "getOffset", "setOffset", "lastOffset", "getLastOffset", "setLastOffset", "destroy", "", "stream", "buffer", "play", "", "gain", "", "(Ljava/lang/Double;)Z", "resume", "pause", "stop", "pitch", "update", "loop", "progressUpdater", "Laudio/ProgressUpdater;", "getProgressUpdater", "()Laudio/ProgressUpdater;", "Companion", "deminityy"})
public final class AudioRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VorbisTrack track;
    private int format;
    private final int source;
    @NotNull
    private final IntBuffer buffers;
    @NotNull
    private final ShortBuffer pcm;
    private long bufferOffset;
    private long offset;
    private long lastOffset;
    private static final int BUFFER_SIZE = 8192;

    public AudioRenderer(@NotNull VorbisTrack track) {
        Intrinsics.checkNotNullParameter(track, "track");
        this.track = track;
        switch (this.track.getChannels()) {
            case 1: {
                this.format = 4353;
                break;
            }
            case 2: {
                this.format = 4355;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported number of channels: " + this.track.getChannels());
            }
        }
        this.pcm = MemoryUtil.memAllocShort(BUFFER_SIZE);
        EXTThreadLocalContext.alcSetThreadContext(AudioSystem.INSTANCE.getContext());
        this.source = AL10.alGenSources();
        AL10.alSourcei(this.source, 4147, 1);
        this.buffers = MemoryUtil.memAllocInt(2);
        AL10.alGenBuffers(this.buffers);
    }

    public final long getBufferOffset() {
        return this.bufferOffset;
    }

    public final void setBufferOffset(long l) {
        this.bufferOffset = l;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final void setOffset(long l) {
        this.offset = l;
    }

    public final long getLastOffset() {
        return this.lastOffset;
    }

    public final void setLastOffset(long l) {
        this.lastOffset = l;
    }

    public final void destroy() {
        EXTThreadLocalContext.alcSetThreadContext(AudioSystem.INSTANCE.getContext());
        AL10.alDeleteBuffers(this.buffers);
        AL10.alDeleteSources(this.source);
        MemoryUtil.memFree(this.buffers);
        MemoryUtil.memFree(this.pcm);
        EXTThreadLocalContext.alcSetThreadContext(0L);
    }

    private final int stream(int buffer) {
        int samples;
        int samplesPerChannel;
        for (samples = 0; samples < BUFFER_SIZE; samples += samplesPerChannel * this.track.getChannels()) {
            this.pcm.position(samples);
            samplesPerChannel = this.track.getSamples(this.pcm);
            if (samplesPerChannel == 0) break;
        }
        if (samples != 0) {
            this.pcm.position(0);
            this.pcm.limit(samples);
            AL10.alBufferData(buffer, this.format, this.pcm, this.track.getSampleRate());
            this.pcm.limit(BUFFER_SIZE);
        }
        return samples;
    }

    public final boolean play(@Nullable Double gain) {
        if (gain != null) {
            this.gain(gain);
        }
        int n = this.buffers.limit();
        for (int i = 0; i < n; ++i) {
            if (this.stream(this.buffers.get(i)) != 0) continue;
            return false;
        }
        AL10.alSourceQueueBuffers(this.source, this.buffers);
        AL10.alSourcePlay(this.source);
        return true;
    }

    public static /* synthetic */ boolean play$default(AudioRenderer audioRenderer, Double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        return audioRenderer.play(d);
    }

    public final void resume() {
        AL10.alSourcePlay(this.source);
    }

    public final void pause() {
        AudioPlayerKt.access$getLogger$p().info(AudioRenderer::pause$lambda$0);
        AL10.alGetError();
        AL10.alSourcePause(this.source);
        int error = AL10.alGetError();
        if (error != 0) {
            String msg = error == 40964 ? "AL_INVALID_OPERATION: There is no current context. " : null;
            AudioPlayerKt.access$getLogger$p().error(() -> AudioRenderer.pause$lambda$1(msg));
        }
    }

    public final void stop() {
        AL10.alSourceStop(this.source);
    }

    public final void gain(double gain) {
        AL10.alSourcef(this.source, 4106, (float)gain);
    }

    public final void pitch(double pitch) {
        AL10.alSourcef(this.source, 4099, (float)pitch);
    }

    public final boolean update(boolean loop2) {
        int processed = AL10.alGetSourcei(this.source, 4118);
        for (int i = 0; i < processed; ++i) {
            this.bufferOffset += (long)(BUFFER_SIZE / this.track.getChannels());
            int buffer = AL10.alSourceUnqueueBuffers(this.source);
            if (this.stream(buffer) == 0) {
                boolean shouldExit = true;
                if (loop2) {
                    this.track.rewind();
                    this.lastOffset = this.offset = (this.bufferOffset = 0L);
                    boolean bl = shouldExit = this.stream(buffer) == 0;
                }
                if (shouldExit) {
                    return false;
                }
            }
            AL10.alSourceQueueBuffers(this.source, buffer);
        }
        if (processed == 2) {
            AL10.alSourcePlay(this.source);
        }
        return true;
    }

    @NotNull
    public final ProgressUpdater getProgressUpdater() {
        return new ProgressUpdater(this){
            final /* synthetic */ AudioRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            public void makeCurrent(boolean current) {
                EXTThreadLocalContext.alcSetThreadContext(current ? AudioSystem.INSTANCE.getContext() : 0L);
            }

            public void updateProgress() {
                this.this$0.setOffset(this.this$0.getBufferOffset() + (long)AL10.alGetSourcei(AudioRenderer.access$getSource$p(this.this$0), 4133));
                AudioRenderer.access$getTrack$p(this.this$0).progressBy((int)(this.this$0.getOffset() - this.this$0.getLastOffset()));
                this.this$0.setLastOffset(this.this$0.getOffset());
            }
        };
    }

    private static final Object pause$lambda$0() {
        return "pausing";
    }

    private static final Object pause$lambda$1(String $msg) {
        return $msg;
    }

    public static final /* synthetic */ int access$getSource$p(AudioRenderer $this) {
        return $this.source;
    }

    public static final /* synthetic */ VorbisTrack access$getTrack$p(AudioRenderer $this) {
        return $this.track;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Laudio/AudioRenderer$Companion;", "", "<init>", "()V", "BUFFER_SIZE", "", "deminityy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

