/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.Channel;
import audio.VorbisTrack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Laudio/VorbisChannel;", "Laudio/Channel;", "vorbisTrack", "Laudio/VorbisTrack;", "<init>", "(Laudio/VorbisTrack;)V", "getVorbisTrack", "()Laudio/VorbisTrack;", "offset", "", "getOffset", "()D", "setOffset", "(D)V", "paused", "", "getPaused", "()Z", "setPaused", "(Z)V", "setPosition", "", "seconds", "setPitch", "pitch", "setVolume", "volume", "getPosition", "play", "loop", "pause", "resume", "stop", "deminityy"})
public final class VorbisChannel
extends Channel {
    @NotNull
    private final VorbisTrack vorbisTrack;
    private double offset;
    private boolean paused;

    public VorbisChannel(@NotNull VorbisTrack vorbisTrack) {
        Intrinsics.checkNotNullParameter(vorbisTrack, "vorbisTrack");
        this.vorbisTrack = vorbisTrack;
    }

    @NotNull
    public final VorbisTrack getVorbisTrack() {
        return this.vorbisTrack;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final void setOffset(double d) {
        this.offset = d;
    }

    public final boolean getPaused() {
        return this.paused;
    }

    public final void setPaused(boolean bl) {
        this.paused = bl;
    }

    @Override
    public void setPosition(double seconds) {
        this.vorbisTrack.setPosition(seconds);
        this.offset = (double)System.currentTimeMillis() / 1000.0 - seconds;
    }

    @Override
    public void setPitch(double pitch) {
        this.vorbisTrack.setPitch(pitch);
    }

    @Override
    public void setVolume(double volume) {
        this.vorbisTrack.setGain(volume);
    }

    @Override
    public double getPosition() {
        double trackPosition = this.vorbisTrack.position();
        double clockPosition = (double)System.currentTimeMillis() / 1000.0 - this.offset;
        if (this.paused || !(this.vorbisTrack.getPitch() == 1.0)) {
            return trackPosition;
        }
        double dt = trackPosition - clockPosition;
        double tooMuch = 0.016666666666666666;
        if (dt < -tooMuch) {
            this.offset += tooMuch / 2.0;
        }
        if (dt > tooMuch) {
            this.offset -= tooMuch / 2.0;
        }
        return clockPosition;
    }

    @Override
    public void play(boolean loop2) {
        this.offset = (double)System.currentTimeMillis() / 1000.0;
        VorbisTrack.play$default(this.vorbisTrack, null, loop2, 1, null);
    }

    @Override
    public void pause() {
        this.paused = true;
        this.vorbisTrack.pause();
    }

    @Override
    public void resume() {
        this.paused = false;
        this.offset = (double)System.currentTimeMillis() / 1000.0 - this.vorbisTrack.position();
        this.vorbisTrack.resume();
    }

    @Override
    public void stop() {
        this.vorbisTrack.stop();
    }
}

