/*
 * Decompiled with CFR 0.152.
 */
package audio;

import audio.AudioPlayerKt;
import audio.AudioRenderer;
import audio.AudioSystem;
import audio.ProgressUpdater;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.openrndr.events.Event;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010(\u001a\u00020&J!\u00105\u001a\u0002062\n\b\u0002\u00107\u001a\u0004\u0018\u00010&2\b\b\u0002\u00108\u001a\u000209\u00a2\u0006\u0002\u0010:J\u0006\u0010;\u001a\u000206J\u0018\u0010<\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u000bH\u0002J\u0006\u0010>\u001a\u000206J\u000e\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020\u000bJ\u000e\u0010A\u001a\u0002062\u0006\u0010\u0019\u001a\u00020\u000bJ\u0006\u0010B\u001a\u000206J\u0006\u0010C\u001a\u000206J\u0006\u0010D\u001a\u000206J\u000e\u0010E\u001a\u0002062\u0006\u0010F\u001a\u00020\u000bJ\u000e\u0010G\u001a\u0002062\u0006\u0010H\u001a\u00020\u0016J\u0006\u0010I\u001a\u00020&J\u0006\u0010J\u001a\u00020&J\u000e\u0010K\u001a\u0002062\u0006\u0010L\u001a\u00020&J\u0010\u0010M\u001a\u00020\u000b2\b\u0010N\u001a\u0004\u0018\u00010OJ\u0010\u0010P\u001a\u0002062\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0010\u0010Q\u001a\u0002062\u0006\u0010R\u001a\u00020SH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000'0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010*\u001a\u00020&2\u0006\u0010)\u001a\u00020&@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u0010/\u001a\u00020&2\u0006\u0010)\u001a\u00020&@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u00000'\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006T"}, d2={"Laudio/VorbisTrack;", "", "filePath", "", "<init>", "(Ljava/lang/String;)V", "encodedAudio", "Ljava/nio/ByteBuffer;", "handle", "", "channels", "", "getChannels", "()I", "setChannels", "(I)V", "sampleRate", "getSampleRate", "setSampleRate", "samplesLength", "getSamplesLength", "samplesSec", "", "getSamplesSec", "()F", "sampleIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "getSampleIndex", "()Ljava/util/concurrent/atomic/AtomicInteger;", "audioRenderer", "Laudio/AudioRenderer;", "audioThread", "Ljava/lang/Thread;", "playing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stopRequested", "cuePoints", "", "", "Lorg/openrndr/events/Event;", "duration", "value", "gain", "getGain", "()D", "setGain", "(D)V", "pitch", "getPitch", "setPitch", "finished", "getFinished", "()Lorg/openrndr/events/Event;", "play", "", "initialGain", "loop", "", "(Ljava/lang/Double;Z)V", "stop", "ioResourceToByteBuffer", "blockSize", "destroy", "progressBy", "samples", "setSampleIndex", "pause", "resume", "rewind", "skip", "direction", "skipTo", "offset0to1", "relativePosition", "position", "setPosition", "timeInSeconds", "getSamples", "pcm", "Ljava/nio/ShortBuffer;", "seek", "print", "info", "Lorg/lwjgl/stb/STBVorbisInfo;", "deminityy"})
@SourceDebugExtension(value={"SMAP\nAudioPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioPlayer.kt\naudio/VorbisTrack\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,471:1\n487#2,7:472\n1053#3:479\n1863#3,2:480\n*S KotlinDebug\n*F\n+ 1 AudioPlayer.kt\naudio/VorbisTrack\n*L\n124#1:472,7\n125#1:479\n125#1:480,2\n*E\n"})
public final class VorbisTrack {
    @Nullable
    private ByteBuffer encodedAudio;
    private long handle;
    private int channels;
    private int sampleRate;
    private final int samplesLength;
    private final float samplesSec;
    @NotNull
    private final AtomicInteger sampleIndex;
    @Nullable
    private AudioRenderer audioRenderer;
    @Nullable
    private Thread audioThread;
    @NotNull
    private final AtomicBoolean playing;
    @NotNull
    private final AtomicBoolean stopRequested;
    @NotNull
    private final Map<Double, Event<VorbisTrack>> cuePoints;
    private double gain;
    private double pitch;
    @NotNull
    private final Event<VorbisTrack> finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VorbisTrack(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        this.playing = new AtomicBoolean(false);
        this.stopRequested = new AtomicBoolean(false);
        this.cuePoints = new LinkedHashMap();
        this.gain = 1.0;
        this.pitch = 1.0;
        this.finished = new Event("finished", false, 2, null);
        this.encodedAudio = this.ioResourceToByteBuffer(filePath, 262144);
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer intBuffer = stack.mallocInt(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer, "mallocInt(...)");
            IntBuffer error = intBuffer;
            this.handle = STBVorbis.stb_vorbis_open_memory(this.encodedAudio, error, null);
            if (this.handle == 0L) {
                throw new RuntimeException("Failed to open Ogg Vorbis file. Error: " + error.get(0));
            }
            STBVorbisInfo sTBVorbisInfo = STBVorbisInfo.malloc(stack);
            Intrinsics.checkNotNullExpressionValue(sTBVorbisInfo, "malloc(...)");
            STBVorbisInfo info = sTBVorbisInfo;
            this.print(info);
            this.channels = info.channels();
            this.sampleRate = info.sample_rate();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        this.samplesLength = STBVorbis.stb_vorbis_stream_length_in_samples(this.handle);
        this.samplesSec = STBVorbis.stb_vorbis_stream_length_in_seconds(this.handle);
        this.sampleIndex = new AtomicInteger(0);
        this.sampleIndex.set(0);
    }

    public final int getChannels() {
        return this.channels;
    }

    public final void setChannels(int n) {
        this.channels = n;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public final int getSamplesLength() {
        return this.samplesLength;
    }

    public final float getSamplesSec() {
        return this.samplesSec;
    }

    @NotNull
    public final AtomicInteger getSampleIndex() {
        return this.sampleIndex;
    }

    public final double duration() {
        return this.samplesSec;
    }

    public final double getGain() {
        return this.gain;
    }

    public final void setGain(double value2) {
        block1: {
            this.gain = value2;
            if (this.audioRenderer != null) {
                EXTThreadLocalContext.alcSetThreadContext(AudioSystem.INSTANCE.getContext());
            }
            AudioRenderer audioRenderer = this.audioRenderer;
            if (audioRenderer == null) break block1;
            audioRenderer.gain(value2);
        }
    }

    public final double getPitch() {
        return this.pitch;
    }

    public final void setPitch(double value2) {
        block1: {
            this.pitch = value2;
            if (this.audioRenderer != null) {
                EXTThreadLocalContext.alcSetThreadContext(AudioSystem.INSTANCE.getContext());
            }
            AudioRenderer audioRenderer = this.audioRenderer;
            if (audioRenderer == null) break block1;
            audioRenderer.pitch(value2);
        }
    }

    @NotNull
    public final Event<VorbisTrack> getFinished() {
        return this.finished;
    }

    public final void play(@Nullable Double initialGain, boolean loop2) {
        if (initialGain != null) {
            this.setGain(initialGain);
        }
        if (!this.playing.get()) {
            this.playing.set(true);
            this.stopRequested.set(false);
            if (this.audioThread == null) {
                this.audioThread = ThreadsKt.thread$default(false, true, null, null, 0, () -> VorbisTrack.play$lambda$6(this, loop2), 29, null);
            }
        }
    }

    public static /* synthetic */ void play$default(VorbisTrack vorbisTrack, Double d, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        vorbisTrack.play(d, bl);
    }

    public final void stop() {
        if (this.playing.get()) {
            AudioPlayerKt.access$getLogger$p().info(VorbisTrack::stop$lambda$7);
            this.stopRequested.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer ioResourceToByteBuffer(String filePath, int blockSize) {
        Path path = Paths.get(filePath, new String[0]);
        if (Files.isReadable(path)) {
            Closeable closeable = Files.newByteChannel(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                SeekableByteChannel fc = (SeekableByteChannel)closeable;
                boolean bl = false;
                ByteBuffer buffer = ByteBuffer.allocateDirect((int)fc.size() + 1);
                buffer.order(ByteOrder.nativeOrder());
                while (fc.read(buffer) != -1) {
                }
                buffer.flip();
                Intrinsics.checkNotNull(buffer);
                ByteBuffer byteBuffer = buffer;
                return byteBuffer;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        throw new IllegalStateException(("could not load " + filePath).toString());
    }

    public final void destroy() {
        STBVorbis.stb_vorbis_close(this.handle);
    }

    public final void progressBy(int samples) {
        this.sampleIndex.set(this.sampleIndex.get() + samples);
    }

    public final void setSampleIndex(int sampleIndex) {
        this.sampleIndex.set(sampleIndex);
    }

    public final void pause() {
        block1: {
            if (this.audioRenderer != null) {
                EXTThreadLocalContext.alcSetThreadContext(AudioSystem.INSTANCE.getContext());
            }
            AudioRenderer audioRenderer = this.audioRenderer;
            if (audioRenderer == null) break block1;
            audioRenderer.pause();
        }
    }

    public final void resume() {
        block0: {
            AudioPlayerKt.access$getLogger$p().info(VorbisTrack::resume$lambda$10);
            AudioRenderer audioRenderer = this.audioRenderer;
            if (audioRenderer == null) break block0;
            audioRenderer.resume();
        }
    }

    public final void rewind() {
        this.seek(0);
    }

    public final void skip(int direction) {
        this.seek(Math.min(Math.max(0, STBVorbis.stb_vorbis_get_sample_offset(this.handle) + direction * this.sampleRate), this.samplesLength));
    }

    public final void skipTo(float offset0to1) {
        this.seek(Math.round((float)this.samplesLength * offset0to1));
    }

    public final double relativePosition() {
        return (double)this.sampleIndex.get() / (double)this.samplesLength;
    }

    public final double position() {
        return (double)this.sampleIndex.get() / (double)this.sampleRate;
    }

    public final void setPosition(double timeInSeconds) {
        this.seek((int)(timeInSeconds * (double)this.sampleRate));
    }

    public final synchronized int getSamples(@Nullable ShortBuffer pcm) {
        return STBVorbis.stb_vorbis_get_samples_short_interleaved(this.handle, this.channels, pcm);
    }

    private final synchronized void seek(int sampleIndex) {
        STBVorbis.stb_vorbis_seek(this.handle, sampleIndex);
        this.setSampleIndex(sampleIndex);
    }

    private final void print(STBVorbisInfo info) {
        STBVorbis.stb_vorbis_get_info(this.handle, info);
    }

    private static final boolean play$lambda$6$lambda$3(double $p, Double it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it <= $p;
    }

    private static final boolean play$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object play$lambda$6$lambda$5() {
        return "track finished";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit play$lambda$6(VorbisTrack this$0, boolean $loop) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        AudioRenderer audioRenderer = this$0.audioRenderer = new AudioRenderer(this$0);
        Intrinsics.checkNotNull(audioRenderer);
        ProgressUpdater progressUpdater2 = audioRenderer.getProgressUpdater();
        AudioRenderer audioRenderer2 = this$0.audioRenderer;
        Intrinsics.checkNotNull(audioRenderer2);
        if (!audioRenderer2.play(this$0.gain)) {
            throw new IllegalStateException("krak".toString());
        }
        while (!this$0.stopRequested.get()) {
            void $this$forEach$iv;
            AudioRenderer audioRenderer3 = this$0.audioRenderer;
            Intrinsics.checkNotNull(audioRenderer3);
            boolean haveWork = audioRenderer3.update($loop);
            Thread.sleep(5L);
            progressUpdater2.updateProgress();
            double p = this$0.position();
            Map<Double, Event<VorbisTrack>> $this$filterKeys$iv = this$0.cuePoints;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<Double, Event<VorbisTrack>> result$iv = new LinkedHashMap<Double, Event<VorbisTrack>>();
            for (Map.Entry<Double, Event<VorbisTrack>> entry$iv : $this$filterKeys$iv.entrySet()) {
                double it = ((Number)entry$iv.getKey()).doubleValue();
                boolean bl = false;
                if (!(it <= p)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map toTrigger = result$iv;
            Iterable $this$sortedBy$iv = MapsKt.toList(toTrigger);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                ((Event)it.getSecond()).trigger(this$0);
            }
            this$0.cuePoints.keySet().removeIf(arg_0 -> VorbisTrack.play$lambda$6$lambda$4(arg_0 -> VorbisTrack.play$lambda$6$lambda$3(p, arg_0), arg_0));
            if (haveWork) continue;
        }
        this$0.playing.set(false);
        AudioPlayerKt.access$getLogger$p().info(VorbisTrack::play$lambda$6$lambda$5);
        AudioRenderer audioRenderer4 = this$0.audioRenderer;
        if (audioRenderer4 != null) {
            audioRenderer4.destroy();
        }
        this$0.finished.trigger(this$0);
        return Unit.INSTANCE;
    }

    private static final Object stop$lambda$7() {
        return "requesting stop";
    }

    private static final Object resume$lambda$10() {
        return "resuming audio";
    }
}

