/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import audio.Channel;
import audio.VorbisChannel;
import demo.model.Demo;
import demo.view.DemoControllerKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.CharacterEvent;
import org.openrndr.KeyEvent;
import org.openrndr.KeyModifier;
import org.openrndr.MouseEvent;
import org.openrndr.Program;
import org.openrndr.events.Event;
import org.openrndr.events.EventKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u00105\u001a\u0002022\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u0013J\u0006\u00108\u001a\u00020\u0013J\u0006\u00109\u001a\u000202J\u0006\u0010:\u001a\u000202J\u0006\u0010;\u001a\u000202J\u0006\u0010<\u001a\u000202J\u0006\u0010=\u001a\u000202R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u001a\u0010!\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R&\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R&\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001e\u0010.\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001bR\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020201\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006>"}, d2={"Ldemo/view/DemoController;", "", "program", "Lorg/openrndr/Program;", "demo", "Ldemo/model/Demo;", "channel", "Laudio/Channel;", "<init>", "(Lorg/openrndr/Program;Ldemo/model/Demo;Laudio/Channel;)V", "getProgram", "()Lorg/openrndr/Program;", "getDemo", "()Ldemo/model/Demo;", "getChannel", "()Laudio/Channel;", "setChannel", "(Laudio/Channel;)V", "cuePoint", "", "getCuePoint", "()D", "setCuePoint", "(D)V", "enableUI", "", "getEnableUI", "()Z", "setEnableUI", "(Z)V", "pitch", "getPitch", "setPitch", "volume", "getVolume", "setVolume", "nextLayerObjectTime", "Lkotlin/Function1;", "getNextLayerObjectTime", "()Lkotlin/jvm/functions/Function1;", "setNextLayerObjectTime", "(Lkotlin/jvm/functions/Function1;)V", "previousLayerObjectTime", "getPreviousLayerObjectTime", "setPreviousLayerObjectTime", "value", "followPlayhead", "getFollowPlayhead", "centerPlayheadRequested", "Lorg/openrndr/events/Event;", "", "getCenterPlayheadRequested", "()Lorg/openrndr/events/Event;", "setupInteractions", "setPosition", "time", "position", "jumpToCuePoint", "pause", "resume", "error", "clearError", "deminityy"})
public final class DemoController {
    @NotNull
    private final Program program;
    @NotNull
    private final Demo demo;
    @NotNull
    private Channel channel;
    private double cuePoint;
    private boolean enableUI;
    private double pitch;
    private double volume;
    @NotNull
    private Function1<? super Double, Double> nextLayerObjectTime;
    @NotNull
    private Function1<? super Double, Double> previousLayerObjectTime;
    private boolean followPlayhead;
    @NotNull
    private final Event<Unit> centerPlayheadRequested;

    public DemoController(@NotNull Program program2, @NotNull Demo demo, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Intrinsics.checkNotNullParameter(demo, "demo");
        Intrinsics.checkNotNullParameter(channel, "channel");
        this.program = program2;
        this.demo = demo;
        this.channel = channel;
        this.pitch = 1.0;
        this.volume = 1.0;
        this.nextLayerObjectTime = DemoController::nextLayerObjectTime$lambda$0;
        this.previousLayerObjectTime = DemoController::previousLayerObjectTime$lambda$1;
        this.centerPlayheadRequested = new Event("center-requested", false, 2, null);
    }

    @NotNull
    public final Program getProgram() {
        return this.program;
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    @NotNull
    public final Channel getChannel() {
        return this.channel;
    }

    public final void setChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter(channel, "<set-?>");
        this.channel = channel;
    }

    public final double getCuePoint() {
        return this.cuePoint;
    }

    public final void setCuePoint(double d) {
        this.cuePoint = d;
    }

    public final boolean getEnableUI() {
        return this.enableUI;
    }

    public final void setEnableUI(boolean bl) {
        this.enableUI = bl;
    }

    public final double getPitch() {
        return this.pitch;
    }

    public final void setPitch(double d) {
        this.pitch = d;
    }

    public final double getVolume() {
        return this.volume;
    }

    public final void setVolume(double d) {
        this.volume = d;
    }

    @NotNull
    public final Function1<Double, Double> getNextLayerObjectTime() {
        return this.nextLayerObjectTime;
    }

    public final void setNextLayerObjectTime(@NotNull Function1<? super Double, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.nextLayerObjectTime = function1;
    }

    @NotNull
    public final Function1<Double, Double> getPreviousLayerObjectTime() {
        return this.previousLayerObjectTime;
    }

    public final void setPreviousLayerObjectTime(@NotNull Function1<? super Double, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.previousLayerObjectTime = function1;
    }

    public final boolean getFollowPlayhead() {
        return this.followPlayhead;
    }

    @NotNull
    public final Event<Unit> getCenterPlayheadRequested() {
        return this.centerPlayheadRequested;
    }

    public final void setupInteractions(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Event[] eventArray = new Event[]{program2.getMouse().getDragged(), program2.getMouse().getButtonDown()};
        EventKt.listen((Iterable)CollectionsKt.listOf(eventArray), arg_0 -> DemoController.setupInteractions$lambda$3(program2, this, arg_0));
        program2.getKeyboard().getCharacter().listen(arg_0 -> DemoController.setupInteractions$lambda$4(this, arg_0));
        program2.getKeyboard().getKeyRepeat().listen(arg_0 -> DemoController.setupInteractions$lambda$5(this, arg_0));
        program2.getKeyboard().getKeyDown().listen(arg_0 -> DemoController.setupInteractions$lambda$7(this, program2, arg_0));
    }

    public final void setPosition(double time) {
        this.channel.setPosition(time / this.demo.getTimeScale());
    }

    public final double position() {
        return this.channel.getPosition();
    }

    public final void jumpToCuePoint() {
        this.channel.setPosition(this.cuePoint / this.demo.getTimeScale());
    }

    public final void pause() {
        Channel channel = this.channel;
        Intrinsics.checkNotNull(channel, "null cannot be cast to non-null type audio.VorbisChannel");
        if (!((VorbisChannel)channel).getPaused()) {
            this.channel.pause();
        } else {
            this.channel.resume();
        }
    }

    public final void resume() {
        this.channel.resume();
    }

    public final void error() {
        this.channel.pause();
    }

    public final void clearError() {
    }

    private static final double nextLayerObjectTime$lambda$0(double currentTime) {
        return -1.0;
    }

    private static final double previousLayerObjectTime$lambda$1(double currentTime) {
        return -1.0;
    }

    private static final Object setupInteractions$lambda$3$lambda$2(double $time, DemoController this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "setting cue point to " + $time / this$0.demo.getTimeScale();
    }

    private static final Unit setupInteractions$lambda$3(Program $program, DemoController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter($program, "$program");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.getPropagationCancelled() && !it.getModifiers().contains((Object)KeyModifier.ALT)) {
            double timescale = (double)($program.getWidth() - 210) / (this$0.demo.getDuration() * this$0.demo.getTimeScale());
            double time = RangesKt.coerceAtLeast((it.getPosition().x() - 200.0) / timescale, 0.0);
            if (it.getModifiers().contains((Object)KeyModifier.SHIFT)) {
                this$0.cuePoint = time;
                DemoControllerKt.access$getLogger$p().info(() -> DemoController.setupInteractions$lambda$3$lambda$2(time, this$0));
            }
            this$0.channel.setPosition(time / this$0.demo.getTimeScale());
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupInteractions$lambda$4(DemoController this$0, CharacterEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getCharacter() == 'q') {
            this$0.pitch /= 2.0;
            this$0.channel.setPitch(this$0.pitch);
        }
        if (it.getCharacter() == 'w') {
            this$0.pitch *= 2.0;
            this$0.channel.setPitch(this$0.pitch);
        }
        if (it.getCharacter() == 'm') {
            this$0.volume = 1.0 - this$0.volume;
            this$0.channel.setVolume(this$0.volume);
        }
        if (it.getCharacter() == 'c') {
            this$0.centerPlayheadRequested.trigger(Unit.INSTANCE);
        }
        if (it.getCharacter() == 'f') {
            this$0.followPlayhead = !this$0.followPlayhead;
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupInteractions$lambda$5(DemoController this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        switch (it.getKey()) {
            case 262: {
                double nt = ((Number)this$0.nextLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.demo.getTimeScale());
                break;
            }
            case 263: {
                double nt = ((Number)this$0.previousLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.demo.getTimeScale());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Object setupInteractions$lambda$7$lambda$6(Program $program, DemoController this$0) {
        Intrinsics.checkNotNullParameter($program, "$program");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "setting cue point to " + $program.getSeconds() * this$0.demo.getTimeScale() / this$0.demo.getTimeScale();
    }

    private static final Unit setupInteractions$lambda$7(DemoController this$0, Program $program, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($program, "$program");
        Intrinsics.checkNotNullParameter(it, "it");
        switch (it.getKey()) {
            case 258: {
                this$0.enableUI = !this$0.enableUI;
                break;
            }
            case 268: {
                this$0.channel.setPosition(0.0);
                break;
            }
            case 262: {
                double nt = ((Number)this$0.nextLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.demo.getTimeScale());
                break;
            }
            case 263: {
                double nt = ((Number)this$0.previousLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.demo.getTimeScale());
                break;
            }
            case 264: {
                this$0.cuePoint = this$0.position() * this$0.demo.getTimeScale();
                DemoControllerKt.access$getLogger$p().info(() -> DemoController.setupInteractions$lambda$7$lambda$6($program, this$0));
                break;
            }
            case 265: {
                this$0.channel.setPosition(this$0.cuePoint / this$0.demo.getTimeScale());
                break;
            }
            case 32: {
                this$0.pause();
            }
        }
        return Unit.INSTANCE;
    }
}

