/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import demo.model.Demo;
import demo.model.Layer;
import demo.view.DemoController;
import demo.view.LayerView;
import demo.view.LazyMap;
import demo.view.ObjectView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00180\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006!"}, d2={"Ldemo/view/ObjectWidget;", "", "program", "Lorg/openrndr/Program;", "demo", "Ldemo/model/Demo;", "demoController", "Ldemo/view/DemoController;", "layerViews", "Ldemo/view/LazyMap;", "Ldemo/model/Layer;", "Ldemo/view/LayerView;", "<init>", "(Lorg/openrndr/Program;Ldemo/model/Demo;Ldemo/view/DemoController;Ldemo/view/LazyMap;)V", "getProgram", "()Lorg/openrndr/Program;", "getDemo", "()Ldemo/model/Demo;", "getDemoController", "()Ldemo/view/DemoController;", "getLayerViews", "()Ldemo/view/LazyMap;", "layerWatchers", "", "Lkotlin/Function0;", "getLayerWatchers", "()Ljava/util/List;", "setLayerWatchers", "(Ljava/util/List;)V", "renderUI", "", "time", "", "deminityy"})
@SourceDebugExtension(value={"SMAP\nObjectWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectWidget.kt\ndemo/view/ObjectWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1557#2:58\n1628#2,3:59\n*S KotlinDebug\n*F\n+ 1 ObjectWidget.kt\ndemo/view/ObjectWidget\n*L\n24#1:58\n24#1:59,3\n*E\n"})
public final class ObjectWidget {
    @NotNull
    private final Program program;
    @NotNull
    private final Demo demo;
    @NotNull
    private final DemoController demoController;
    @NotNull
    private final LazyMap<Layer, LayerView> layerViews;
    @NotNull
    private List<? extends Function0<Layer>> layerWatchers;

    public ObjectWidget(@NotNull Program program2, @NotNull Demo demo, @NotNull DemoController demoController, @NotNull LazyMap<Layer, LayerView> layerViews) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Intrinsics.checkNotNullParameter(demo, "demo");
        Intrinsics.checkNotNullParameter(demoController, "demoController");
        Intrinsics.checkNotNullParameter(layerViews, "layerViews");
        this.program = program2;
        this.demo = demo;
        this.demoController = demoController;
        this.layerViews = layerViews;
        this.layerWatchers = CollectionsKt.emptyList();
    }

    @NotNull
    public final Program getProgram() {
        return this.program;
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    @NotNull
    public final DemoController getDemoController() {
        return this.demoController;
    }

    @NotNull
    public final LazyMap<Layer, LayerView> getLayerViews() {
        return this.layerViews;
    }

    @NotNull
    public final List<Function0<Layer>> getLayerWatchers() {
        return this.layerWatchers;
    }

    public final void setLayerWatchers(@NotNull List<? extends Function0<Layer>> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.layerWatchers = list;
    }

    /*
     * WARNING - void declaration
     */
    public final void renderUI(double time) {
        void $this$mapTo$iv$iv;
        Function1[] $this$map$iv = (Function1[])this.layerWatchers;
        boolean $i$f$map = false;
        Function1[] function1Array = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Function0 function0 = (Function0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Layer)it.invoke());
        }
        $this$map$iv = new Function1[]{ObjectWidget::renderUI$lambda$1, ObjectWidget::renderUI$lambda$2};
        List sortedLayers = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$map$iv));
        Drawer drawer = this.program.getDrawer();
        drawer.clear(ColorRGBa.Companion.getGRAY().shade(0.25));
        Iterator iterator2 = ((Iterable)sortedLayers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int layerIndex = n++;
            Layer layer = (Layer)iterator2.next();
            LayerView lv = this.layerViews.get(layer);
            for (Layer.Object obj : layer.getObjects()) {
                Intrinsics.checkNotNull(obj.getTime());
                ObjectView ov = lv.getObjects().get(obj);
                double duration = ov.getEffectiveDuration();
                if (!(obj.getTime() <= time) || !(obj.getTime() + duration > time)) continue;
                DrawerKt.isolated(drawer, arg_0 -> ObjectWidget.renderUI$lambda$3(drawer, time, obj, duration, arg_0));
                Drawer.translate$default(drawer, 0.0, 30.0, null, 4, null);
            }
        }
    }

    private static final Comparable renderUI$lambda$1(Layer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.valueOf(it.getZIndex());
    }

    private static final Comparable renderUI$lambda$2(Layer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        File file = it.getSourceFile();
        return (Comparable)((Object)(file != null ? file.getName() : null));
    }

    private static final Unit renderUI$lambda$3(Drawer $drawer, double $time, Layer.Object $obj, double $duration, Drawer $this$isolated) {
        Object object;
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($obj, "$obj");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        Drawer.translate$default($drawer, (double)$this$isolated.getWidth() / 2.0 - ($time - $obj.getTime()) * 100.0, 0.0, null, 4, null);
        $drawer.setFill(ColorRGBa.Companion.getWHITE());
        $drawer.rectangle(0.0, 0.0, 100.0 * $duration, 20.0);
        $drawer.setFill(ColorRGBa.Companion.getBLACK());
        String string = $obj.getId();
        if (string == null) {
            string = "";
        }
        Layer.Object.ObjectType objectType = $obj.getType();
        String string2 = $obj.getPaint();
        List<String> list = $obj.getTexts();
        if (list == null || (list = CollectionsKt.joinToString$default(list, ", ", null, null, 0, null, null, 62, null)) == null) {
            list = "";
        }
        if ((object = $obj.getAssets()) == null || (object = CollectionsKt.joinToString$default((Iterable)object, ", ", null, null, 0, null, null, 62, null)) == null) {
            object = "";
        }
        $drawer.text(string + " " + objectType + " " + string2 + " " + (String)((Object)list) + "} " + (String)object, 10.0, 16.0);
        $drawer.setStroke(ColorRGBa.Companion.getRED());
        $drawer.lineSegment(($time - $obj.getTime()) * 100.0, 0.0, ($time - $obj.getTime()) * 100.0, 20.0);
        return Unit.INSTANCE;
    }
}

