/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import demo.model.Demo;
import demo.model.Layer;
import demo.view.DemoController;
import demo.view.LayerView;
import demo.view.LazyMap;
import demo.view.ObjectView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import lib.EfcurveKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Program;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSLa;
import org.openrndr.color.ColorXSVa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RectangleBatchBuilder;
import org.openrndr.draw.RenderTarget;
import org.openrndr.extra.color.presets.ColorsKt;
import org.openrndr.extra.color.spaces.ColorHPLUVa;
import org.openrndr.extra.color.spaces.ColorHPLUVaKt;
import org.openrndr.extra.color.spaces.ColorHSLUVa;
import org.openrndr.extra.color.spaces.ColorHSLUVaKt;
import org.openrndr.extra.color.spaces.ColorOKHSLa;
import org.openrndr.extra.color.spaces.ColorOKHSLaKt;
import org.openrndr.extra.color.spaces.ColorOKHSVa;
import org.openrndr.extra.color.spaces.ColorOKHSVaKt;
import org.openrndr.extra.color.spaces.ColorOKLABa;
import org.openrndr.extra.color.spaces.ColorOKLABaKt;
import org.openrndr.extra.color.spaces.ColorOKLCHa;
import org.openrndr.extra.color.spaces.ColorOKLCHaKt;
import org.openrndr.extra.color.spaces.ColorXSLUVa;
import org.openrndr.extra.color.spaces.ColorXSLUVaKt;
import org.openrndr.extra.color.tools.ColorRGBaExtensionsKt;
import org.openrndr.extra.fcurve.FCurve;
import org.openrndr.extra.textwriter.DrawerExtensionsKt;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010'\u001a\u00020(J\u0016\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020$J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u001e0\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020(X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00063"}, d2={"Ldemo/view/UIRenderer;", "", "program", "Lorg/openrndr/Program;", "demo", "Ldemo/model/Demo;", "demoController", "Ldemo/view/DemoController;", "layerViews", "Ldemo/view/LazyMap;", "Ldemo/model/Layer;", "Ldemo/view/LayerView;", "<init>", "(Lorg/openrndr/Program;Ldemo/model/Demo;Ldemo/view/DemoController;Ldemo/view/LazyMap;)V", "getProgram", "()Lorg/openrndr/Program;", "getDemo", "()Ldemo/model/Demo;", "getDemoController", "()Ldemo/view/DemoController;", "getLayerViews", "()Ldemo/view/LazyMap;", "showFCurves", "", "getShowFCurves", "()Z", "setShowFCurves", "(Z)V", "layerWatchers", "", "Lkotlin/Function0;", "getLayerWatchers", "()Ljava/util/List;", "setLayerWatchers", "(Ljava/util/List;)V", "viewBounds", "Lorg/openrndr/shape/Rectangle;", "getViewBounds", "()Lorg/openrndr/shape/Rectangle;", "timeScale", "", "layerLabelWidth", "getLayerLabelWidth", "()D", "project", "view", "Lorg/openrndr/math/Matrix44;", "rectangle", "renderUI", "", "time", "deminityy"})
@SourceDebugExtension(value={"SMAP\nUIRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIRenderer.kt\ndemo/view/UIRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ColorRGBaExtensions.kt\norg/openrndr/extra/color/tools/ColorRGBaExtensionsKt\n*L\n1#1,278:1\n1557#2:279\n1628#2,3:280\n145#3:283\n40#3,22:284\n*S KotlinDebug\n*F\n+ 1 UIRenderer.kt\ndemo/view/UIRenderer\n*L\n75#1:279\n75#1:280,3\n150#1:283\n150#1:284,22\n*E\n"})
public final class UIRenderer {
    @NotNull
    private final Program program;
    @NotNull
    private final Demo demo;
    @NotNull
    private final DemoController demoController;
    @NotNull
    private final LazyMap<Layer, LayerView> layerViews;
    private boolean showFCurves;
    @NotNull
    private List<? extends Function0<Layer>> layerWatchers;
    private final double layerLabelWidth;

    public UIRenderer(@NotNull Program program2, @NotNull Demo demo, @NotNull DemoController demoController, @NotNull LazyMap<Layer, LayerView> layerViews) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Intrinsics.checkNotNullParameter(demo, "demo");
        Intrinsics.checkNotNullParameter(demoController, "demoController");
        Intrinsics.checkNotNullParameter(layerViews, "layerViews");
        this.program = program2;
        this.demo = demo;
        this.demoController = demoController;
        this.layerViews = layerViews;
        this.layerWatchers = CollectionsKt.emptyList();
        this.layerLabelWidth = 200.0;
    }

    @NotNull
    public final Program getProgram() {
        return this.program;
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    @NotNull
    public final DemoController getDemoController() {
        return this.demoController;
    }

    @NotNull
    public final LazyMap<Layer, LayerView> getLayerViews() {
        return this.layerViews;
    }

    public final boolean getShowFCurves() {
        return this.showFCurves;
    }

    public final void setShowFCurves(boolean bl) {
        this.showFCurves = bl;
    }

    @NotNull
    public final List<Function0<Layer>> getLayerWatchers() {
        return this.layerWatchers;
    }

    public final void setLayerWatchers(@NotNull List<? extends Function0<Layer>> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.layerWatchers = list;
    }

    @NotNull
    public final Rectangle getViewBounds() {
        Matrix44 vi = this.program.getDrawer().getView().times(this.program.getDrawer().getModel()).inversed();
        Vector4 tl = vi.times(new Vector4(0.0, 0.0, 0.0, 1.0));
        Vector4 br = vi.times(new Vector4((double)RenderTarget.Companion.getActive().getWidth() - 0.0, (double)RenderTarget.Companion.getActive().getHeight() - 0.0, 0.0, 1.0));
        return new Rectangle(tl.xy(), br.x() - tl.x(), br.y() - tl.y());
    }

    public final double timeScale() {
        return ((double)RenderTarget.Companion.getActive().getWidth() - 210.0) / (this.demo.getDuration() * this.demo.getTimeScale());
    }

    public final double getLayerLabelWidth() {
        return this.layerLabelWidth;
    }

    @NotNull
    public final Rectangle project(@NotNull Matrix44 view, @NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        Vector2 tl = view.times(rectangle.corner().xy01()).xy();
        Vector2 br = view.times(rectangle.position(1.0, 1.0).xy01()).xy();
        return RectangleKt.Rectangle(tl.x(), tl.y(), br.x() - tl.x(), br.y() - tl.y());
    }

    /*
     * WARNING - void declaration
     */
    public final void renderUI(double time) {
        void $this$mapTo$iv$iv;
        Drawer drawer = this.program.getDrawer();
        Ref.ObjectRef oldView = new Ref.ObjectRef();
        oldView.element = drawer.getView();
        Ref.ObjectRef oldProjection = new Ref.ObjectRef();
        oldProjection.element = drawer.getProjection();
        double timescale = this.timeScale();
        int width = RenderTarget.Companion.getActive().getWidth();
        int height = RenderTarget.Companion.getActive().getHeight();
        double timeX = TransformsKt.project(new Vector3(time * timescale + this.layerLabelWidth), (Matrix44)oldProjection.element, (Matrix44)oldView.element, width, height).x();
        Function1[] $this$map$iv = (Function1[])this.layerWatchers;
        boolean $i$f$map = false;
        Function1[] function1Array = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Function0 function0 = (Function0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Layer)it.invoke());
        }
        $this$map$iv = new Function1[]{UIRenderer::renderUI$lambda$1, UIRenderer::renderUI$lambda$2};
        List sortedLayers = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$map$iv));
        drawer.clear(ColorRGBa.Companion.getGRAY().shade(0.25));
        Drawer.translate$default(drawer, this.layerLabelWidth, 0.0, null, 4, null);
        Rectangle vb = this.getViewBounds();
        Vector2 scaleXY = drawer.getView().times(new Vector4(1.0, 1.0, 0.0, 0.0)).xy();
        Vector2 offsetXY = drawer.getView().times(new Vector4(0.0, 0.0, 0.0, 1.0)).xy();
        DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$4(drawer, sortedLayers, this, time, timescale, scaleXY, offsetXY, arg_0));
        if (this.showFCurves) {
            DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$7(drawer, sortedLayers, this, time, timescale, vb, oldView, scaleXY, timeX, offsetXY, arg_0));
        }
        DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$8(drawer, sortedLayers, oldProjection, oldView, width, height, arg_0));
        double cuePointX = TransformsKt.project(new Vector3(this.demoController.getCuePoint() * timescale + this.layerLabelWidth), (Matrix44)oldProjection.element, (Matrix44)oldView.element, width, height).x();
        DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$13(drawer, timeX, height, time, this, cuePointX, arg_0));
    }

    private static final Comparable renderUI$lambda$1(Layer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.valueOf(it.getZIndex());
    }

    private static final Comparable renderUI$lambda$2(Layer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        File file = it.getSourceFile();
        return (Comparable)((Object)(file != null ? file.getName() : null));
    }

    private static final Unit renderUI$lambda$4$lambda$3(List $sortedLayers, UIRenderer this$0, double $time, double $timescale, Vector2 $scaleXY, Vector2 $offsetXY, RectangleBatchBuilder $this$rectangles) {
        Intrinsics.checkNotNullParameter($sortedLayers, "$sortedLayers");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($scaleXY, "$scaleXY");
        Intrinsics.checkNotNullParameter($offsetXY, "$offsetXY");
        Intrinsics.checkNotNullParameter($this$rectangles, "$this$rectangles");
        $this$rectangles.setStroke(ColorRGBa.Companion.getBLACK());
        $this$rectangles.setStrokeWeight(0.1);
        Iterator iterator2 = ((Iterable)$sortedLayers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int layerIndex = n++;
            Layer layer = (Layer)iterator2.next();
            LayerView lv = this$0.layerViews.get(layer);
            Iterator iterator3 = ((Iterable)layer.getObjects()).iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                int index = n2++;
                Layer.Object obj = (Layer.Object)iterator3.next();
                Intrinsics.checkNotNull(obj.getTime());
                $this$rectangles.setFill(layerIndex % 2 == 0 ? ColorRGBa.Companion.getGRAY() : ColorRGBa.Companion.getGRAY().shade(0.5));
                ObjectView ov = lv.getObjects().get(obj);
                double duration = ov.getEffectiveDuration();
                if (obj.getTime() <= $time && obj.getTime() + duration > $time) {
                    $this$rectangles.setFill(ColorRGBa.Companion.getWHITE());
                }
                RectangleBatchBuilder.rectangle$default($this$rectangles, (this$0.layerLabelWidth + obj.getTime() * $timescale) * $scaleXY.x() + $offsetXY.x(), (double)(layerIndex + 1) * 24.0 * $scaleXY.y() + $offsetXY.y(), duration * $timescale * $scaleXY.x(), 16.0 * $scaleXY.y(), 0.0, 16, null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$4(Drawer $drawer, List $sortedLayers, UIRenderer this$0, double $time, double $timescale, Vector2 $scaleXY, Vector2 $offsetXY, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($sortedLayers, "$sortedLayers");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($scaleXY, "$scaleXY");
        Intrinsics.checkNotNullParameter($offsetXY, "$offsetXY");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        $drawer.rectangles(arg_0 -> UIRenderer.renderUI$lambda$4$lambda$3($sortedLayers, this$0, $time, $timescale, $scaleXY, $offsetXY, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$7$lambda$6(Rectangle $pr, UIRenderer this$0, Vector2 $scaleXY, Layer.Object $obj, ObjectView $ov, double $time, TextWriter $this$writer) {
        Intrinsics.checkNotNullParameter($pr, "$pr");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($scaleXY, "$scaleXY");
        Intrinsics.checkNotNullParameter($obj, "$obj");
        Intrinsics.checkNotNullParameter($ov, "$ov");
        Intrinsics.checkNotNullParameter($this$writer, "$this$writer");
        $this$writer.setBox($pr.movedBy(new Vector2(this$0.layerLabelWidth, 0.0).times($scaleXY)));
        $this$writer.newLine();
        $this$writer.newLine();
        Object object = $obj.getType();
        if (object == null || (object = object.toString()) == null) {
            object = "?";
        }
        TextWriter.text$default($this$writer, (String)object, false, 2, null);
        $this$writer.newLine();
        TextWriter.text$default($this$writer, "asset: " + $ov.effectiveAsset($time), false, 2, null);
        $this$writer.newLine();
        TextWriter.text$default($this$writer, "font: " + $ov.effectiveFont($time), false, 2, null);
        $this$writer.newLine();
        TextWriter.text$default($this$writer, "text: " + $ov.effectiveText($time), false, 2, null);
        $this$writer.newLine();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderUI$lambda$7(Drawer $drawer, List $sortedLayers, UIRenderer this$0, double $time, double $timescale, Rectangle $vb, Ref.ObjectRef $oldView, Vector2 $scaleXY, double $timeX, Vector2 $offsetXY, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($sortedLayers, "$sortedLayers");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($vb, "$vb");
        Intrinsics.checkNotNullParameter($oldView, "$oldView");
        Intrinsics.checkNotNullParameter($scaleXY, "$scaleXY");
        Intrinsics.checkNotNullParameter($offsetXY, "$offsetXY");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        $drawer.setStrokeWeight(0.1);
        Iterator iterator2 = ((Iterable)$sortedLayers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int layerIndex = n++;
            Layer layer = (Layer)iterator2.next();
            LayerView lv = this$0.layerViews.get(layer);
            Drawer $this$renderUI_u24lambda_u247_u24lambda_u245 = $this$isolated;
            boolean bl = false;
            double x = layer.getTime() * $timescale * $scaleXY.x() + this$0.layerLabelWidth * $scaleXY.x() + $offsetXY.x();
            double y0 = ((double)(layerIndex + 1) * 24.0 - 4.0) * $scaleXY.y() + $offsetXY.y();
            double y1 = ((double)(layerIndex + 2) * 24.0 - 4.0) * $scaleXY.y() + $offsetXY.y();
            $drawer.setStroke(ColorsKt.getDARK_ORANGE(ColorRGBa.Companion));
            $drawer.setStrokeWeight(1.0);
            $drawer.lineSegment(x, y0, x, y1);
            $drawer.setStrokeWeight(0.1);
            for (Layer.Object obj : layer.getObjects()) {
                Intrinsics.checkNotNull(obj.getTime());
                ObjectView ov = lv.getObjects().get(obj);
                double duration = ov.getEffectiveDuration();
                boolean active = obj.getTime() <= $time && obj.getTime() + duration > $time;
                Rectangle r = RectangleKt.Rectangle(obj.getTime() * $timescale, (double)(layerIndex + 1) * 24.0, duration * $timescale, 16.0);
                if (!active || !r.intersects($vb)) continue;
                Rectangle pr = this$0.project((Matrix44)$oldView.element, r);
                for (Map.Entry<String, FCurve> entry : ov.getFcurves().entrySet()) {
                    ColorHSLa converted$iv$iv;
                    AlgebraicColor<ColorHSLa> algebraicColor;
                    void $this$shiftHue$iv;
                    String key = entry.getKey();
                    FCurve fc = entry.getValue();
                    FCurve tfc = EfcurveKt.subX(fc, 0.0, duration);
                    Rectangle tfcBounds = tfc.getBounds();
                    double hs = tfcBounds.height() == 0.0 ? -1.0 : -16.0 / tfcBounds.height();
                    double ho = tfcBounds.height() == 0.0 ? 0.5 : 0.0;
                    ColorRGBa colorRGBa = ColorRGBa.Companion.getRED();
                    double degrees$iv = key.hashCode();
                    boolean $i$f$shiftHue = false;
                    void $this$convertTo$iv$iv = $this$shiftHue$iv;
                    boolean $i$f$convertTo = false;
                    KClass kClass = Reflection.getOrCreateKotlinClass(ColorHSVa.class);
                    if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHSLa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toHSLa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHSVa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toHSVa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorRGBa.class))) {
                        algebraicColor = $this$convertTo$iv$iv;
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHPLUVa.class))) {
                        algebraicColor = ColorHPLUVaKt.toHPLUVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHSLUVa.class))) {
                        algebraicColor = ColorHSLUVaKt.toHSLUVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKLABa.class))) {
                        algebraicColor = ColorOKLABaKt.toOKLABa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKLCHa.class))) {
                        algebraicColor = ColorOKLCHaKt.toOKLCHa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKHSLa.class))) {
                        algebraicColor = ColorOKHSLaKt.toOKHSLa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKHSVa.class))) {
                        algebraicColor = ColorOKHSVaKt.toOKHSVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLABa.class))) {
                        algebraicColor = ColorRGBa.toLABa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLUVa.class))) {
                        algebraicColor = ColorRGBa.toLUVa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLCHABa.class))) {
                        algebraicColor = ColorRGBa.toLCHABa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLCHUVa.class))) {
                        algebraicColor = ColorRGBa.toLCHUVa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKHSLa.class))) {
                        algebraicColor = ColorOKHSLaKt.toOKHSLa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXYZa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toXYZa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXSLUVa.class))) {
                        algebraicColor = ColorXSLUVaKt.toXSLUVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXSVa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toXSVa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXSLa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toXSLa();
                    } else {
                        throw new IllegalStateException(("color model " + Reflection.getOrCreateKotlinClass(ColorHSVa.class) + " not supported").toString());
                    }
                    ColorHSLa colorHSLa = converted$iv$iv = algebraicColor;
                    if (colorHSLa == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrndr.color.ColorHSVa");
                    }
                    $drawer.setStroke(ColorRGBaExtensionsKt.matchLinearity(((ConvertibleToColorRGBa)((HueShiftableColor)((Object)((ColorModel)((ColorHSVa)((Object)colorHSLa))))).shiftHue(degrees$iv)).toRGBa(), (ColorRGBa)$this$shiftHue$iv));
                    $drawer.contours(tfc.contours(new Vector2($timescale * $scaleXY.x(), hs * $scaleXY.y()), new Vector2(this$0.layerLabelWidth, 0.0).times($scaleXY).plus(pr.position(0.0, ho)).minus(tfcBounds.position(0.0, 1.0).times($scaleXY).times(hs))));
                }
                $drawer.setFill(ColorRGBa.Companion.getBLACK());
                String string = "%.3f";
                Object[] objectArray = new Object[]{obj.getTime() * this$0.demo.getTimeScale()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                $drawer.text(string2, new Vector2(this$0.layerLabelWidth, 0.0).times($scaleXY).plus(pr.position(0.0, 0.0)).plus(new Vector2(5.0, 10.0)));
                String object2 = "%.3f";
                objectArray = new Object[]{(this$0.demoController.position() - obj.getTime()) * this$0.demo.getTimeScale()};
                String string3 = String.format(object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                $drawer.text(string3, new Vector2($timeX, pr.position(0.0, 0.0).y()).plus(new Vector2(5.0, 26.0)));
                DrawerExtensionsKt.drawerWriter($this$isolated, arg_0 -> UIRenderer.renderUI$lambda$7$lambda$6(pr, this$0, $scaleXY, obj, ov, $time, arg_0));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$8(Drawer $drawer, List $sortedLayers, Ref.ObjectRef $oldProjection, Ref.ObjectRef $oldView, int $width, int $height, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($sortedLayers, "$sortedLayers");
        Intrinsics.checkNotNullParameter($oldProjection, "$oldProjection");
        Intrinsics.checkNotNullParameter($oldView, "$oldView");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        Iterator iterator2 = ((Iterable)$sortedLayers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int layerIndex = n++;
            Layer layer = (Layer)iterator2.next();
            $drawer.setFill(ColorRGBa.Companion.getBLACK());
            double y = TransformsKt.project(new Vector3(0.0, (double)(layerIndex + 2) * 24.0 - 4.0, 0.0), (Matrix44)$oldProjection.element, (Matrix44)$oldView.element, $width, $height).y();
            double ty = TransformsKt.project(new Vector3(0.0, (double)(layerIndex + 2) * 24.0 - 16.0, 0.0), (Matrix44)$oldProjection.element, (Matrix44)$oldView.element, $width, $height).y();
            Object object = layer.getSourceFile();
            if (object == null || (object = FilesKt.getNameWithoutExtension((File)object)) == null) {
                object = "";
            }
            $drawer.text((String)object, 11.0, ty + 4.0);
            $drawer.setFill(layer.getEnabled() ? (layerIndex % 2 == 0 ? ColorRGBa.Companion.getWHITE() : ColorRGBa.Companion.getWHITE().shade(0.85)) : ColorRGBa.Companion.getWHITE().shade(0.2));
            Object object2 = layer.getSourceFile();
            if (object2 == null || (object2 = FilesKt.getNameWithoutExtension((File)object2)) == null) {
                object2 = "";
            }
            $drawer.text((String)object2, 10.0, ty - 1.0 + 4.0);
            $drawer.setStroke(ColorRGBa.Companion.getBLACK().opacify(0.5));
            $drawer.lineSegment(0.0, y, (double)$width * 1.0, y);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$13$lambda$12$lambda$11(Drawer $drawer, double $time, UIRenderer this$0, double $lx, int $height, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        String string = "%.3f";
        Object[] objectArray = new Object[]{$time - this$0.demoController.getCuePoint()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        $drawer.text(string2, $lx, (double)$height - 24.0);
        $drawer.setFill(ColorRGBa.Companion.getPINK().shade(0.5));
        string = "%.3fs";
        objectArray = new Object[]{($time - this$0.demoController.getCuePoint()) / this$0.demo.getTimeScale()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        $drawer.text(string3, $lx + 64.0, (double)$height - 24.0);
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$13(Drawer $drawer, double $timeX, int $height, double $time, UIRenderer this$0, double $cuePointX, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        Drawer $this$renderUI_u24lambda_u2413_u24lambda_u249 = $this$isolated;
        boolean bl = false;
        $drawer.setStroke(ColorRGBa.Companion.getGREEN());
        double x = $timeX;
        $drawer.lineSegment(x, 0.0, x, $height);
        $drawer.setFill(ColorRGBa.Companion.getGREEN());
        double lx = RangesKt.coerceAtMost(x + 12.0, (double)RenderTarget.Companion.getActive().getWidth() - 140.0);
        String string = "%.3f";
        Object[] objectArray = new Object[]{$time};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        string = "%.3fs";
        objectArray = new Object[]{$time / this$0.demo.getTimeScale()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        $drawer.text(string2 + " / " + string3, lx, 12.0);
        Drawer $this$renderUI_u24lambda_u2413_u24lambda_u2410 = $this$isolated;
        boolean bl2 = false;
        $drawer.setStroke(ColorRGBa.Companion.getBLUE());
        x = $cuePointX;
        $drawer.lineSegment(x, 0.0, x, $height);
        $drawer.setFill(ColorRGBa.Companion.getBLUE());
        lx = RangesKt.coerceAtMost(x + 12.0, (double)RenderTarget.Companion.getActive().getWidth() - 140.0);
        string = "%.3f";
        objectArray = new Object[]{this$0.demoController.getCuePoint()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        string = "%.3fs";
        objectArray = new Object[]{this$0.demoController.getCuePoint() / this$0.demo.getTimeScale()};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
        $drawer.text(string4 + " / " + string5, lx, (double)$height - 12.0);
        Drawer $this$renderUI_u24lambda_u2413_u24lambda_u2412 = $this$isolated;
        boolean bl3 = false;
        double x0 = $timeX;
        double x1 = $cuePointX;
        $drawer.setFill(ColorRGBa.Companion.getPINK());
        $drawer.setStroke(ColorRGBa.Companion.getPINK());
        double y = (double)$height - 24.0;
        $drawer.lineSegment(x0, y, x1, y);
        double lx2 = ($timeX + $cuePointX) / 2.0 - 50.0;
        DrawerKt.isolated($drawer, arg_0 -> UIRenderer.renderUI$lambda$13$lambda$12$lambda$11($drawer, $time, this$0, lx2, $height, arg_0));
        return Unit.INSTANCE;
    }
}

