/*
 * Decompiled with CFR 0.152.
 */
package demo.view.post;

import demo.model.Demo;
import demo.model.post.Post;
import demo.view.DemoController;
import demo.view.TargetManager;
import demo.view.post.PipelineView;
import demo.view.post.PostRendererKt;
import filewatcher.FileWatcherKt;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import lib.EfcurveKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Program;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.extra.fcurve.CompoundFCurve;
import org.openrndr.extra.fcurve.FCurve;
import org.openrndr.extra.fcurve.MultiFCurve;
import org.openrndr.extra.fcurve.MultiFCurveExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00014B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR)\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b \u0010\u0018R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u00065"}, d2={"Ldemo/view/post/PostRenderer;", "", "program", "Lorg/openrndr/Program;", "demo", "Ldemo/model/Demo;", "targetManager", "Ldemo/view/TargetManager;", "demoController", "Ldemo/view/DemoController;", "context", "Lkotlin/Function1;", "", "<init>", "(Lorg/openrndr/Program;Ldemo/model/Demo;Ldemo/view/TargetManager;Ldemo/view/DemoController;Lkotlin/jvm/functions/Function1;)V", "getProgram", "()Lorg/openrndr/Program;", "getDemo", "()Ldemo/model/Demo;", "getTargetManager", "()Ldemo/view/TargetManager;", "getDemoController", "()Ldemo/view/DemoController;", "getContext", "()Lkotlin/jvm/functions/Function1;", "pipelineViews", "", "Ldemo/model/post/Post$Pipeline;", "Ldemo/view/post/PipelineView;", "getPipelineViews", "()Ljava/util/Map;", "environment", "getEnvironment", "environment$delegate", "Lkotlin/Lazy;", "animation", "Ldemo/view/post/PostRenderer$Animation;", "getAnimation", "()Ldemo/view/post/PostRenderer$Animation;", "setAnimation", "(Ldemo/view/post/PostRenderer$Animation;)V", "postWatcher", "Lkotlin/Function0;", "Ldemo/model/post/Post;", "getPostWatcher", "()Lkotlin/jvm/functions/Function0;", "renderPost", "", "time", "", "input", "Lorg/openrndr/draw/ColorBuffer;", "Animation", "deminityy"})
public final class PostRenderer {
    @NotNull
    private final Program program;
    @NotNull
    private final Demo demo;
    @NotNull
    private final TargetManager targetManager;
    @NotNull
    private final DemoController demoController;
    @NotNull
    private final Function1<String, Object> context;
    @NotNull
    private final Map<Post.Pipeline, PipelineView> pipelineViews;
    @NotNull
    private final Lazy environment$delegate;
    @NotNull
    private Animation animation;
    @NotNull
    private final Function0<Post> postWatcher;

    public PostRenderer(@NotNull Program program2, @NotNull Demo demo, @NotNull TargetManager targetManager, @NotNull DemoController demoController, @NotNull Function1<? super String, ? extends Object> context) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Intrinsics.checkNotNullParameter(demo, "demo");
        Intrinsics.checkNotNullParameter(targetManager, "targetManager");
        Intrinsics.checkNotNullParameter(demoController, "demoController");
        Intrinsics.checkNotNullParameter(context, "context");
        this.program = program2;
        this.demo = demo;
        this.targetManager = targetManager;
        this.demoController = demoController;
        this.context = context;
        this.pipelineViews = new LinkedHashMap();
        this.environment$delegate = LazyKt.lazy(() -> PostRenderer.environment_delegate$lambda$1(this));
        this.animation = new Animation(MapsKt.emptyMap(), this.demoController);
        this.postWatcher = FileWatcherKt.watchFile(this.program, new File(this.demo.getDataBase(), "post/post.conf"), arg_0 -> PostRenderer.postWatcher$lambda$4(this, arg_0));
    }

    @NotNull
    public final Program getProgram() {
        return this.program;
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    @NotNull
    public final TargetManager getTargetManager() {
        return this.targetManager;
    }

    @NotNull
    public final DemoController getDemoController() {
        return this.demoController;
    }

    @NotNull
    public final Function1<String, Object> getContext() {
        return this.context;
    }

    @NotNull
    public final Map<Post.Pipeline, PipelineView> getPipelineViews() {
        return this.pipelineViews;
    }

    @NotNull
    public final Function1<String, Object> getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (Function1)lazy.getValue();
    }

    @NotNull
    public final Animation getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter(animation, "<set-?>");
        this.animation = animation;
    }

    @NotNull
    public final Function0<Post> getPostWatcher() {
        return this.postWatcher;
    }

    public final void renderPost(double time, @NotNull ColorBuffer input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Post post = this.postWatcher.invoke();
        String pipelineName = CollectionsKt.getOrNull(post.getPipelines(), RangesKt.coerceIn(((Number)this.animation.getPipelineIndex().invoke(time)).intValue(), CollectionsKt.getIndices((Collection)post.getPipelines())));
        Post.Pipeline pipeline = post.getPipelineDefinitions().get(pipelineName);
        if (pipeline == null) {
            throw new IllegalStateException("pipeline not found".toString());
        }
        Post.Pipeline pipeline2 = pipeline;
        PipelineView pipelineView = this.pipelineViews.get(pipeline2);
        if (pipelineView != null) {
            pipelineView.render(time);
        } else {
            ColorBuffer.copyTo$default(input, this.targetManager.getColorBuffers().get("output"), 0, 0, null, 14, null);
        }
    }

    private static final Object environment_delegate$lambda$1$lambda$0(PostRenderer this$0, String n) {
        return this$0.context.invoke(n);
    }

    private static final Function1 environment_delegate$lambda$1(PostRenderer this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return arg_0 -> PostRenderer.environment_delegate$lambda$1$lambda$0(this$0, arg_0);
    }

    private static final Unit postWatcher$lambda$4$lambda$2(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Object postWatcher$lambda$4$lambda$3(File $it, PostRenderer this$0) {
        Intrinsics.checkNotNullParameter($it, "$it");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return $it.getPath() + " changed, jumping to " + this$0.demoController.getCuePoint() / this$0.demo.getTimeScale();
    }

    private static final Post postWatcher$lambda$4(PostRenderer this$0, File it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        Post post = Post.Companion.loadFromHocon(it).resolve(this$0.context);
        this$0.animation = new Animation(post.getFcurves(), this$0.demoController);
        for (Map.Entry<Post.Pipeline, PipelineView> entry : this$0.pipelineViews.entrySet()) {
            entry.getValue().close();
        }
        this$0.pipelineViews.clear();
        for (Map.Entry<Object, Object> entry : post.getPipelineDefinitions().entrySet()) {
            this$0.pipelineViews.put((Post.Pipeline)entry.getValue(), new PipelineView((Post.Pipeline)entry.getValue(), this$0.targetManager, PostRenderer::postWatcher$lambda$4$lambda$2));
        }
        PostRendererKt.access$getLogger$p().info(() -> PostRenderer.postWatcher$lambda$4$lambda$3(it, this$0));
        this$0.demoController.jumpToCuePoint();
        return post;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldemo/view/post/PostRenderer$Animation;", "Lorg/openrndr/extra/fcurve/MultiFCurve;", "fcurves", "", "", "demoController", "Ldemo/view/DemoController;", "<init>", "(Ljava/util/Map;Ldemo/view/DemoController;)V", "pipelineIndex", "Lkotlin/Function1;", "", "", "getPipelineIndex", "()Lkotlin/jvm/functions/Function1;", "deminityy"})
    @SourceDebugExtension(value={"SMAP\nPostRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostRenderer.kt\ndemo/view/post/PostRenderer$Animation\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n462#2:77\n412#2:78\n1246#3,4:79\n*S KotlinDebug\n*F\n+ 1 PostRenderer.kt\ndemo/view/post/PostRenderer$Animation\n*L\n39#1:77\n39#1:78\n39#1:79,4\n*E\n"})
    public static final class Animation
    extends MultiFCurve {
        @NotNull
        private final Function1<Double, Integer> pipelineIndex;

        /*
         * WARNING - void declaration
         */
        public Animation(@NotNull Map<String, String> fcurves, @NotNull DemoController demoController) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Intrinsics.checkNotNullParameter(fcurves, "fcurves");
            Intrinsics.checkNotNullParameter(demoController, "demoController");
            Map<String, String> map2 = fcurves;
            Animation animation = this;
            boolean $i$f$mapValues = false;
            void var5_6 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                FCurve fCurve = EfcurveKt.efcurveOrNull$default((String)it.getValue(), null, null, arg_0 -> Animation._init_$lambda$2$lambda$1(demoController, (Map.Entry)it, arg_0), 6, null);
                map4.put(k, fCurve);
            }
            super(destination$iv$iv);
            this.pipelineIndex = CompoundFCurve.sampler$default(MultiFCurveExtensionsKt.int(this, "pipeline-index", 0), false, 1, null);
        }

        @NotNull
        public final Function1<Double, Integer> getPipelineIndex() {
            return this.pipelineIndex;
        }

        private static final Object _init_$lambda$2$lambda$1$lambda$0(Map.Entry $it, Throwable $error) {
            Intrinsics.checkNotNullParameter($it, "$it");
            Intrinsics.checkNotNullParameter($error, "$error");
            return $it.getKey() + ": " + $error.getMessage();
        }

        private static final Unit _init_$lambda$2$lambda$1(DemoController $demoController, Map.Entry $it, Throwable error) {
            Intrinsics.checkNotNullParameter($demoController, "$demoController");
            Intrinsics.checkNotNullParameter($it, "$it");
            Intrinsics.checkNotNullParameter(error, "error");
            PostRendererKt.access$getLogger$p().error(() -> Animation._init_$lambda$2$lambda$1$lambda$0($it, error));
            $demoController.error();
            return Unit.INSTANCE;
        }
    }
}

