/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.internal.CborEncoder;
import kotlinx.serialization.cbor.internal.CborListWriter;
import kotlinx.serialization.cbor.internal.CborMapWriter;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u0002H\u0012H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u00101\u001a\u00020\u0011H\u0016J\u0018\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "cbor", "Lkotlinx/serialization/cbor/Cbor;", "encoder", "Lkotlinx/serialization/cbor/internal/CborEncoder;", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborEncoder;)V", "getEncoder", "()Lkotlinx/serialization/cbor/internal/CborEncoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "encodeByteArrayAsByteString", "", "encodeSerializableValue", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "shouldEncodeElementDefault", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "writeBeginToken", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "endStructure", "encodeElement", "encodeString", "", "encodeFloat", "", "encodeDouble", "", "encodeChar", "", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeLong", "", "encodeBoolean", "encodeNull", "encodeEnum", "enumDescriptor", "kotlinx-serialization-cbor"})
public class CborWriter
extends AbstractEncoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final CborEncoder encoder;
    private boolean encodeByteArrayAsByteString;

    public CborWriter(@NotNull Cbor cbor, @NotNull CborEncoder encoder) {
        Intrinsics.checkNotNullParameter(cbor, "cbor");
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        this.cbor = cbor;
        this.encoder = encoder;
    }

    @NotNull
    protected final CborEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.cbor.getSerializersModule();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value2) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        if (this.encodeByteArrayAsByteString && Intrinsics.areEqual(serializer2.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.ByteArray");
            this.encoder.encodeByteString((byte[])value2);
        } else {
            this.encodeByteArrayAsByteString = this.encodeByteArrayAsByteString || EncodingKt.access$isInlineByteString(serializer2.getDescriptor());
            super.encodeSerializableValue(serializer2, value2);
        }
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.cbor.getEncodeDefaults$kotlinx_serialization_cbor();
    }

    protected void writeBeginToken() {
        this.encoder.startMap();
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        CborWriter writer = Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind ? (CborWriter)new CborListWriter(this.cbor, this.encoder) : (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE) ? (CborWriter)new CborMapWriter(this.cbor, this.encoder) : new CborWriter(this.cbor, this.encoder));
        writer.writeBeginToken();
        return writer;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encoder.end();
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeByteArrayAsByteString = EncodingKt.access$isByteString(descriptor2, index);
        String name = descriptor2.getElementName(index);
        this.encoder.encodeString(name);
        return true;
    }

    @Override
    public void encodeString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.encoder.encodeString(value2);
    }

    @Override
    public void encodeFloat(float value2) {
        this.encoder.encodeFloat(value2);
    }

    @Override
    public void encodeDouble(double value2) {
        this.encoder.encodeDouble(value2);
    }

    @Override
    public void encodeChar(char value2) {
        this.encoder.encodeNumber(value2);
    }

    @Override
    public void encodeByte(byte value2) {
        this.encoder.encodeNumber(value2);
    }

    @Override
    public void encodeShort(short value2) {
        this.encoder.encodeNumber(value2);
    }

    @Override
    public void encodeInt(int value2) {
        this.encoder.encodeNumber(value2);
    }

    @Override
    public void encodeLong(long value2) {
        this.encoder.encodeNumber(value2);
    }

    @Override
    public void encodeBoolean(boolean value2) {
        this.encoder.encodeBoolean(value2);
    }

    @Override
    public void encodeNull() {
        this.encoder.encodeNull();
    }

    @Override
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        this.encoder.encodeString(enumDescriptor.getElementName(index));
    }
}

