/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.hocon.Hocon;
import kotlinx.serialization.hocon.HoconConfigEncoder;
import kotlinx.serialization.hocon.HoconConfigListEncoder;
import kotlinx.serialization.hocon.HoconConfigMapEncoder;
import kotlinx.serialization.hocon.HoconEncoder;
import kotlinx.serialization.hocon.HoconSerialKindKt;
import kotlinx.serialization.hocon.NamingConventionKt;
import kotlinx.serialization.hocon.internal.HoconDurationKt;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.NamedValueEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b!\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0014J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0007H$J\b\u0010\u001d\u001a\u00020\u0007H$J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0012H\u0014J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\"H\u0014J \u0010#\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0016H\u0014J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J)\u0010'\u001a\u00020\b\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\u0006\u0010\u001c\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010/\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u001f\u00100\u001a\n 1*\u0004\u0018\u00010\u00070\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u00102R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkotlinx/serialization/hocon/AbstractHoconEncoder;", "Lkotlinx/serialization/internal/NamedValueEncoder;", "Lkotlinx/serialization/hocon/HoconEncoder;", "hocon", "Lkotlinx/serialization/hocon/Hocon;", "valueConsumer", "Lkotlin/Function1;", "Lcom/typesafe/config/ConfigValue;", "", "<init>", "(Lkotlinx/serialization/hocon/Hocon;Lkotlin/jvm/functions/Function1;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "writeDiscriminator", "", "elementName", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "composeName", "parentName", "childName", "encodeTaggedConfigValue", "tag", "value", "getCurrent", "encodeTaggedValue", "", "encodeTaggedNull", "encodeTaggedChar", "", "encodeTaggedEnum", "enumDescriptor", "ordinal", "shouldEncodeElementDefault", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "endEncode", "encodeConfigValue", "configValueOf", "kotlin.jvm.PlatformType", "(Ljava/lang/Object;)Lcom/typesafe/config/ConfigValue;", "kotlinx-serialization-hocon"})
public abstract class AbstractHoconEncoder
extends NamedValueEncoder
implements HoconEncoder {
    @NotNull
    private final Hocon hocon;
    @NotNull
    private final Function1<ConfigValue, Unit> valueConsumer;
    private boolean writeDiscriminator;

    public AbstractHoconEncoder(@NotNull Hocon hocon, @NotNull Function1<? super ConfigValue, Unit> valueConsumer) {
        Intrinsics.checkNotNullParameter(hocon, "hocon");
        Intrinsics.checkNotNullParameter(valueConsumer, "valueConsumer");
        this.hocon = hocon;
        this.valueConsumer = valueConsumer;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.hocon.getSerializersModule();
    }

    @Override
    @NotNull
    protected String elementName(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return NamingConventionKt.getConventionElementName(descriptor2, index, this.hocon.getUseConfigNamingConvention$kotlinx_serialization_hocon());
    }

    @Override
    @NotNull
    protected String composeName(@NotNull String parentName, @NotNull String childName) {
        Intrinsics.checkNotNullParameter(parentName, "parentName");
        Intrinsics.checkNotNullParameter(childName, "childName");
        return childName;
    }

    protected abstract void encodeTaggedConfigValue(@NotNull String var1, @NotNull ConfigValue var2);

    @NotNull
    protected abstract ConfigValue getCurrent();

    @Override
    protected void encodeTaggedValue(@NotNull String tag, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(value2, "value");
        ConfigValue configValue = this.configValueOf(value2);
        Intrinsics.checkNotNullExpressionValue(configValue, "configValueOf(...)");
        this.encodeTaggedConfigValue(tag, configValue);
    }

    @Override
    protected void encodeTaggedNull(@NotNull String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        ConfigValue configValue = this.configValueOf(null);
        Intrinsics.checkNotNullExpressionValue(configValue, "configValueOf(...)");
        this.encodeTaggedConfigValue(tag, configValue);
    }

    @Override
    protected void encodeTaggedChar(@NotNull String tag, char value2) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.encodeTaggedString(tag, String.valueOf(value2));
    }

    @Override
    protected void encodeTaggedEnum(@NotNull String tag, @NotNull SerialDescriptor enumDescriptor, int ordinal) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        this.encodeTaggedString(tag, enumDescriptor.getElementName(ordinal));
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.hocon.getEncodeDefaults$kotlinx_serialization_hocon();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value2) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        if (HoconDurationKt.isDuration(serializer2.getDescriptor())) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.time.Duration");
            this.encodeString(HoconDurationKt.encodeDuration-LRDsOJo(((Duration)value2).unbox-impl()));
        } else if (!(serializer2 instanceof AbstractPolymorphicSerializer) || this.hocon.getUseArrayPolymorphism$kotlinx_serialization_hocon()) {
            serializer2.serialize(this, value2);
        } else {
            AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer2;
            Encoder encoder = this;
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Any");
            SerializationStrategy<T> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(casted, encoder, value2);
            this.writeDiscriminator = true;
            actualSerializer.serialize(this, value2);
        }
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        AbstractHoconEncoder abstractHoconEncoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Function1<ConfigValue, Unit> consumer = this.getCurrentTagOrNull() == null ? this.valueConsumer : arg_0 -> AbstractHoconEncoder.beginStructure$lambda$0(this, arg_0);
        SerialKind kind = HoconSerialKindKt.hoconKind(descriptor2, this.hocon.getUseArrayPolymorphism$kotlinx_serialization_hocon());
        AbstractHoconEncoder encoder = abstractHoconEncoder = HoconSerialKindKt.getListLike(kind) ? (AbstractHoconEncoder)new HoconConfigListEncoder(this.hocon, consumer) : (HoconSerialKindKt.getObjLike(kind) ? (AbstractHoconEncoder)new HoconConfigEncoder(this.hocon, consumer) : (Intrinsics.areEqual(kind, StructureKind.MAP.INSTANCE) ? (AbstractHoconEncoder)new HoconConfigMapEncoder(this.hocon, consumer) : this));
        boolean bl = false;
        if (this.writeDiscriminator) {
            encoder.encodeTaggedString(this.hocon.getClassDiscriminator$kotlinx_serialization_hocon(), descriptor2.getSerialName());
            this.writeDiscriminator = false;
        }
        return abstractHoconEncoder;
    }

    @Override
    protected void endEncode(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.valueConsumer.invoke(this.getCurrent());
    }

    @Override
    public void encodeConfigValue(@NotNull ConfigValue value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.encodeTaggedConfigValue((String)this.getCurrentTag(), value2);
    }

    private final ConfigValue configValueOf(Object value2) {
        return ConfigValueFactory.fromAnyRef(value2);
    }

    private static final Unit beginStructure$lambda$0(AbstractHoconEncoder this$0, ConfigValue value2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(value2, "value");
        this$0.encodeTaggedConfigValue((String)this$0.getCurrentTag(), value2);
        return Unit.INSTANCE;
    }
}

