/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.antlr.v4.kotlinruntime.AbstractCharStreams;
import org.antlr.v4.kotlinruntime.CharStream;
import org.antlr.v4.kotlinruntime.StringCharStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J$\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/antlr/v4/kotlinruntime/CharStreams;", "Lorg/antlr/v4/kotlinruntime/AbstractCharStreams;", "()V", "DEFAULT_BUFFER_SIZE", "", "fromChannel", "Lorg/antlr/v4/kotlinruntime/CharStream;", "channel", "Ljava/nio/channels/ReadableByteChannel;", "charset", "Ljava/nio/charset/Charset;", "sourceName", "", "fromFileName", "fileName", "fromPath", "path", "Ljava/nio/file/Path;", "fromStream", "inputStream", "Ljava/io/InputStream;", "InternalByteArrayOutputStream", "antlr-kotlin-runtime"})
public final class CharStreams
extends AbstractCharStreams {
    @NotNull
    public static final CharStreams INSTANCE = new CharStreams();
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private CharStreams() {
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromFileName(@NotNull String fileName, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Path path = Paths.get(fileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        return this.fromPath(path, charset);
    }

    public static /* synthetic */ CharStream fromFileName$default(CharStreams charStreams, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return charStreams.fromFileName(string, charset);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromPath(@NotNull Path path, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(charset, "charset");
        String pathStr = ((Object)path).toString();
        SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);
        Intrinsics.checkNotNull(channel);
        return this.fromChannel(channel, charset, pathStr);
    }

    public static /* synthetic */ CharStream fromPath$default(CharStreams charStreams, Path path, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return charStreams.fromPath(path, charset);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromStream(@NotNull InputStream inputStream, @NotNull Charset charset, @NotNull String sourceName) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(sourceName, "sourceName");
        ReadableByteChannel channel = Channels.newChannel(inputStream);
        Intrinsics.checkNotNull(channel);
        return this.fromChannel(channel, charset, sourceName);
    }

    public static /* synthetic */ CharStream fromStream$default(CharStreams charStreams, InputStream inputStream, Charset charset, String string, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset2, "UTF_8");
            charset = charset2;
        }
        if ((n & 4) != 0) {
            string = "<unknown>";
        }
        return charStreams.fromStream(inputStream, charset, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final CharStream fromChannel(@NotNull ReadableByteChannel channel, @NotNull Charset charset, @NotNull String sourceName) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(sourceName, "sourceName");
        Closeable closeable = channel;
        Throwable throwable = null;
        try {
            int bytesRead;
            ReadableByteChannel it = (ReadableByteChannel)closeable;
            boolean bl = false;
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            InternalByteArrayOutputStream bos = new InternalByteArrayOutputStream(16384);
            while ((bytesRead = it.read(buffer)) >= 0) {
                bos.write(buffer.array(), 0, bytesRead);
                buffer.clear();
            }
            String source = new String(bos.getBuffer(), 0, bos.getCount(), charset);
            CharStream charStream = new StringCharStream(source, sourceName);
            return charStream;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ CharStream fromChannel$default(CharStreams charStreams, ReadableByteChannel readableByteChannel, Charset charset, String string, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 4) != 0) {
            string = "<unknown>";
        }
        return charStreams.fromChannel(readableByteChannel, charset, string);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return CharStreams.fromFileName$default(this, fileName, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return CharStreams.fromPath$default(this, path, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromStream(@NotNull InputStream inputStream, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return CharStreams.fromStream$default(this, inputStream, charset, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        return CharStreams.fromStream$default(this, inputStream, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromChannel(@NotNull ReadableByteChannel channel, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return CharStreams.fromChannel$default(this, channel, charset, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final CharStream fromChannel(@NotNull ReadableByteChannel channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        return CharStreams.fromChannel$default(this, channel, null, null, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/antlr/v4/kotlinruntime/CharStreams$InternalByteArrayOutputStream;", "Ljava/io/ByteArrayOutputStream;", "size", "", "(I)V", "buffer", "", "getBuffer", "()[B", "count", "getCount", "()I", "antlr-kotlin-runtime"})
    private static final class InternalByteArrayOutputStream
    extends ByteArrayOutputStream {
        public InternalByteArrayOutputStream(int size) {
            super(size);
        }

        @NotNull
        public final byte[] getBuffer() {
            Intrinsics.checkNotNullExpressionValue(this.buf, "buf");
            return this.buf;
        }

        public final int getCount() {
            return this.count;
        }
    }
}

