/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.ast;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000bJ\b\u0010\u0016\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/antlr/v4/kotlinruntime/ast/Point;", "", "line", "", "column", "(II)V", "getColumn", "()I", "getLine", "advance", "text", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "isBefore", "offset", "code", "toString", "Companion", "antlr-kotlin-runtime"})
@SourceDebugExtension(value={"SMAP\nPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Point.kt\norg/antlr/v4/kotlinruntime/ast/Point\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1819#2,8:67\n*S KotlinDebug\n*F\n+ 1 Point.kt\norg/antlr/v4/kotlinruntime/ast/Point\n*L\n44#1:67,8\n*E\n"})
public final class Point {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int line;
    private final int column;
    @NotNull
    private static final Regex lineBreakRegex = new Regex("\r\n|\r|\n");

    public Point(int line, int column) {
        this.line = line;
        this.column = column;
        if (!(this.line >= 1)) {
            boolean $i$a$-require-Point$32 = false;
            String $i$a$-require-Point$32 = "Line should be equal or greater than 1, but was " + this.line;
            throw new IllegalArgumentException($i$a$-require-Point$32.toString());
        }
        if (!(this.column >= 0)) {
            boolean bl = false;
            String string = "Column should be equal or greater than 0, but was " + this.column;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    @NotNull
    public String toString() {
        return "line " + this.line + " : column " + this.column;
    }

    /*
     * WARNING - void declaration
     */
    public final int offset(@NotNull String code) {
        void $this$foldRight$iv;
        Intrinsics.checkNotNullParameter(code, "code");
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)code, stringArray, false, 0, 6, null);
        if (!(lines.size() >= this.line)) {
            boolean $i$a$-require-Point$offset$32 = false;
            String $i$a$-require-Point$offset$32 = "The point does not exist in the given text. It indicates line " + this.line + " but there are only " + lines.size() + " lines";
            throw new IllegalArgumentException($i$a$-require-Point$offset$32.toString());
        }
        if (!(((String)lines.get(this.line - 1)).length() >= this.column)) {
            boolean $i$a$-require-Point$offset$42 = false;
            String $i$a$-require-Point$offset$42 = "The column does not exist in the given text. Line " + this.line + " has " + ((String)lines.get(this.line - 1)).length() + " columns, the point indicates column " + this.column;
            throw new IllegalArgumentException($i$a$-require-Point$offset$42.toString());
        }
        int newLines = this.line - 1;
        List list = lines.subList(0, this.line - 1);
        int initial$iv = 0;
        boolean $i$f$foldRight = false;
        int accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                int n = accumulator$iv;
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv = it.length() + acc;
            }
        }
        int foldedLines = accumulator$iv;
        return foldedLines + newLines + this.column;
    }

    public final boolean isBefore(@NotNull Point other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.line < other.line || this.line == other.line && this.column < other.column;
    }

    @NotNull
    public final Point advance(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Sequence matches = Regex.findAll$default(lineBreakRegex, text, 0, 2, null);
        int line = this.line + SequencesKt.count(matches);
        int col = SequencesKt.none(matches) ? this.column + text.length() : text.length() - ((MatchResult)SequencesKt.last(matches)).getRange().getLast() - 1;
        return new Point(line, col);
    }

    public final int component1() {
        return this.line;
    }

    public final int component2() {
        return this.column;
    }

    @NotNull
    public final Point copy(int line, int column) {
        return new Point(line, column);
    }

    public static /* synthetic */ Point copy$default(Point point, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = point.line;
        }
        if ((n3 & 2) != 0) {
            n2 = point.column;
        }
        return point.copy(n, n2);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.line);
        result2 = result2 * 31 + Integer.hashCode(this.column);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Point)) {
            return false;
        }
        Point point = (Point)other;
        if (this.line != point.line) {
            return false;
        }
        return this.column == point.column;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/antlr/v4/kotlinruntime/ast/Point$Companion;", "", "()V", "lineBreakRegex", "Lkotlin/text/Regex;", "antlr-kotlin-runtime"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

