/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.kotlinruntime.ast.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u000f\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0010\u001a\u00020\tH\u00c6\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aJ\t\u0010\u001d\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/antlr/v4/kotlinruntime/ast/Position;", "", "startLine", "", "startCol", "endLine", "endCol", "(IIII)V", "start", "Lorg/antlr/v4/kotlinruntime/ast/Point;", "end", "(Lorg/antlr/v4/kotlinruntime/ast/Point;Lorg/antlr/v4/kotlinruntime/ast/Point;)V", "getEnd", "()Lorg/antlr/v4/kotlinruntime/ast/Point;", "getStart", "component1", "component2", "contains", "", "point", "copy", "equals", "other", "hashCode", "length", "code", "", "text", "wholeText", "toString", "antlr-kotlin-runtime"})
public final class Position {
    @NotNull
    private final Point start;
    @NotNull
    private final Point end;

    public Position(@NotNull Point start, @NotNull Point end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        this.start = start;
        this.end = end;
        if (!(this.start.isBefore(this.end) || Intrinsics.areEqual(this.start, this.end))) {
            boolean bl = false;
            String string = "End should follows start or be the same as start (start: " + this.start + ", end: " + this.end + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Point getStart() {
        return this.start;
    }

    @NotNull
    public final Point getEnd() {
        return this.end;
    }

    public Position(int startLine, int startCol, int endLine, int endCol) {
        this(new Point(startLine, startCol), new Point(endLine, endCol));
    }

    @NotNull
    public final String text(@NotNull String wholeText) {
        Intrinsics.checkNotNullParameter(wholeText, "wholeText");
        String string = wholeText.substring(this.start.offset(wholeText), this.end.offset(wholeText));
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }

    public final int length(@NotNull String code) {
        Intrinsics.checkNotNullParameter(code, "code");
        return this.end.offset(code) - this.start.offset(code);
    }

    public final boolean contains(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return !(!Intrinsics.areEqual(point, this.start) && !this.start.isBefore(point) || !Intrinsics.areEqual(point, this.end) && !point.isBefore(this.end));
    }

    @NotNull
    public final Point component1() {
        return this.start;
    }

    @NotNull
    public final Point component2() {
        return this.end;
    }

    @NotNull
    public final Position copy(@NotNull Point start, @NotNull Point end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        return new Position(start, end);
    }

    public static /* synthetic */ Position copy$default(Position position, Point point, Point point2, int n, Object object) {
        if ((n & 1) != 0) {
            point = position.start;
        }
        if ((n & 2) != 0) {
            point2 = position.end;
        }
        return position.copy(point, point2);
    }

    @NotNull
    public String toString() {
        return "Position(start=" + this.start + ", end=" + this.end + ')';
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + this.end.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Position)) {
            return false;
        }
        Position position = (Position)other;
        if (!Intrinsics.areEqual(this.start, position.start)) {
            return false;
        }
        return Intrinsics.areEqual(this.end, position.end);
    }
}

