/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.antlr.v4.kotlinruntime.misc.AbstractEqualityComparator;
import org.antlr.v4.kotlinruntime.misc.MurmurHash;
import org.antlr.v4.kotlinruntime.misc.ObjectEqualityComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u000f\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 J*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002JKB)\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010/\u001a\u000200H\u0016J\u0015\u00101\u001a\u0002022\u0006\u00103\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00104J\u0015\u00105\u001a\u0002022\u0006\u00106\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00104J\u0013\u00107\u001a\u0002022\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\b\u0010:\u001a\u000200H\u0004J\u0018\u0010;\u001a\u0004\u0018\u00018\u00012\u0006\u00103\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010<J\u0015\u0010=\u001a\u00020\u00072\u0006\u00103\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020\u0007H\u0016J\b\u0010@\u001a\u000202H\u0016J\u001f\u0010A\u001a\u0004\u0018\u00018\u00012\u0006\u00103\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010BJ\u001e\u0010C\u001a\u0002002\u0014\u0010D\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010EH\u0016J\u0015\u0010F\u001a\u00028\u00012\u0006\u00103\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010<J\b\u0010G\u001a\u00020HH\u0016J\u0006\u0010I\u001a\u00020HR8\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\r\u0018\u00010\f0\u000bX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u001a\u0010#\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019R\u0014\u0010&\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0017R\u001a\u0010(\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0017\"\u0004\b*\u0010\u0019R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006L"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/FlexibleHashMap;", "K", "V", "", "comparator", "Lorg/antlr/v4/kotlinruntime/misc/AbstractEqualityComparator;", "initialCapacity", "", "initialBucketCapacity", "(Lorg/antlr/v4/kotlinruntime/misc/AbstractEqualityComparator;II)V", "buckets", "", "", "Lorg/antlr/v4/kotlinruntime/misc/FlexibleHashMap$Entry;", "getBuckets", "()[Ljava/util/List;", "setBuckets", "([Ljava/util/List;)V", "[Ljava/util/List;", "getComparator", "()Lorg/antlr/v4/kotlinruntime/misc/AbstractEqualityComparator;", "currentPrime", "getCurrentPrime", "()I", "setCurrentPrime", "(I)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "getInitialBucketCapacity", "getInitialCapacity", "keys", "getKeys", "n", "getN", "setN", "size", "getSize", "threshold", "getThreshold", "setThreshold", "values", "", "getValues", "()Ljava/util/Collection;", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "equals", "other", "", "expand", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getBucket", "(Ljava/lang/Object;)I", "hashCode", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "toString", "", "toTableString", "Companion", "Entry", "antlr-kotlin-runtime"})
public class FlexibleHashMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractEqualityComparator<K> comparator;
    private final int initialCapacity;
    private final int initialBucketCapacity;
    @NotNull
    private List<Entry<K, V>>[] buckets;
    private int n;
    private int currentPrime;
    private int threshold;
    public static final int INITIAL_CAPACITY = 16;
    public static final int INITIAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;

    public FlexibleHashMap(@NotNull AbstractEqualityComparator<? super K> comparator, int initialCapacity, int initialBucketCapacity) {
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        this.comparator = comparator;
        this.initialCapacity = initialCapacity;
        this.initialBucketCapacity = initialBucketCapacity;
        this.currentPrime = 1;
        this.buckets = FlexibleHashMap.Companion.createEntryListArray(this.initialBucketCapacity);
        this.threshold = (int)Math.floor((double)this.initialCapacity * 0.75);
    }

    public /* synthetic */ FlexibleHashMap(AbstractEqualityComparator abstractEqualityComparator, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            abstractEqualityComparator = ObjectEqualityComparator.Companion.getINSTANCE();
        }
        if ((n3 & 2) != 0) {
            n = 16;
        }
        if ((n3 & 4) != 0) {
            n2 = 8;
        }
        this(abstractEqualityComparator, n, n2);
    }

    @NotNull
    protected final AbstractEqualityComparator<K> getComparator() {
        return this.comparator;
    }

    public final int getInitialCapacity() {
        return this.initialCapacity;
    }

    public final int getInitialBucketCapacity() {
        return this.initialBucketCapacity;
    }

    @NotNull
    protected final List<Entry<K, V>>[] getBuckets() {
        return this.buckets;
    }

    protected final void setBuckets(@NotNull List<Entry<K, V>>[] listArray) {
        Intrinsics.checkNotNullParameter(listArray, "<set-?>");
        this.buckets = listArray;
    }

    protected final int getN() {
        return this.n;
    }

    protected final void setN(int n) {
        this.n = n;
    }

    protected final int getCurrentPrime() {
        return this.currentPrime;
    }

    protected final void setCurrentPrime(int n) {
        this.currentPrime = n;
    }

    protected final int getThreshold() {
        return this.threshold;
    }

    protected final void setThreshold(int n) {
        this.threshold = n;
    }

    public int getSize() {
        return this.n;
    }

    @NotNull
    public Set<K> getKeys() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Collection<V> getValues() {
        ArrayList<V> a = new ArrayList<V>(this.size());
        for (List<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            Iterator<Entry<K, V>> iterator2 = bucket.iterator();
            while (iterator2.hasNext()) {
                Entry<K, V> entry;
                Entry<K, V> entry2 = entry = iterator2.next();
                Intrinsics.checkNotNull(entry2);
                a.add(entry2.getValue());
            }
        }
        return a;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public V get(K key) {
        if (key == null) {
            return null;
        }
        int b = this.getBucket(key);
        List<Entry<K, V>> list = this.buckets[b];
        if (list == null) {
            return null;
        }
        List<Entry<K, V>> bucket = list;
        Iterator<Entry<K, V>> iterator2 = bucket.iterator();
        while (iterator2.hasNext()) {
            Entry<K, V> e;
            Entry<K, V> entry = e = iterator2.next();
            if (!this.comparator.equals(entry != null ? entry.getKey() : null, key)) continue;
            Entry<K, V> entry2 = e;
            return (V)(entry2 != null ? entry2.getValue() : null);
        }
        return null;
    }

    @Override
    @Nullable
    public V put(K key, V value2) {
        List list;
        int b;
        List existingBucket;
        if (key == null) {
            return null;
        }
        if (this.n > this.threshold) {
            this.expand();
        }
        if ((existingBucket = this.buckets[b = this.getBucket(key)]) != null) {
            list = existingBucket;
        } else {
            ArrayList<Entry<K, V>> list2 = new ArrayList<Entry<K, V>>();
            this.buckets[b] = list2;
            list = list2;
        }
        List bucket = list;
        Iterator<Entry<K, V>> iterator2 = bucket.iterator();
        while (iterator2.hasNext()) {
            Entry<K, V> e;
            Entry<K, V> entry = e = iterator2.next();
            if (!this.comparator.equals(entry != null ? entry.getKey() : null, key)) continue;
            Entry<K, V> entry2 = e;
            V prev = entry2 != null ? entry2.getValue() : null;
            Entry<K, V> entry3 = e;
            if (entry3 != null) {
                entry3.setValue(value2);
            }
            int n = this.n;
            this.n = n + 1;
            return prev;
        }
        bucket.add(new Entry<K, V>(key, value2));
        int n = this.n;
        this.n = n + 1;
        return null;
    }

    @Override
    public V remove(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(V value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int hash = MurmurHash.initialize$default(MurmurHash.INSTANCE, 0, 1, null);
        for (List<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            for (Entry<K, V> e : bucket) {
                if (e == null) break;
                hash = MurmurHash.INSTANCE.update(hash, this.comparator.hashCode(e.getKey()));
            }
        }
        hash = MurmurHash.INSTANCE.finish(hash, this.size());
        return hash;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        throw new UnsupportedOperationException();
    }

    protected final int getBucket(K key) {
        int hash = this.comparator.hashCode(key);
        return hash & this.buckets.length - 1;
    }

    protected final void expand() {
        List<Entry<K, V>>[] old = this.buckets;
        this.currentPrime += 4;
        int newCapacity = this.buckets.length * 2;
        List[] newTable = FlexibleHashMap.Companion.createEntryListArray(newCapacity);
        this.buckets = newTable;
        this.threshold = (int)((double)newCapacity * 0.75);
        int oldSize = this.size();
        for (List<Entry<K, V>> bucket : old) {
            if (bucket == null) continue;
            for (Entry<K, V> e : bucket) {
                if (e == null) break;
                this.put(e.getKey(), e.getValue());
            }
        }
        this.n = oldSize;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        this.n = 0;
        this.buckets = FlexibleHashMap.Companion.createEntryListArray(this.initialCapacity);
        this.threshold = (int)Math.floor((double)this.initialCapacity * 0.75);
    }

    @NotNull
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        boolean first2 = true;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (List<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            for (Entry<K, V> e : bucket) {
                if (e == null) break;
                if (first2) {
                    first2 = false;
                } else {
                    buf.append(", ");
                }
                buf.append(e.toString());
            }
        }
        buf.append("}");
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String toTableString() {
        StringBuilder buf = new StringBuilder();
        for (List<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) {
                buf.append("null\n");
                continue;
            }
            buf.append("[");
            boolean first2 = true;
            for (Entry<K, V> e : bucket) {
                if (first2) {
                    first2 = false;
                } else {
                    buf.append(" ");
                }
                if (e == null) {
                    buf.append("_");
                    continue;
                }
                buf.append(e.toString());
            }
            buf.append("]\n");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public FlexibleHashMap() {
        this(null, 0, 0, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0018\u00010\u000b\u0018\u00010\n0\t\"\u0004\b\u0002\u0010\f\"\u0004\b\u0003\u0010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/FlexibleHashMap$Companion;", "", "()V", "INITIAL_BUCKET_CAPACITY", "", "INITIAL_CAPACITY", "LOAD_FACTOR", "", "createEntryListArray", "", "", "Lorg/antlr/v4/kotlinruntime/misc/FlexibleHashMap$Entry;", "K", "V", "length", "(I)[Ljava/util/List;", "antlr-kotlin-runtime"})
    public static final class Companion {
        private Companion() {
        }

        private final <K, V> List<Entry<K, V>>[] createEntryListArray(int length) {
            return new List[length];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ.\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00022\b\b\u0002\u0010\u0005\u001a\u00028\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\u0005\u001a\u00028\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/FlexibleHashMap$Entry;", "K", "V", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "setValue", "(Ljava/lang/Object;)V", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/antlr/v4/kotlinruntime/misc/FlexibleHashMap$Entry;", "equals", "", "other", "hashCode", "", "toString", "", "antlr-kotlin-runtime"})
    public static final class Entry<K, V> {
        private final K key;
        private V value;

        public Entry(K key, V value2) {
            this.key = key;
            this.value = value2;
        }

        public final K getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.value;
        }

        public final void setValue(V v) {
            this.value = v;
        }

        @NotNull
        public String toString() {
            return "" + this.key + ':' + this.value;
        }

        public final K component1() {
            return this.key;
        }

        public final V component2() {
            return this.value;
        }

        @NotNull
        public final Entry<K, V> copy(K key, V value2) {
            return new Entry<K, V>(key, value2);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = entry.key;
            }
            if ((n & 2) != 0) {
                object2 = entry.value;
            }
            return entry.copy(object, object2);
        }

        public int hashCode() {
            int result2 = this.key == null ? 0 : this.key.hashCode();
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual(this.key, entry.key)) {
                return false;
            }
            return Intrinsics.areEqual(this.value, entry.value);
        }
    }
}

