/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.misc;

import com.strumenta.antlrkotlin.runtime.System;
import com.strumenta.antlrkotlin.runtime.ext.Array_extKt;
import com.strumenta.antlrkotlin.runtime.ext.Char_extKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bJ\u0014\u0010\u0013\u001a\u00020\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\u0006\u0010\u001a\u001a\u00020\u0011J\u0011\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0013\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0086\u0002J\b\u0010!\u001a\u00020\u0004H\u0016J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0019\u0010$\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0002J\u0006\u0010%\u001a\u00020\u0004J\u0006\u0010&\u001a\u00020\u0011J\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020+H\u0016J\u0006\u0010,\u001a\u00020\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006."}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntegerList;", "", "()V", "capacity", "", "(I)V", "list", "(Lorg/antlr/v4/kotlinruntime/misc/IntegerList;)V", "", "(Ljava/util/Collection;)V", "_data", "", "_size", "isEmpty", "", "()Z", "add", "", "value", "addAll", "array", "binarySearch", "key", "fromIndex", "toIndex", "charArraySize", "clear", "contains", "ensureCapacity", "equals", "other", "get", "index", "hashCode", "removeAt", "removeRange", "set", "size", "sort", "toArray", "toCharArray", "", "toString", "", "trimToSize", "Companion", "antlr-kotlin-runtime"})
public class IntegerList {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private int[] _data;
    private int _size;
    @NotNull
    private static final int[] EMPTY_DATA = new int[0];
    private static final int INITIAL_SIZE = 4;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public IntegerList() {
        this._data = EMPTY_DATA;
    }

    public IntegerList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this._data = capacity == 0 ? EMPTY_DATA : new int[capacity];
    }

    public IntegerList(@NotNull IntegerList list) {
        Intrinsics.checkNotNullParameter(list, "list");
        int[] nArray = Arrays.copyOf(list._data, list._data.length);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        this._data = nArray;
        this._size = list._size;
    }

    public IntegerList(@NotNull Collection<Integer> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        this(list.size());
        Iterator<Integer> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            int value2 = ((Number)iterator2.next()).intValue();
            this.add(value2);
        }
    }

    public final void add(int value2) {
        if (this._data.length == this._size) {
            this.ensureCapacity(this._size + 1);
        }
        this._data[this._size] = value2;
        int n = this._size;
        this._size = n + 1;
    }

    public final void addAll(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        this.ensureCapacity(this._size + array.length);
        System.INSTANCE.arraycopy(array, 0, this._data, this._size, array.length);
        this._size += array.length;
    }

    public final void addAll(@NotNull IntegerList list) {
        Intrinsics.checkNotNullParameter(list, "list");
        this.ensureCapacity(this._size + list._size);
        System.INSTANCE.arraycopy(list._data, 0, this._data, this._size, list._size);
        this._size += list._size;
    }

    public final void addAll(@NotNull Collection<Integer> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        this.ensureCapacity(this._size + list.size());
        Iterator<Integer> iterator2 = list.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int x;
            int current = n++;
            this._data[this._size + current] = x = ((Number)iterator2.next()).intValue();
        }
        this._size += list.size();
    }

    public final int get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        return this._data[index];
    }

    public final boolean contains(int value2) {
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            if (this._data[i] != value2) continue;
            return true;
        }
        return false;
    }

    public final int set(int index, int value2) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        int previous = this._data[index];
        this._data[index] = value2;
        return previous;
    }

    public final int removeAt(int index) {
        int value2 = this.get(index);
        int n = this._size - index - 1;
        for (int i = 0; i < n; ++i) {
            this._data[index + i] = this._data[index + i + 1];
        }
        this._data[this._size - 1] = 0;
        int n2 = this._size;
        this._size = n2 + -1;
        return value2;
    }

    public final void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > this._size || toIndex > this._size) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        System.INSTANCE.arraycopy(this._data, toIndex, this._data, fromIndex, this._size - toIndex);
        this._size -= toIndex - fromIndex;
    }

    public final int size() {
        return this._size;
    }

    public final void trimToSize() {
        if (this._data.length == this._size) {
            return;
        }
        int[] nArray = Arrays.copyOf(this._data, this._size);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        this._data = nArray;
    }

    public final void clear() {
        ArraysKt.fill$default(this._data, 0, 0, 0, 6, null);
        this._size = 0;
    }

    @NotNull
    public final int[] toArray() {
        int[] nArray;
        if (this._size == 0) {
            nArray = EMPTY_DATA;
        } else {
            int[] nArray2 = Arrays.copyOf(this._data, this._data.length);
            nArray = nArray2;
            Intrinsics.checkNotNullExpressionValue(nArray2, "copyOf(...)");
        }
        return nArray;
    }

    public final void sort() {
        ArraysKt.sort(this._data);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IntegerList) || this._size != ((IntegerList)other)._size) {
            return false;
        }
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            if (this._data[i] == ((IntegerList)other)._data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            hashCode = 31 * hashCode + this._data[i];
        }
        return hashCode;
    }

    @NotNull
    public String toString() {
        return ArraysKt.joinToString$default(this.toArray(), null, null, null, 0, null, null, 63, null);
    }

    public final int binarySearch(int key) {
        return Array_extKt.binarySearch$default(this._data, key, 0, 0, 6, null);
    }

    public final int binarySearch(int fromIndex, int toIndex, int key) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > this._size || toIndex > this._size) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        return Array_extKt.binarySearch(this._data, key, fromIndex, toIndex);
    }

    private final void ensureCapacity(int capacity) {
        int newLength;
        if (capacity < 0 || capacity > 0x7FFFFFF7) {
            throw new RuntimeException();
        }
        int n = newLength = this._data.length == 0 ? 4 : this._data.length;
        while (newLength < capacity) {
            if ((newLength *= 2) >= 0 && newLength <= 0x7FFFFFF7) continue;
            newLength = 0x7FFFFFF7;
        }
        int[] nArray = Arrays.copyOf(this._data, newLength);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        this._data = nArray;
    }

    @NotNull
    public final char[] toCharArray() {
        char[] resultArray = new char[this._size];
        int resultIdx = 0;
        boolean calculatedPreciseResultSize = false;
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            int codePoint = this._data[i];
            if (!calculatedPreciseResultSize && Char_extKt.isSupplementaryCodePoint(CharCompanionObject.INSTANCE, codePoint)) {
                Intrinsics.checkNotNullExpressionValue(Arrays.copyOf(resultArray, this.charArraySize()), "copyOf(...)");
                calculatedPreciseResultSize = true;
            }
            int charsWritten = Char_extKt.toChars(CharCompanionObject.INSTANCE, codePoint, resultArray, resultIdx);
            resultIdx += charsWritten;
        }
        return resultArray;
    }

    private final int charArraySize() {
        int result2 = 0;
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            result2 += Char_extKt.charCount(CharCompanionObject.INSTANCE, this._data[i]);
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntegerList$Companion;", "", "()V", "EMPTY_DATA", "", "INITIAL_SIZE", "", "MAX_ARRAY_SIZE", "antlr-kotlin-runtime"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

