/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.misc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.kotlinruntime.Vocabulary;
import org.antlr.v4.kotlinruntime.misc.IntSet;
import org.antlr.v4.kotlinruntime.misc.IntegerList;
import org.antlr.v4.kotlinruntime.misc.Interval;
import org.antlr.v4.kotlinruntime.misc.MurmurHash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0001H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0006\u0010\"\u001a\u00020\u001bJ\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0001H\u0016J\u0011\u0010%\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0015H\u0096\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0013\u0010*\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\u0011\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015H\u0086\u0002J\b\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0010\u00101\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u00102\u001a\u00020\u0015H\u0016J\u0010\u00103\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0016J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001508J\b\u00109\u001a\u00020'H\u0016J\u000e\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020\u000eJ\u000e\u00109\u001a\u00020'2\u0006\u0010(\u001a\u00020)R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR$\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006<"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "Lorg/antlr/v4/kotlinruntime/misc/IntSet;", "()V", "intervals", "", "Lorg/antlr/v4/kotlinruntime/misc/Interval;", "(Ljava/util/List;)V", "set", "(Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;)V", "_intervals", "", "getIntervals", "()Ljava/util/List;", "isNil", "", "()Z", "value", "isReadonly", "setReadonly", "(Z)V", "maxElement", "", "getMaxElement", "()I", "minElement", "getMinElement", "add", "", "el", "a", "b", "addition", "addAll", "and", "clear", "complement", "elements", "contains", "elementName", "", "vocabulary", "Lorg/antlr/v4/kotlinruntime/Vocabulary;", "equals", "other", "", "get", "i", "hashCode", "or", "remove", "size", "subtract", "toIntegerList", "Lorg/antlr/v4/kotlinruntime/misc/IntegerList;", "toList", "toSet", "", "toString", "elemAreChar", "Companion", "antlr-kotlin-runtime"})
public final class IntervalSet
implements IntSet {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<Interval> _intervals;
    private boolean isReadonly;
    @NotNull
    private static final IntervalSet COMPLETE_CHAR_SET;
    @NotNull
    private static final IntervalSet EMPTY_SET;

    @NotNull
    public final List<Interval> getIntervals() {
        return this._intervals;
    }

    @Override
    public boolean isNil() {
        return this._intervals.size() == 0;
    }

    public final int getMaxElement() {
        if (this.isNil()) {
            throw new RuntimeException("set is empty");
        }
        Interval last2 = this._intervals.get(this._intervals.size() - 1);
        return last2.getB();
    }

    public final int getMinElement() {
        if (this.isNil()) {
            throw new RuntimeException("set is empty");
        }
        return this._intervals.get(0).getA();
    }

    public final boolean isReadonly() {
        return this.isReadonly;
    }

    public final void setReadonly(boolean value2) {
        if (this.isReadonly && !value2) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.isReadonly = value2;
    }

    public IntervalSet() {
        this._intervals = new ArrayList(16);
    }

    public IntervalSet(@NotNull List<Interval> intervals) {
        Intrinsics.checkNotNullParameter(intervals, "intervals");
        this._intervals = intervals;
    }

    public IntervalSet(@NotNull IntervalSet set) {
        Intrinsics.checkNotNullParameter(set, "set");
        this._intervals = new ArrayList(set._intervals.size());
        this.addAll(set);
    }

    public final void clear() {
        if (this.isReadonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this._intervals.clear();
    }

    @Override
    public void add(int el) {
        this.add(el, el);
    }

    public final void add(int a, int b) {
        this.add(Interval.Companion.of(a, b));
    }

    private final void add(Interval addition) {
        if (this.isReadonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        if (addition.getB() < addition.getA()) {
            return;
        }
        ListIterator<Interval> iter = this._intervals.listIterator();
        while (iter.hasNext()) {
            Interval r = iter.next();
            if (Intrinsics.areEqual(addition, r)) {
                return;
            }
            if (addition.adjacent(r) || !addition.disjoint(r)) {
                Interval next;
                Interval bigger = addition.union(r);
                iter.set(bigger);
                while (iter.hasNext() && (bigger.adjacent(next = iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union(next));
                    iter.next();
                }
                return;
            }
            if (!addition.startsBeforeDisjoint(r)) continue;
            iter.previous();
            iter.add(addition);
            return;
        }
        this._intervals.add(addition);
    }

    @Override
    @NotNull
    public IntervalSet addAll(@NotNull IntSet set) {
        Intrinsics.checkNotNullParameter(set, "set");
        if (set instanceof IntervalSet) {
            List<Interval> setIntervals = ((IntervalSet)set)._intervals;
            int n = setIntervals.size();
            for (int i = 0; i < n; ++i) {
                Interval I = setIntervals.get(i);
                this.add(I.getA(), I.getB());
            }
        } else {
            Iterator<Integer> iterator2 = set.toList().iterator();
            while (iterator2.hasNext()) {
                int value2 = ((Number)iterator2.next()).intValue();
                this.add(value2);
            }
        }
        return this;
    }

    @NotNull
    public final IntervalSet complement(int minElement, int maxElement) {
        return this.complement(Companion.of(minElement, maxElement));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IntervalSet complement(@NotNull IntSet elements) {
        IntervalSet intervalSet;
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements.isNil()) {
            return new IntervalSet();
        }
        if (elements instanceof IntervalSet) {
            intervalSet = (IntervalSet)elements;
        } else {
            void var3_2;
            IntervalSet temp = new IntervalSet();
            temp.addAll(elements);
            intervalSet = var3_2;
        }
        IntervalSet vocabularyIS = intervalSet;
        return vocabularyIS.subtract(this);
    }

    @Override
    @NotNull
    public IntervalSet subtract(@NotNull IntSet a) {
        Intrinsics.checkNotNullParameter(a, "a");
        if (a.isNil()) {
            return new IntervalSet(this);
        }
        if (a instanceof IntervalSet) {
            return Companion.subtract(this, (IntervalSet)a);
        }
        IntervalSet other = new IntervalSet();
        other.addAll(a);
        return Companion.subtract(this, other);
    }

    @Override
    @NotNull
    public IntervalSet or(@NotNull IntSet a) {
        Intrinsics.checkNotNullParameter(a, "a");
        IntervalSet o = new IntervalSet();
        o.addAll(this);
        o.addAll(a);
        return o;
    }

    @Override
    @NotNull
    public IntervalSet and(@NotNull IntSet a) {
        Intrinsics.checkNotNullParameter(a, "a");
        if (a.isNil()) {
            return new IntervalSet();
        }
        List<Interval> myIntervals = this._intervals;
        List<Interval> theirIntervals = ((IntervalSet)a)._intervals;
        IntervalSet intersection = null;
        int mySize = myIntervals.size();
        int theirSize = theirIntervals.size();
        int i = 0;
        int j = 0;
        while (i < mySize && j < theirSize) {
            Interval theirs;
            Interval mine = myIntervals.get(i);
            if (mine.startsBeforeDisjoint(theirs = theirIntervals.get(j))) {
                ++i;
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                ++j;
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++j;
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++i;
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet();
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                ++j;
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            ++i;
        }
        IntervalSet intervalSet = intersection;
        if (intervalSet == null) {
            intervalSet = new IntervalSet();
        }
        return intervalSet;
    }

    @Override
    public boolean contains(int el) {
        int n = this._intervals.size();
        int l = 0;
        int r = n - 1;
        while (l <= r) {
            int m = (l + r) / 2;
            Interval I = this._intervals.get(m);
            int a = I.getA();
            int b = I.getB();
            if (b < el) {
                l = m + 1;
                continue;
            }
            if (a > el) {
                r = m - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = MurmurHash.initialize$default(MurmurHash.INSTANCE, 0, 1, null);
        for (Interval I : this._intervals) {
            hash = MurmurHash.INSTANCE.update(hash, I.getA());
            hash = MurmurHash.INSTANCE.update(hash, I.getB());
        }
        hash = MurmurHash.INSTANCE.finish(hash, this._intervals.size() * 2);
        return hash;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IntervalSet && Intrinsics.areEqual(this._intervals, ((IntervalSet)other)._intervals);
    }

    @Override
    @NotNull
    public String toString() {
        return this.toString(false);
    }

    @NotNull
    public final String toString(boolean elemAreChar) {
        if (this._intervals.isEmpty()) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder(64);
        if (this.size() > 1) {
            buf.append("{");
        }
        int n = this._intervals.size();
        int index = 0;
        while (index < n) {
            int b;
            Interval I;
            int a;
            if ((a = (I = this._intervals.get(index++)).getA()) == (b = I.getB())) {
                if (a == -1) {
                    buf.append("<EOF>");
                } else if (elemAreChar) {
                    buf.append("'");
                    buf.appendCodePoint(a);
                    buf.append("'");
                } else {
                    buf.append(a);
                }
            } else if (elemAreChar) {
                buf.append("'");
                buf.appendCodePoint(a);
                buf.append("'..'");
                buf.appendCodePoint(b);
                buf.append("'");
            } else {
                buf.append(a);
                buf.append("..");
                buf.append(b);
            }
            if (index >= n) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String toString(@NotNull Vocabulary vocabulary) {
        Intrinsics.checkNotNullParameter(vocabulary, "vocabulary");
        if (this._intervals.isEmpty()) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder(64);
        if (this.size() > 1) {
            buf.append("{");
        }
        int n = this._intervals.size();
        int index = 0;
        while (index < n) {
            int b;
            Interval I;
            int a;
            if ((a = (I = this._intervals.get(index++)).getA()) == (b = I.getB())) {
                buf.append(this.elementName(vocabulary, a));
            } else {
                int p = a;
                if (p <= b) {
                    while (true) {
                        if (p > a) {
                            buf.append(", ");
                        }
                        buf.append(this.elementName(vocabulary, p));
                        if (p == b) break;
                        ++p;
                    }
                }
            }
            if (index >= n) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String elementName(Vocabulary vocabulary, int a) {
        String string;
        switch (a) {
            case -1: {
                string = "<EOF>";
                break;
            }
            case -2: {
                string = "<EPSILON>";
                break;
            }
            default: {
                string = vocabulary.getDisplayName(a);
            }
        }
        return string;
    }

    @Override
    public int size() {
        int numIntervals = this._intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this._intervals.get(0);
            return firstInterval.getB() - firstInterval.getA() + 1;
        }
        int n = 0;
        for (int i = 0; i < numIntervals; ++i) {
            Interval I = this._intervals.get(i);
            n += I.getB() - I.getA() + 1;
        }
        return n;
    }

    @NotNull
    public final IntegerList toIntegerList() {
        IntegerList values2 = new IntegerList(this.size());
        int n = this._intervals.size();
        block0: for (int i = 0; i < n; ++i) {
            int b;
            Interval I = this._intervals.get(i);
            int a = I.getA();
            int v = a;
            if (v > (b = I.getB())) continue;
            while (true) {
                values2.add(v);
                if (v == b) continue block0;
                ++v;
            }
        }
        return values2;
    }

    @Override
    @NotNull
    public List<Integer> toList() {
        ArrayList<Integer> values2 = new ArrayList<Integer>(32);
        int n = this._intervals.size();
        block0: for (int i = 0; i < n; ++i) {
            int b;
            Interval I = this._intervals.get(i);
            int a = I.getA();
            int v = a;
            if (v > (b = I.getB())) continue;
            while (true) {
                values2.add(v);
                if (v == b) continue block0;
                ++v;
            }
        }
        return values2;
    }

    @NotNull
    public final Set<Integer> toSet() {
        HashSet<Integer> s = new HashSet<Integer>(32);
        block0: for (Interval I : this._intervals) {
            int b;
            int a = I.getA();
            int v = a;
            if (v > (b = I.getB())) continue;
            while (true) {
                s.add(v);
                if (v == b) continue block0;
                ++v;
            }
        }
        return s;
    }

    public final int get(int i) {
        int n = this._intervals.size();
        int index = 0;
        block0: for (int j = 0; j < n; ++j) {
            int b;
            Interval I = this._intervals.get(j);
            int a = I.getA();
            int v = a;
            if (v > (b = I.getB())) continue;
            while (index != i) {
                ++index;
                if (v == b) continue block0;
                ++v;
            }
            return v;
        }
        return -1;
    }

    @Override
    public void remove(int el) {
        if (this.isReadonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n = this._intervals.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Interval I = this._intervals.get(i);
            int a = I.getA();
            int b = I.getB();
            if (el < a) break;
            if (el == a && el == b) {
                this._intervals.remove(i);
                break;
            }
            if (el == a) {
                n2 = I.getA();
                I.setA(n2 + 1);
                break;
            }
            if (el == b) {
                n2 = I.getB();
                I.setB(n2 + -1);
                break;
            }
            if (el >= b) continue;
            int oldB = I.getB();
            I.setB(el - 1);
            this.add(el + 1, oldB);
        }
    }

    static {
        IntervalSet intervalSet;
        Companion = new Companion(null);
        IntervalSet it = intervalSet = Companion.of(0, 0x10FFFF);
        boolean bl = false;
        it.setReadonly(true);
        COMPLETE_CHAR_SET = intervalSet;
        it = intervalSet = new IntervalSet();
        boolean bl2 = false;
        it.setReadonly(true);
        EMPTY_SET = intervalSet;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntervalSet$Companion;", "", "()V", "COMPLETE_CHAR_SET", "Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "getCOMPLETE_CHAR_SET", "()Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "EMPTY_SET", "getEMPTY_SET", "of", "a", "", "b", "or", "sets", "", "([Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;)Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "subtract", "left", "right", "antlr-kotlin-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntervalSet getCOMPLETE_CHAR_SET() {
            return COMPLETE_CHAR_SET;
        }

        @NotNull
        public final IntervalSet getEMPTY_SET() {
            return EMPTY_SET;
        }

        @NotNull
        public final IntervalSet of(int a) {
            IntervalSet s = new IntervalSet();
            s.add(a);
            return s;
        }

        @NotNull
        public final IntervalSet of(int a, int b) {
            IntervalSet s = new IntervalSet();
            s.add(a, b);
            return s;
        }

        @NotNull
        public final IntervalSet or(IntervalSet ... sets) {
            Intrinsics.checkNotNullParameter(sets, "sets");
            IntervalSet r = new IntervalSet();
            for (IntervalSet s : sets) {
                r.addAll(s);
            }
            return r;
        }

        @NotNull
        public final IntervalSet subtract(@NotNull IntervalSet left, @NotNull IntervalSet right) {
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            if (left.isNil()) {
                return new IntervalSet();
            }
            IntervalSet result2 = new IntervalSet(left);
            if (right.isNil()) {
                return result2;
            }
            int resultI = 0;
            int rightI = 0;
            while (resultI < result2._intervals.size() && rightI < right._intervals.size()) {
                Interval resultInterval = (Interval)result2._intervals.get(resultI);
                Interval rightInterval = (Interval)right._intervals.get(rightI);
                if (rightInterval.getB() < resultInterval.getA()) {
                    ++rightI;
                    continue;
                }
                if (rightInterval.getA() > resultInterval.getB()) {
                    ++resultI;
                    continue;
                }
                Interval beforeCurrent = null;
                Interval afterCurrent = null;
                if (rightInterval.getA() > resultInterval.getA()) {
                    beforeCurrent = new Interval(resultInterval.getA(), rightInterval.getA() - 1);
                }
                if (rightInterval.getB() < resultInterval.getB()) {
                    afterCurrent = new Interval(rightInterval.getB() + 1, resultInterval.getB());
                }
                if (beforeCurrent != null) {
                    if (afterCurrent != null) {
                        result2._intervals.set(resultI, beforeCurrent);
                        result2._intervals.add(resultI + 1, afterCurrent);
                        ++resultI;
                        ++rightI;
                        continue;
                    }
                    result2._intervals.set(resultI, beforeCurrent);
                    ++resultI;
                    continue;
                }
                if (afterCurrent != null) {
                    result2._intervals.set(resultI, afterCurrent);
                    ++rightI;
                    continue;
                }
                result2._intervals.remove(resultI);
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

