/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.misc;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.kotlinruntime.misc.IntervalSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004J\u001d\u0010\u0010\u001a\u00020\u00042\u0010\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J)\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00162\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u0002H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004J%\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060#j\u0002`$\u00a8\u0006%"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/Utils;", "", "()V", "count", "", "s", "", "x", "", "escapeWhitespace", "escapeSpaces", "", "expandTabs", "tabSize", "newlines", "n", "numNonnull", "data", "", "([Ljava/lang/Object;)I", "removeAllElements", "", "T", "", "value", "(Ljava/util/Collection;Ljava/lang/Object;)V", "sequence", "spaces", "toMap", "", "keys", "([Ljava/lang/String;)Ljava/util/Map;", "toSet", "Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "bits", "Ljava/util/BitSet;", "Lcom/strumenta/antlrkotlin/runtime/BitSet;", "antlr-kotlin-runtime"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final int numNonnull(@Nullable Object[] data) {
        if (data == null) {
            return 0;
        }
        int n = 0;
        Iterator<Object> iterator2 = ArrayIteratorKt.iterator(data);
        while (iterator2.hasNext()) {
            Object o = iterator2.next();
            if (o == null) continue;
            ++n;
        }
        return n;
    }

    public final <T> void removeAllElements(@Nullable Collection<T> data, T value2) {
        if (data == null) {
            return;
        }
        while (data.contains(value2)) {
            data.remove(value2);
        }
    }

    @NotNull
    public final String escapeWhitespace(@NotNull String s, boolean escapeSpaces) {
        Intrinsics.checkNotNullParameter(s, "s");
        StringBuilder buf = new StringBuilder();
        char[] cArray = s.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        for (char c2 : cArray) {
            if (c2 == ' ' && escapeSpaces) {
                buf.append("\u00b7");
                continue;
            }
            if (c2 == '\t') {
                buf.append("\\t");
                continue;
            }
            if (c2 == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                buf.append("\\r");
                continue;
            }
            buf.append(c2);
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final Map<String, Integer> toMap(@NotNull String[] keys2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        HashMap m = new HashMap();
        int n = keys2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = i;
            ((Map)m).put(keys2[i], n2);
        }
        return m;
    }

    @NotNull
    public final IntervalSet toSet(@NotNull BitSet bits) {
        Intrinsics.checkNotNullParameter(bits, "bits");
        IntervalSet s = new IntervalSet();
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            s.add(i);
            i = bits.nextSetBit(i + 1);
        }
        return s;
    }

    @Nullable
    public final String expandTabs(@Nullable String s, int tabSize) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int col = 0;
        for (int i = 0; i < s.length(); ++i) {
            char element = s.charAt(i);
            char c2 = element;
            if (c2 == '\n') {
                col = 0;
                buf.append(element);
                continue;
            }
            if (c2 == '\t') {
                int n = tabSize - col % tabSize;
                col += n;
                buf.append(this.spaces(n));
                continue;
            }
            ++col;
            buf.append(element);
        }
        return buf.toString();
    }

    @NotNull
    public final String spaces(int n) {
        return this.sequence(n, " ");
    }

    @NotNull
    public final String newlines(int n) {
        return this.sequence(n, "\n");
    }

    @NotNull
    public final String sequence(int n, @NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        StringBuilder buf = new StringBuilder();
        int sp = 1;
        if (sp <= n) {
            while (true) {
                buf.append(s);
                if (sp == n) break;
                ++sp;
            }
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final int count(@NotNull String s, char x) {
        Intrinsics.checkNotNullParameter(s, "s");
        int n = 0;
        int n2 = s.length();
        for (int i = 0; i < n2; ++i) {
            char element = s.charAt(i);
            if (element != x) continue;
            ++n;
        }
        return n;
    }
}

