/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.helper.ChangeNotifyingArrayList;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.Range;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Tag;
import org.jsoup.parser.TokenQueue;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.QueryParser;
import org.jsoup.select.Selector;
import org.jspecify.annotations.Nullable;

public class Element
extends Node {
    private static final List<Element> EmptyChildren = Collections.emptyList();
    private static final Pattern ClassSplit = Pattern.compile("\\s+");
    private static final String BaseUriKey = Attributes.internalKey("baseUri");
    private Tag tag;
    private @Nullable WeakReference<List<Element>> shadowChildrenRef;
    List<Node> childNodes;
    @Nullable Attributes attributes;

    public Element(String tag, String namespace) {
        this(Tag.valueOf(tag, namespace, ParseSettings.preserveCase), null);
    }

    public Element(String tag) {
        this(Tag.valueOf(tag, "http://www.w3.org/1999/xhtml", ParseSettings.preserveCase), "", null);
    }

    public Element(Tag tag, @Nullable String baseUri, @Nullable Attributes attributes) {
        Validate.notNull(tag);
        this.childNodes = EmptyNodes;
        this.attributes = attributes;
        this.tag = tag;
        if (baseUri != null) {
            this.setBaseUri(baseUri);
        }
    }

    public Element(Tag tag, @Nullable String baseUri) {
        this(tag, baseUri, null);
    }

    protected boolean hasChildNodes() {
        return this.childNodes != EmptyNodes;
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EmptyNodes) {
            this.childNodes = new NodeList(this, 4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        return Element.searchUpForAttribute(this, BaseUriKey);
    }

    private static String searchUpForAttribute(Element start, String key) {
        for (Element el = start; el != null; el = el.parent()) {
            if (el.attributes == null || !el.attributes.hasKey(key)) continue;
            return el.attributes.get(key);
        }
        return "";
    }

    @Override
    protected void doSetBaseUri(String baseUri) {
        this.attributes().put(BaseUriKey, baseUri);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    @Override
    public String normalName() {
        return this.tag.normalName();
    }

    public boolean elementIs(String normalName, String namespace) {
        return this.tag.normalName().equals(normalName) && this.tag.namespace().equals(namespace);
    }

    public Element tagName(String tagName) {
        return this.tagName(tagName, this.tag.namespace());
    }

    public Element tagName(String tagName, String namespace) {
        Validate.notEmptyParam(tagName, "tagName");
        Validate.notEmptyParam(namespace, "namespace");
        this.tag = Tag.valueOf(tagName, namespace, NodeUtils.parser(this).settings());
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        return this.attributes != null ? this.attributes.getIgnoreCase("id") : "";
    }

    public Element id(String id) {
        Validate.notNull(id);
        this.attr("id", id);
        return this;
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    public Element attr(String attributeKey, boolean attributeValue) {
        this.attributes().put(attributeKey, attributeValue);
        return this;
    }

    public Attribute attribute(String key) {
        return this.hasAttributes() ? this.attributes().attribute(key) : null;
    }

    public Map<String, String> dataset() {
        return this.attributes().dataset();
    }

    @Override
    public final @Nullable Element parent() {
        return (Element)this.parentNode;
    }

    public Elements parents() {
        Elements parents = new Elements();
        for (Element parent = this.parent(); parent != null && !parent.nameIs("#root"); parent = parent.parent()) {
            parents.add(parent);
        }
        return parents;
    }

    public Element child(int index) {
        return this.childElementsList().get(index);
    }

    public int childrenSize() {
        return this.childElementsList().size();
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    List<Element> childElementsList() {
        ArrayList<Element> children2;
        if (this.childNodeSize() == 0) {
            return EmptyChildren;
        }
        if (this.shadowChildrenRef == null || (children2 = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int size = this.childNodes.size();
            children2 = new ArrayList<Element>(size);
            for (int i = 0; i < size; ++i) {
                Node node = this.childNodes.get(i);
                if (!(node instanceof Element)) continue;
                children2.add((Element)node);
            }
            this.shadowChildrenRef = new WeakReference(children2);
        }
        return children2;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    public Stream<Element> stream() {
        return NodeUtils.stream(this, Element.class);
    }

    private <T> List<T> filterNodes(Class<T> clazz) {
        return this.childNodes.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<TextNode> textNodes() {
        return this.filterNodes(TextNode.class);
    }

    public List<DataNode> dataNodes() {
        return this.filterNodes(DataNode.class);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Elements select(Evaluator evaluator) {
        return Selector.select(evaluator, this);
    }

    public @Nullable Element selectFirst(String cssQuery) {
        return Selector.selectFirst(cssQuery, this);
    }

    public @Nullable Element selectFirst(Evaluator evaluator) {
        return Collector.findFirst(evaluator, this);
    }

    public Element expectFirst(String cssQuery) {
        return (Element)Validate.ensureNotNull(Selector.selectFirst(cssQuery, this), this.parent() != null ? "No elements matched the query '%s' on element '%s'." : "No elements matched the query '%s' in the document.", cssQuery, this.tagName());
    }

    public boolean is(String cssQuery) {
        return this.is(QueryParser.parse(cssQuery));
    }

    public boolean is(Evaluator evaluator) {
        return evaluator.matches(this.root(), this);
    }

    public @Nullable Element closest(String cssQuery) {
        return this.closest(QueryParser.parse(cssQuery));
    }

    public @Nullable Element closest(Evaluator evaluator) {
        Validate.notNull(evaluator);
        Element el = this;
        Element root = this.root();
        do {
            if (!evaluator.matches(root, el)) continue;
            return el;
        } while ((el = el.parent()) != null);
        return null;
    }

    public Elements selectXpath(String xpath) {
        return new Elements(NodeUtils.selectXpath(xpath, this, Element.class));
    }

    public <T extends Node> List<T> selectXpath(String xpath, Class<T> nodeType) {
        return NodeUtils.selectXpath(xpath, this, nodeType);
    }

    public Element appendChild(Node child) {
        Validate.notNull(child);
        this.reparentChild(child);
        this.ensureChildNodes();
        this.childNodes.add(child);
        child.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    public Element appendChildren(Collection<? extends Node> children2) {
        this.insertChildren(-1, children2);
        return this;
    }

    public Element appendTo(Element parent) {
        Validate.notNull(parent);
        parent.appendChild(this);
        return this;
    }

    public Element prependChild(Node child) {
        Validate.notNull(child);
        this.addChildren(0, child);
        return this;
    }

    public Element prependChildren(Collection<? extends Node> children2) {
        this.insertChildren(0, children2);
        return this;
    }

    public Element insertChildren(int index, Collection<? extends Node> children2) {
        Validate.notNull(children2, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= currentSize, "Insert position out of bounds.");
        ArrayList<? extends Node> nodes = new ArrayList<Node>(children2);
        Node[] nodeArray = nodes.toArray(new Node[0]);
        this.addChildren(index, nodeArray);
        return this;
    }

    public Element insertChildren(int index, Node ... children2) {
        Validate.notNull(children2, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= currentSize, "Insert position out of bounds.");
        this.addChildren(index, children2);
        return this;
    }

    public Element appendElement(String tagName) {
        return this.appendElement(tagName, this.tag.namespace());
    }

    public Element appendElement(String tagName, String namespace) {
        Element child = new Element(Tag.valueOf(tagName, namespace, NodeUtils.parser(this).settings()), this.baseUri());
        this.appendChild(child);
        return child;
    }

    public Element prependElement(String tagName) {
        return this.prependElement(tagName, this.tag.namespace());
    }

    public Element prependElement(String tagName, String namespace) {
        Element child = new Element(Tag.valueOf(tagName, namespace, NodeUtils.parser(this).settings()), this.baseUri());
        this.prependChild(child);
        return child;
    }

    public Element appendText(String text) {
        Validate.notNull(text);
        TextNode node = new TextNode(text);
        this.appendChild(node);
        return this;
    }

    public Element prependText(String text) {
        Validate.notNull(text);
        TextNode node = new TextNode(text);
        this.prependChild(node);
        return this;
    }

    public Element append(String html) {
        Validate.notNull(html);
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, this, this.baseUri());
        this.addChildren(nodes.toArray(new Node[0]));
        return this;
    }

    public Element prepend(String html) {
        Validate.notNull(html);
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, this, this.baseUri());
        this.addChildren(0, nodes.toArray(new Node[0]));
        return this;
    }

    @Override
    public Element before(String html) {
        return (Element)super.before(html);
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element after(String html) {
        return (Element)super.after(html);
    }

    @Override
    public Element after(Node node) {
        return (Element)super.after(node);
    }

    @Override
    public Element empty() {
        for (Node child : this.childNodes) {
            child.parentNode = null;
        }
        this.childNodes.clear();
        return this;
    }

    @Override
    public Element wrap(String html) {
        return (Element)super.wrap(html);
    }

    public String cssSelector() {
        if (this.id().length() > 0) {
            String idSel = "#" + TokenQueue.escapeCssIdentifier(this.id());
            Document doc = this.ownerDocument();
            if (doc != null) {
                Elements els = doc.select(idSel);
                if (els.size() == 1 && els.get(0) == this) {
                    return idSel;
                }
            } else {
                return idSel;
            }
        }
        StringBuilder selector = StringUtil.borrowBuilder();
        for (Element el = this; el != null && !(el instanceof Document); el = el.parent()) {
            selector.insert(0, el.cssSelectorComponent());
        }
        return StringUtil.releaseBuilder(selector);
    }

    private String cssSelectorComponent() {
        String tagName = TokenQueue.escapeCssIdentifier(this.tagName()).replace("\\:", "|");
        StringBuilder selector = StringUtil.borrowBuilder().append(tagName);
        String classes = this.classNames().stream().map(TokenQueue::escapeCssIdentifier).collect(StringUtil.joining("."));
        if (!classes.isEmpty()) {
            selector.append('.').append(classes);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return StringUtil.releaseBuilder(selector);
        }
        selector.insert(0, " > ");
        if (this.parent().select(selector.toString()).size() > 1) {
            selector.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return StringUtil.releaseBuilder(selector);
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        for (Element el : elements) {
            if (el == this) continue;
            siblings.add(el);
        }
        return siblings;
    }

    public @Nullable Element nextElementSibling() {
        Node next = this;
        while ((next = next.nextSibling()) != null) {
            if (!(next instanceof Element)) continue;
            return next;
        }
        return null;
    }

    public Elements nextElementSiblings() {
        return this.nextElementSiblings(true);
    }

    public @Nullable Element previousElementSibling() {
        Node prev = this;
        while ((prev = prev.previousSibling()) != null) {
            if (!(prev instanceof Element)) continue;
            return prev;
        }
        return null;
    }

    public Elements previousElementSiblings() {
        return this.nextElementSiblings(false);
    }

    private Elements nextElementSiblings(boolean next) {
        Elements els = new Elements();
        if (this.parentNode == null) {
            return els;
        }
        els.add(this);
        return next ? els.nextAll() : els.prevAll();
    }

    public Element firstElementSibling() {
        if (this.parent() != null) {
            return this.parent().firstElementChild();
        }
        return this;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().childElementsList());
    }

    public Element lastElementSibling() {
        if (this.parent() != null) {
            return this.parent().lastElementChild();
        }
        return this;
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    public @Nullable Element firstElementChild() {
        for (Node child = this.firstChild(); child != null; child = child.nextSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public @Nullable Element lastElementChild() {
        for (Node child = this.lastChild(); child != null; child = child.previousSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public Elements getElementsByTag(String tagName) {
        Validate.notEmpty(tagName);
        tagName = Normalizer.normalize(tagName);
        return Collector.collect(new Evaluator.Tag(tagName), this);
    }

    public @Nullable Element getElementById(String id) {
        Validate.notEmpty(id);
        Elements elements = Collector.collect(new Evaluator.Id(id), this);
        if (elements.size() > 0) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String className) {
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class(className), this);
    }

    public Elements getElementsByAttribute(String key) {
        Validate.notEmpty(key);
        key = key.trim();
        return Collector.collect(new Evaluator.Attribute(key), this);
    }

    public Elements getElementsByAttributeStarting(String keyPrefix) {
        Validate.notEmpty(keyPrefix);
        keyPrefix = keyPrefix.trim();
        return Collector.collect(new Evaluator.AttributeStarting(keyPrefix), this);
    }

    public Elements getElementsByAttributeValue(String key, String value2) {
        return Collector.collect(new Evaluator.AttributeWithValue(key, value2), this);
    }

    public Elements getElementsByAttributeValueNot(String key, String value2) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(key, value2), this);
    }

    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(key, valuePrefix), this);
    }

    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(key, valueSuffix), this);
    }

    public Elements getElementsByAttributeValueContaining(String key, String match) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(key, match), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(key, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsByAttributeValueMatching(key, pattern);
    }

    public Elements getElementsByIndexLessThan(int index) {
        return Collector.collect(new Evaluator.IndexLessThan(index), this);
    }

    public Elements getElementsByIndexGreaterThan(int index) {
        return Collector.collect(new Evaluator.IndexGreaterThan(index), this);
    }

    public Elements getElementsByIndexEquals(int index) {
        return Collector.collect(new Evaluator.IndexEquals(index), this);
    }

    public Elements getElementsContainingText(String searchText) {
        return Collector.collect(new Evaluator.ContainsText(searchText), this);
    }

    public Elements getElementsContainingOwnText(String searchText) {
        return Collector.collect(new Evaluator.ContainsOwnText(searchText), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        StringBuilder accum = StringUtil.borrowBuilder();
        NodeTraversor.traverse((NodeVisitor)new TextAccumulator(accum), this);
        return StringUtil.releaseBuilder(accum).trim();
    }

    public String wholeText() {
        StringBuilder accum = StringUtil.borrowBuilder();
        this.nodeStream().forEach((? super T node) -> Element.appendWholeText(node, accum));
        return StringUtil.releaseBuilder(accum);
    }

    private static void appendWholeText(Node node, StringBuilder accum) {
        if (node instanceof TextNode) {
            accum.append(((TextNode)node).getWholeText());
        } else if (node.nameIs("br")) {
            accum.append("\n");
        }
    }

    public String wholeOwnText() {
        StringBuilder accum = StringUtil.borrowBuilder();
        int size = this.childNodeSize();
        for (int i = 0; i < size; ++i) {
            Node node = this.childNodes.get(i);
            Element.appendWholeText(node, accum);
        }
        return StringUtil.releaseBuilder(accum);
    }

    public String ownText() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.ownText(sb);
        return StringUtil.releaseBuilder(sb).trim();
    }

    private void ownText(StringBuilder accum) {
        for (int i = 0; i < this.childNodeSize(); ++i) {
            Node child = this.childNodes.get(i);
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                Element.appendNormalisedText(accum, textNode);
                continue;
            }
            if (!child.nameIs("br") || TextNode.lastCharIsWhitespace(accum)) continue;
            accum.append(" ");
        }
    }

    private static void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        String text = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || textNode instanceof CDataNode) {
            accum.append(text);
        } else {
            StringUtil.appendNormalisedWhitespace(accum, text, TextNode.lastCharIsWhitespace(accum));
        }
    }

    static boolean preserveWhitespace(@Nullable Node node) {
        if (node instanceof Element) {
            Element el = (Element)node;
            int i = 0;
            do {
                if (el.tag.preserveWhitespace()) {
                    return true;
                }
                el = el.parent();
            } while (++i < 6 && el != null);
        }
        return false;
    }

    public Element text(String text) {
        Validate.notNull(text);
        this.empty();
        Document owner = this.ownerDocument();
        if (owner != null && owner.parser().isContentForTagData(this.normalName())) {
            this.appendChild(new DataNode(text));
        } else {
            this.appendChild(new TextNode(text));
        }
        return this;
    }

    public boolean hasText() {
        AtomicBoolean hasText = new AtomicBoolean(false);
        this.filter((node, depth) -> {
            TextNode textNode;
            if (node instanceof TextNode && !(textNode = (TextNode)node).isBlank()) {
                hasText.set(true);
                return NodeFilter.FilterResult.STOP;
            }
            return NodeFilter.FilterResult.CONTINUE;
        });
        return hasText.get();
    }

    public String data() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.traverse((childNode, depth) -> {
            if (childNode instanceof DataNode) {
                DataNode data = (DataNode)childNode;
                sb.append(data.getWholeData());
            } else if (childNode instanceof Comment) {
                Comment comment = (Comment)childNode;
                sb.append(comment.getData());
            } else if (childNode instanceof CDataNode) {
                CDataNode cDataNode = (CDataNode)childNode;
                sb.append(cDataNode.getWholeText());
            }
        });
        return StringUtil.releaseBuilder(sb);
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set<String> classNames() {
        String[] names = ClassSplit.split(this.className());
        LinkedHashSet<String> classNames = new LinkedHashSet<String>(Arrays.asList(names));
        classNames.remove("");
        return classNames;
    }

    public Element classNames(Set<String> classNames) {
        Validate.notNull(classNames);
        if (classNames.isEmpty()) {
            this.attributes().remove("class");
        } else {
            this.attributes().put("class", StringUtil.join(classNames, " "));
        }
        return this;
    }

    public boolean hasClass(String className) {
        if (this.attributes == null) {
            return false;
        }
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start == wantLen && classAttr.regionMatches(true, start, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start = i;
        }
        if (inClass && len - start == wantLen) {
            return classAttr.regionMatches(true, start, className, 0, wantLen);
        }
        return false;
    }

    public Element addClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.add(className);
        this.classNames(classes);
        return this;
    }

    public Element removeClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.remove(className);
        this.classNames(classes);
        return this;
    }

    public Element toggleClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        if (classes.contains(className)) {
            classes.remove(className);
        } else {
            classes.add(className);
        }
        this.classNames(classes);
        return this;
    }

    public String val() {
        if (this.elementIs("textarea", "http://www.w3.org/1999/xhtml")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String value2) {
        if (this.elementIs("textarea", "http://www.w3.org/1999/xhtml")) {
            this.text(value2);
        } else {
            this.attr("value", value2);
        }
        return this;
    }

    public Range endSourceRange() {
        return Range.of(this, false);
    }

    boolean shouldIndent(Document.OutputSettings out) {
        return out.prettyPrint() && this.isFormatAsBlock(out) && !this.isInlineable(out) && !Element.preserveWhitespace(this.parentNode);
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (this.shouldIndent(out)) {
            if (accum instanceof StringBuilder) {
                if (((StringBuilder)accum).length() > 0) {
                    this.indent(accum, depth, out);
                }
            } else {
                this.indent(accum, depth, out);
            }
        }
        accum.append('<').append(this.tagName());
        if (this.attributes != null) {
            this.attributes.html(accum, out);
        }
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            if (out.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                accum.append('>');
            } else {
                accum.append(" />");
            }
        } else {
            accum.append('>');
        }
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (out.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() && !Element.preserveWhitespace(this.parentNode) || out.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && this.childNodes.get(0) instanceof Element))) {
                this.indent(accum, depth, out);
            }
            accum.append("</").append(this.tagName()).append('>');
        }
    }

    public String html() {
        StringBuilder accum = StringUtil.borrowBuilder();
        this.html(accum);
        String html = StringUtil.releaseBuilder(accum);
        return NodeUtils.outputSettings(this).prettyPrint() ? html.trim() : html;
    }

    @Override
    public <T extends Appendable> T html(T appendable) {
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            this.childNodes.get(i).outerHtml(appendable);
        }
        return appendable;
    }

    public Element html(String html) {
        this.empty();
        this.append(html);
        return this;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    @Override
    public Element shallowClone() {
        String baseUri = this.baseUri();
        if (baseUri.isEmpty()) {
            baseUri = null;
        }
        return new Element(this.tag, baseUri, this.attributes == null ? null : this.attributes.clone());
    }

    @Override
    protected Element doClone(@Nullable Node parent) {
        Element clone = (Element)super.doClone(parent);
        clone.attributes = this.attributes != null ? this.attributes.clone() : null;
        clone.childNodes = new NodeList(clone, this.childNodes.size());
        clone.childNodes.addAll(this.childNodes);
        return clone;
    }

    @Override
    public Element clearAttributes() {
        if (this.attributes != null) {
            super.clearAttributes();
            if (this.attributes.size() == 0) {
                this.attributes = null;
            }
        }
        return this;
    }

    @Override
    public Element removeAttr(String attributeKey) {
        return (Element)super.removeAttr(attributeKey);
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    @Override
    public Element traverse(NodeVisitor nodeVisitor) {
        return (Element)super.traverse(nodeVisitor);
    }

    @Override
    public Element forEachNode(Consumer<? super Node> action) {
        return (Element)super.forEachNode(action);
    }

    @Deprecated
    public Element forEach(Consumer<? super Element> action) {
        this.stream().forEach(action);
        return this;
    }

    @Override
    public Element filter(NodeFilter nodeFilter) {
        return (Element)super.filter(nodeFilter);
    }

    private boolean isFormatAsBlock(Document.OutputSettings out) {
        return this.tag.isBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || out.outline();
    }

    private boolean isInlineable(Document.OutputSettings out) {
        if (!this.tag.isInline()) {
            return false;
        }
        return (this.parent() == null || this.parent().isBlock()) && !this.isEffectivelyFirst() && !out.outline() && !this.nameIs("br");
    }

    private static final class NodeList
    extends ChangeNotifyingArrayList<Node> {
        private final Element owner;

        NodeList(Element owner, int initialCapacity) {
            super(initialCapacity);
            this.owner = owner;
        }

        @Override
        public void onContentsChanged() {
            this.owner.nodelistChanged();
        }
    }

    private static class TextAccumulator
    implements NodeVisitor {
        private final StringBuilder accum;

        public TextAccumulator(StringBuilder accum) {
            this.accum = accum;
        }

        @Override
        public void head(Node node, int depth) {
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Element.appendNormalisedText(this.accum, textNode);
            } else if (node instanceof Element) {
                Element element = (Element)node;
                if (this.accum.length() > 0 && (element.isBlock() || element.nameIs("br")) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }

        @Override
        public void tail(Node node, int depth) {
            if (node instanceof Element) {
                Element element = (Element)node;
                Node next = node.nextSibling();
                if (element.isBlock() && (next instanceof TextNode || next instanceof Element && !((Element)next).tag.formatAsBlock()) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }
    }
}

