/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTOutputBase {
    public static final int EGL_BAD_OUTPUT_LAYER_EXT = 12845;
    public static final int EGL_BAD_OUTPUT_PORT_EXT = 12846;
    public static final int EGL_SWAP_INTERVAL_EXT = 12847;
    public static final long EGL_NO_OUTPUT_LAYER_EXT = 0L;
    public static final long EGL_NO_OUTPUT_PORT_EXT = 0L;

    protected EXTOutputBase() {
        throw new UnsupportedOperationException();
    }

    public static int neglGetOutputLayersEXT(long dpy, long attrib_list, long layers, int max_layers, long num_layers) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputLayersEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPPPI(dpy, attrib_list, layers, max_layers, num_layers, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetOutputLayersEXT(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list, @Nullable @NativeType(value="EGLOutputLayerEXT *") PointerBuffer layers, @NativeType(value="EGLint *") IntBuffer num_layers) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
            Checks.check((Buffer)num_layers, 1);
        }
        return EXTOutputBase.neglGetOutputLayersEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(layers), Checks.remainingSafe(layers), MemoryUtil.memAddress(num_layers)) != 0;
    }

    public static int neglGetOutputPortsEXT(long dpy, long attrib_list, long ports, int max_ports, long num_ports) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputPortsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPPPI(dpy, attrib_list, ports, max_ports, num_ports, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetOutputPortsEXT(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list, @Nullable @NativeType(value="EGLOutputPortEXT *") PointerBuffer ports, @NativeType(value="EGLint *") IntBuffer num_ports) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
            Checks.check((Buffer)num_ports, 1);
        }
        return EXTOutputBase.neglGetOutputPortsEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(ports), Checks.remainingSafe(ports), MemoryUtil.memAddress(num_ports)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglOutputLayerAttribEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLOutputLayerEXT") long layer, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib") long value2) {
        long __functionAddress = EGL.getCapabilities().eglOutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(layer);
        }
        return JNI.callPPPI(dpy, layer, attribute, value2, __functionAddress) != 0;
    }

    public static int neglQueryOutputLayerAttribEXT(long dpy, long layer, int attribute, long value2) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(layer);
        }
        return JNI.callPPPI(dpy, layer, attribute, value2, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryOutputLayerAttribEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLOutputLayerEXT") long layer, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value2) {
        if (Checks.CHECKS) {
            Checks.check(value2, 1);
        }
        return EXTOutputBase.neglQueryOutputLayerAttribEXT(dpy, layer, attribute, MemoryUtil.memAddress(value2)) != 0;
    }

    public static long neglQueryOutputLayerStringEXT(long dpy, long layer, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputLayerStringEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(layer);
        }
        return JNI.callPPP(dpy, layer, name, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String eglQueryOutputLayerStringEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLOutputLayerEXT") long layer, @NativeType(value="EGLint") int name) {
        long __result = EXTOutputBase.neglQueryOutputLayerStringEXT(dpy, layer, name);
        return MemoryUtil.memASCIISafe(__result);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglOutputPortAttribEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLOutputPortEXT") long port, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib") long value2) {
        long __functionAddress = EGL.getCapabilities().eglOutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(port);
        }
        return JNI.callPPPI(dpy, port, attribute, value2, __functionAddress) != 0;
    }

    public static int neglQueryOutputPortAttribEXT(long dpy, long port, int attribute, long value2) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(port);
        }
        return JNI.callPPPI(dpy, port, attribute, value2, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryOutputPortAttribEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLOutputPortEXT") long port, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value2) {
        if (Checks.CHECKS) {
            Checks.check(value2, 1);
        }
        return EXTOutputBase.neglQueryOutputPortAttribEXT(dpy, port, attribute, MemoryUtil.memAddress(value2)) != 0;
    }

    public static long neglQueryOutputPortStringEXT(long dpy, long port, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryOutputPortStringEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(port);
        }
        return JNI.callPPP(dpy, port, name, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String eglQueryOutputPortStringEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLOutputPortEXT") long port, @NativeType(value="EGLint") int name) {
        long __result = EXTOutputBase.neglQueryOutputPortStringEXT(dpy, port, name);
        return MemoryUtil.memASCIISafe(__result);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetOutputLayersEXT(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list, @Nullable @NativeType(value="EGLOutputLayerEXT *") PointerBuffer layers, @NativeType(value="EGLint *") int[] num_layers) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputLayersEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.checkNTSafe(attrib_list, 12344L);
            Checks.check(num_layers, 1);
        }
        return JNI.callPPPPI(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(layers), Checks.remainingSafe(layers), num_layers, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetOutputPortsEXT(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list, @Nullable @NativeType(value="EGLOutputPortEXT *") PointerBuffer ports, @NativeType(value="EGLint *") int[] num_ports) {
        long __functionAddress = EGL.getCapabilities().eglGetOutputPortsEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.checkNTSafe(attrib_list, 12344L);
            Checks.check(num_ports, 1);
        }
        return JNI.callPPPPI(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(ports), Checks.remainingSafe(ports), num_ports, __functionAddress) != 0;
    }
}

