/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLDebugMessageKHRCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRDebug {
    public static final int EGL_OBJECT_THREAD_KHR = 13232;
    public static final int EGL_OBJECT_DISPLAY_KHR = 13233;
    public static final int EGL_OBJECT_CONTEXT_KHR = 13234;
    public static final int EGL_OBJECT_SURFACE_KHR = 13235;
    public static final int EGL_OBJECT_IMAGE_KHR = 13236;
    public static final int EGL_OBJECT_SYNC_KHR = 13237;
    public static final int EGL_OBJECT_STREAM_KHR = 13238;
    public static final int EGL_DEBUG_MSG_CRITICAL_KHR = 13241;
    public static final int EGL_DEBUG_MSG_ERROR_KHR = 13242;
    public static final int EGL_DEBUG_MSG_WARN_KHR = 13243;
    public static final int EGL_DEBUG_MSG_INFO_KHR = 13244;
    public static final int EGL_DEBUG_CALLBACK_KHR = 13240;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    public static int neglDebugMessageControlKHR(long callback2, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(callback2, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLint")
    public static int eglDebugMessageControlKHR(@NativeType(value="EGLDEBUGPROCKHR") EGLDebugMessageKHRCallbackI callback2, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return KHRDebug.neglDebugMessageControlKHR(callback2.address(), MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int neglQueryDebugKHR(int attribute, long value2) {
        long __functionAddress = EGL.getCapabilities().eglQueryDebugKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(attribute, value2, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDebugKHR(@NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value2) {
        if (Checks.CHECKS) {
            Checks.check(value2, 1);
        }
        return KHRDebug.neglQueryDebugKHR(attribute, MemoryUtil.memAddress(value2)) != 0;
    }

    @NativeType(value="EGLint")
    public static int eglLabelObjectKHR(@NativeType(value="EGLDisplay") long display, @NativeType(value="EGLenum") int objectType, @NativeType(value="EGLObjectKHR") long object, @NativeType(value="EGLLabelKHR") long label) {
        long __functionAddress = EGL.getCapabilities().eglLabelObjectKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(display);
            Checks.check(object);
            Checks.check(label);
        }
        return JNI.callPPPI(display, objectType, object, label, __functionAddress);
    }
}

