/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class NVStreamConsumerEGLImage {
    public static final int EGL_STREAM_CONSUMER_IMAGE_NV = 13171;
    public static final int EGL_STREAM_IMAGE_ADD_NV = 13172;
    public static final int EGL_STREAM_IMAGE_REMOVE_NV = 13173;
    public static final int EGL_STREAM_IMAGE_AVAILABLE_NV = 13174;

    protected NVStreamConsumerEGLImage() {
        throw new UnsupportedOperationException();
    }

    public static int neglStreamImageConsumerConnectNV(long dpy, long stream, int num_modifiers, long modifiers, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamImageConsumerConnectNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPPI(dpy, stream, num_modifiers, modifiers, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamImageConsumerConnectNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLuint64KHR const *") LongBuffer modifiers, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return NVStreamConsumerEGLImage.neglStreamImageConsumerConnectNV(dpy, stream, modifiers.remaining(), MemoryUtil.memAddress(modifiers), MemoryUtil.memAddressSafe(attrib_list)) != 0;
    }

    public static int neglQueryStreamConsumerEventNV(long dpy, long stream, long timeout, long event, long aux) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamConsumerEventNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPJPPI(dpy, stream, timeout, event, aux, __functionAddress);
    }

    @NativeType(value="EGLint")
    public static int eglQueryStreamConsumerEventNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLTime") long timeout, @NativeType(value="EGLenum *") IntBuffer event, @NativeType(value="EGLAttrib *") PointerBuffer aux) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)event, 1);
            Checks.check(aux, 1);
        }
        return NVStreamConsumerEGLImage.neglQueryStreamConsumerEventNV(dpy, stream, timeout, MemoryUtil.memAddress(event), MemoryUtil.memAddress(aux));
    }

    public static int neglStreamAcquireImageNV(long dpy, long stream, long pImage, long sync) {
        long __functionAddress = EGL.getCapabilities().eglStreamAcquireImageNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.check(sync);
        }
        return JNI.callPPPPI(dpy, stream, pImage, sync, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamAcquireImageNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLImage *") PointerBuffer pImage, @NativeType(value="EGLSync") long sync) {
        if (Checks.CHECKS) {
            Checks.check(pImage, 1);
        }
        return NVStreamConsumerEGLImage.neglStreamAcquireImageNV(dpy, stream, MemoryUtil.memAddress(pImage), sync) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamReleaseImageNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLImage") long image, @NativeType(value="EGLSync") long sync) {
        long __functionAddress = EGL.getCapabilities().eglStreamReleaseImageNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.check(image);
            Checks.check(sync);
        }
        return JNI.callPPPPI(dpy, stream, image, sync, __functionAddress) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamImageConsumerConnectNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLuint64KHR const *") long[] modifiers, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamImageConsumerConnectNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return JNI.callPPPPI(dpy, stream, modifiers.length, modifiers, MemoryUtil.memAddressSafe(attrib_list), __functionAddress) != 0;
    }

    @NativeType(value="EGLint")
    public static int eglQueryStreamConsumerEventNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLTime") long timeout, @NativeType(value="EGLenum *") int[] event, @NativeType(value="EGLAttrib *") PointerBuffer aux) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamConsumerEventNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.check(event, 1);
            Checks.check(aux, 1);
        }
        return JNI.callPPJPPI(dpy, stream, timeout, event, MemoryUtil.memAddress(aux), __functionAddress);
    }
}

