/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class NVViewportArray {
    public static final int GL_MAX_VIEWPORTS_NV = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_NV = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_NV = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 33375;

    protected NVViewportArray() {
        throw new UnsupportedOperationException();
    }

    public static native void nglViewportArrayvNV(int var0, int var1, long var2);

    public static void glViewportArrayvNV(@NativeType(value="GLuint") int first2, @NativeType(value="GLfloat const *") FloatBuffer v) {
        NVViewportArray.nglViewportArrayvNV(first2, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glViewportIndexedfNV(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3, @NativeType(value="GLfloat") float var4);

    public static native void nglViewportIndexedfvNV(int var0, long var1);

    public static void glViewportIndexedfvNV(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        NVViewportArray.nglViewportIndexedfvNV(index, MemoryUtil.memAddress(v));
    }

    public static native void nglScissorArrayvNV(int var0, int var1, long var2);

    public static void glScissorArrayvNV(@NativeType(value="GLuint") int first2, @NativeType(value="GLint const *") IntBuffer v) {
        NVViewportArray.nglScissorArrayvNV(first2, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glScissorIndexedNV(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLsizei") int var3, @NativeType(value="GLsizei") int var4);

    public static native void nglScissorIndexedvNV(int var0, long var1);

    public static void glScissorIndexedvNV(@NativeType(value="GLuint") int index, @NativeType(value="GLint const *") IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        NVViewportArray.nglScissorIndexedvNV(index, MemoryUtil.memAddress(v));
    }

    public static native void nglDepthRangeArrayfvNV(int var0, int var1, long var2);

    public static void glDepthRangeArrayfvNV(@NativeType(value="GLuint") int first2, @NativeType(value="GLfloat const *") FloatBuffer v) {
        NVViewportArray.nglDepthRangeArrayfvNV(first2, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void glDepthRangeIndexedfNV(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2);

    public static native void nglGetFloati_vNV(int var0, int var1, long var2);

    public static void glGetFloati_vNV(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLfloat *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static float glGetFloatiNV(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glEnableiNV(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void glDisableiNV(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    @NativeType(value="GLboolean")
    public static native boolean glIsEnablediNV(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static void glViewportArrayvNV(@NativeType(value="GLuint") int first2, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glViewportArrayvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(first2, v.length >> 2, v, __functionAddress);
    }

    public static void glViewportIndexedfvNV(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glViewportIndexedfvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(index, v, __functionAddress);
    }

    public static void glScissorArrayvNV(@NativeType(value="GLuint") int first2, @NativeType(value="GLint const *") int[] v) {
        long __functionAddress = GLES.getICD().glScissorArrayvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(first2, v.length >> 2, v, __functionAddress);
    }

    public static void glScissorIndexedvNV(@NativeType(value="GLuint") int index, @NativeType(value="GLint const *") int[] v) {
        long __functionAddress = GLES.getICD().glScissorIndexedvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(index, v, __functionAddress);
    }

    public static void glDepthRangeArrayfvNV(@NativeType(value="GLuint") int first2, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glDepthRangeArrayfvNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(first2, v.length >> 1, v, __functionAddress);
    }

    public static void glGetFloati_vNV(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLfloat *") float[] data) {
        long __functionAddress = GLES.getICD().glGetFloati_vNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(target, index, data, __functionAddress);
    }

    static {
        GLES.initialize();
    }
}

