/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.WindowProc;
import org.lwjgl.system.windows.WindowProcI;

public class WNDCLASSEX
extends Struct<WNDCLASSEX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CBSIZE;
    public static final int STYLE;
    public static final int LPFNWNDPROC;
    public static final int CBCLSEXTRA;
    public static final int CBWNDEXTRA;
    public static final int HINSTANCE;
    public static final int HICON;
    public static final int HCURSOR;
    public static final int HBRBACKGROUND;
    public static final int LPSZMENUNAME;
    public static final int LPSZCLASSNAME;
    public static final int HICONSM;

    protected WNDCLASSEX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected WNDCLASSEX create(long address, @Nullable ByteBuffer container) {
        return new WNDCLASSEX(address, container);
    }

    public WNDCLASSEX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), WNDCLASSEX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="UINT")
    public int cbSize() {
        return WNDCLASSEX.ncbSize(this.address());
    }

    @NativeType(value="UINT")
    public int style() {
        return WNDCLASSEX.nstyle(this.address());
    }

    @NativeType(value="WNDPROC")
    public WindowProc lpfnWndProc() {
        return WNDCLASSEX.nlpfnWndProc(this.address());
    }

    public int cbClsExtra() {
        return WNDCLASSEX.ncbClsExtra(this.address());
    }

    public int cbWndExtra() {
        return WNDCLASSEX.ncbWndExtra(this.address());
    }

    @NativeType(value="HINSTANCE")
    public long hInstance() {
        return WNDCLASSEX.nhInstance(this.address());
    }

    @NativeType(value="HICON")
    public long hIcon() {
        return WNDCLASSEX.nhIcon(this.address());
    }

    @NativeType(value="HCURSOR")
    public long hCursor() {
        return WNDCLASSEX.nhCursor(this.address());
    }

    @NativeType(value="HBRUSH")
    public long hbrBackground() {
        return WNDCLASSEX.nhbrBackground(this.address());
    }

    @Nullable
    @NativeType(value="LPCTSTR")
    public ByteBuffer lpszMenuName() {
        return WNDCLASSEX.nlpszMenuName(this.address());
    }

    @Nullable
    @NativeType(value="LPCTSTR")
    public String lpszMenuNameString() {
        return WNDCLASSEX.nlpszMenuNameString(this.address());
    }

    @NativeType(value="LPCTSTR")
    public ByteBuffer lpszClassName() {
        return WNDCLASSEX.nlpszClassName(this.address());
    }

    @NativeType(value="LPCTSTR")
    public String lpszClassNameString() {
        return WNDCLASSEX.nlpszClassNameString(this.address());
    }

    @NativeType(value="HICON")
    public long hIconSm() {
        return WNDCLASSEX.nhIconSm(this.address());
    }

    public WNDCLASSEX cbSize(@NativeType(value="UINT") int value2) {
        WNDCLASSEX.ncbSize(this.address(), value2);
        return this;
    }

    public WNDCLASSEX style(@NativeType(value="UINT") int value2) {
        WNDCLASSEX.nstyle(this.address(), value2);
        return this;
    }

    public WNDCLASSEX lpfnWndProc(@NativeType(value="WNDPROC") WindowProcI value2) {
        WNDCLASSEX.nlpfnWndProc(this.address(), value2);
        return this;
    }

    public WNDCLASSEX cbClsExtra(int value2) {
        WNDCLASSEX.ncbClsExtra(this.address(), value2);
        return this;
    }

    public WNDCLASSEX cbWndExtra(int value2) {
        WNDCLASSEX.ncbWndExtra(this.address(), value2);
        return this;
    }

    public WNDCLASSEX hInstance(@NativeType(value="HINSTANCE") long value2) {
        WNDCLASSEX.nhInstance(this.address(), value2);
        return this;
    }

    public WNDCLASSEX hIcon(@NativeType(value="HICON") long value2) {
        WNDCLASSEX.nhIcon(this.address(), value2);
        return this;
    }

    public WNDCLASSEX hCursor(@NativeType(value="HCURSOR") long value2) {
        WNDCLASSEX.nhCursor(this.address(), value2);
        return this;
    }

    public WNDCLASSEX hbrBackground(@NativeType(value="HBRUSH") long value2) {
        WNDCLASSEX.nhbrBackground(this.address(), value2);
        return this;
    }

    public WNDCLASSEX lpszMenuName(@Nullable @NativeType(value="LPCTSTR") ByteBuffer value2) {
        WNDCLASSEX.nlpszMenuName(this.address(), value2);
        return this;
    }

    public WNDCLASSEX lpszClassName(@NativeType(value="LPCTSTR") ByteBuffer value2) {
        WNDCLASSEX.nlpszClassName(this.address(), value2);
        return this;
    }

    public WNDCLASSEX hIconSm(@NativeType(value="HICON") long value2) {
        WNDCLASSEX.nhIconSm(this.address(), value2);
        return this;
    }

    public WNDCLASSEX set(int cbSize, int style, WindowProcI lpfnWndProc, int cbClsExtra, int cbWndExtra, long hInstance, long hIcon, long hCursor, long hbrBackground, @Nullable ByteBuffer lpszMenuName, ByteBuffer lpszClassName, long hIconSm) {
        this.cbSize(cbSize);
        this.style(style);
        this.lpfnWndProc(lpfnWndProc);
        this.cbClsExtra(cbClsExtra);
        this.cbWndExtra(cbWndExtra);
        this.hInstance(hInstance);
        this.hIcon(hIcon);
        this.hCursor(hCursor);
        this.hbrBackground(hbrBackground);
        this.lpszMenuName(lpszMenuName);
        this.lpszClassName(lpszClassName);
        this.hIconSm(hIconSm);
        return this;
    }

    public WNDCLASSEX set(WNDCLASSEX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static WNDCLASSEX malloc() {
        return new WNDCLASSEX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static WNDCLASSEX calloc() {
        return new WNDCLASSEX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static WNDCLASSEX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new WNDCLASSEX(MemoryUtil.memAddress(container), container);
    }

    public static WNDCLASSEX create(long address) {
        return new WNDCLASSEX(address, null);
    }

    @Nullable
    public static WNDCLASSEX createSafe(long address) {
        return address == 0L ? null : new WNDCLASSEX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(WNDCLASSEX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = WNDCLASSEX.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static WNDCLASSEX mallocStack() {
        return WNDCLASSEX.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static WNDCLASSEX callocStack() {
        return WNDCLASSEX.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static WNDCLASSEX mallocStack(MemoryStack stack) {
        return WNDCLASSEX.malloc(stack);
    }

    @Deprecated
    public static WNDCLASSEX callocStack(MemoryStack stack) {
        return WNDCLASSEX.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return WNDCLASSEX.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return WNDCLASSEX.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return WNDCLASSEX.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return WNDCLASSEX.calloc(capacity, stack);
    }

    public static WNDCLASSEX malloc(MemoryStack stack) {
        return new WNDCLASSEX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static WNDCLASSEX calloc(MemoryStack stack) {
        return new WNDCLASSEX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)CBSIZE);
    }

    public static int nstyle(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYLE);
    }

    public static WindowProc nlpfnWndProc(long struct) {
        return WindowProc.create(MemoryUtil.memGetAddress(struct + (long)LPFNWNDPROC));
    }

    public static int ncbClsExtra(long struct) {
        return UNSAFE.getInt(null, struct + (long)CBCLSEXTRA);
    }

    public static int ncbWndExtra(long struct) {
        return UNSAFE.getInt(null, struct + (long)CBWNDEXTRA);
    }

    public static long nhInstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HINSTANCE);
    }

    public static long nhIcon(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HICON);
    }

    public static long nhCursor(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HCURSOR);
    }

    public static long nhbrBackground(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HBRBACKGROUND);
    }

    @Nullable
    public static ByteBuffer nlpszMenuName(long struct) {
        return MemoryUtil.memByteBufferNT2Safe(MemoryUtil.memGetAddress(struct + (long)LPSZMENUNAME));
    }

    @Nullable
    public static String nlpszMenuNameString(long struct) {
        return MemoryUtil.memUTF16Safe(MemoryUtil.memGetAddress(struct + (long)LPSZMENUNAME));
    }

    public static ByteBuffer nlpszClassName(long struct) {
        return MemoryUtil.memByteBufferNT2(MemoryUtil.memGetAddress(struct + (long)LPSZCLASSNAME));
    }

    public static String nlpszClassNameString(long struct) {
        return MemoryUtil.memUTF16(MemoryUtil.memGetAddress(struct + (long)LPSZCLASSNAME));
    }

    public static long nhIconSm(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HICONSM);
    }

    public static void ncbSize(long struct, int value2) {
        UNSAFE.putInt(null, struct + (long)CBSIZE, value2);
    }

    public static void nstyle(long struct, int value2) {
        UNSAFE.putInt(null, struct + (long)STYLE, value2);
    }

    public static void nlpfnWndProc(long struct, WindowProcI value2) {
        MemoryUtil.memPutAddress(struct + (long)LPFNWNDPROC, value2.address());
    }

    public static void ncbClsExtra(long struct, int value2) {
        UNSAFE.putInt(null, struct + (long)CBCLSEXTRA, value2);
    }

    public static void ncbWndExtra(long struct, int value2) {
        UNSAFE.putInt(null, struct + (long)CBWNDEXTRA, value2);
    }

    public static void nhInstance(long struct, long value2) {
        MemoryUtil.memPutAddress(struct + (long)HINSTANCE, value2);
    }

    public static void nhIcon(long struct, long value2) {
        MemoryUtil.memPutAddress(struct + (long)HICON, value2);
    }

    public static void nhCursor(long struct, long value2) {
        MemoryUtil.memPutAddress(struct + (long)HCURSOR, value2);
    }

    public static void nhbrBackground(long struct, long value2) {
        MemoryUtil.memPutAddress(struct + (long)HBRBACKGROUND, value2);
    }

    public static void nlpszMenuName(long struct, @Nullable ByteBuffer value2) {
        if (Checks.CHECKS) {
            Checks.checkNT2Safe(value2);
        }
        MemoryUtil.memPutAddress(struct + (long)LPSZMENUNAME, MemoryUtil.memAddressSafe(value2));
    }

    public static void nlpszClassName(long struct, ByteBuffer value2) {
        if (Checks.CHECKS) {
            Checks.checkNT2(value2);
        }
        MemoryUtil.memPutAddress(struct + (long)LPSZCLASSNAME, MemoryUtil.memAddress(value2));
    }

    public static void nhIconSm(long struct, long value2) {
        MemoryUtil.memPutAddress(struct + (long)HICONSM, value2);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)LPFNWNDPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)LPSZCLASSNAME));
    }

    static {
        Struct.Layout layout = WNDCLASSEX.__struct(WNDCLASSEX.__member(4), WNDCLASSEX.__member(4), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(4), WNDCLASSEX.__member(4), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CBSIZE = layout.offsetof(0);
        STYLE = layout.offsetof(1);
        LPFNWNDPROC = layout.offsetof(2);
        CBCLSEXTRA = layout.offsetof(3);
        CBWNDEXTRA = layout.offsetof(4);
        HINSTANCE = layout.offsetof(5);
        HICON = layout.offsetof(6);
        HCURSOR = layout.offsetof(7);
        HBRBACKGROUND = layout.offsetof(8);
        LPSZMENUNAME = layout.offsetof(9);
        LPSZCLASSNAME = layout.offsetof(10);
        HICONSM = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<WNDCLASSEX, Buffer>
    implements NativeResource {
        private static final WNDCLASSEX ELEMENT_FACTORY = WNDCLASSEX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected WNDCLASSEX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="UINT")
        public int cbSize() {
            return WNDCLASSEX.ncbSize(this.address());
        }

        @NativeType(value="UINT")
        public int style() {
            return WNDCLASSEX.nstyle(this.address());
        }

        @NativeType(value="WNDPROC")
        public WindowProc lpfnWndProc() {
            return WNDCLASSEX.nlpfnWndProc(this.address());
        }

        public int cbClsExtra() {
            return WNDCLASSEX.ncbClsExtra(this.address());
        }

        public int cbWndExtra() {
            return WNDCLASSEX.ncbWndExtra(this.address());
        }

        @NativeType(value="HINSTANCE")
        public long hInstance() {
            return WNDCLASSEX.nhInstance(this.address());
        }

        @NativeType(value="HICON")
        public long hIcon() {
            return WNDCLASSEX.nhIcon(this.address());
        }

        @NativeType(value="HCURSOR")
        public long hCursor() {
            return WNDCLASSEX.nhCursor(this.address());
        }

        @NativeType(value="HBRUSH")
        public long hbrBackground() {
            return WNDCLASSEX.nhbrBackground(this.address());
        }

        @Nullable
        @NativeType(value="LPCTSTR")
        public ByteBuffer lpszMenuName() {
            return WNDCLASSEX.nlpszMenuName(this.address());
        }

        @Nullable
        @NativeType(value="LPCTSTR")
        public String lpszMenuNameString() {
            return WNDCLASSEX.nlpszMenuNameString(this.address());
        }

        @NativeType(value="LPCTSTR")
        public ByteBuffer lpszClassName() {
            return WNDCLASSEX.nlpszClassName(this.address());
        }

        @NativeType(value="LPCTSTR")
        public String lpszClassNameString() {
            return WNDCLASSEX.nlpszClassNameString(this.address());
        }

        @NativeType(value="HICON")
        public long hIconSm() {
            return WNDCLASSEX.nhIconSm(this.address());
        }

        public Buffer cbSize(@NativeType(value="UINT") int value2) {
            WNDCLASSEX.ncbSize(this.address(), value2);
            return this;
        }

        public Buffer style(@NativeType(value="UINT") int value2) {
            WNDCLASSEX.nstyle(this.address(), value2);
            return this;
        }

        public Buffer lpfnWndProc(@NativeType(value="WNDPROC") WindowProcI value2) {
            WNDCLASSEX.nlpfnWndProc(this.address(), value2);
            return this;
        }

        public Buffer cbClsExtra(int value2) {
            WNDCLASSEX.ncbClsExtra(this.address(), value2);
            return this;
        }

        public Buffer cbWndExtra(int value2) {
            WNDCLASSEX.ncbWndExtra(this.address(), value2);
            return this;
        }

        public Buffer hInstance(@NativeType(value="HINSTANCE") long value2) {
            WNDCLASSEX.nhInstance(this.address(), value2);
            return this;
        }

        public Buffer hIcon(@NativeType(value="HICON") long value2) {
            WNDCLASSEX.nhIcon(this.address(), value2);
            return this;
        }

        public Buffer hCursor(@NativeType(value="HCURSOR") long value2) {
            WNDCLASSEX.nhCursor(this.address(), value2);
            return this;
        }

        public Buffer hbrBackground(@NativeType(value="HBRUSH") long value2) {
            WNDCLASSEX.nhbrBackground(this.address(), value2);
            return this;
        }

        public Buffer lpszMenuName(@Nullable @NativeType(value="LPCTSTR") ByteBuffer value2) {
            WNDCLASSEX.nlpszMenuName(this.address(), value2);
            return this;
        }

        public Buffer lpszClassName(@NativeType(value="LPCTSTR") ByteBuffer value2) {
            WNDCLASSEX.nlpszClassName(this.address(), value2);
            return this;
        }

        public Buffer hIconSm(@NativeType(value="HICON") long value2) {
            WNDCLASSEX.nhIconSm(this.address(), value2);
            return this;
        }
    }
}

