/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nfdfilteritem_t")
public class NFDFilterItem
extends Struct<NFDFilterItem>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SPEC;

    protected NFDFilterItem(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NFDFilterItem create(long address, @Nullable ByteBuffer container) {
        return new NFDFilterItem(address, container);
    }

    public NFDFilterItem(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NFDFilterItem.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nfdchar_t const *")
    public ByteBuffer name() {
        return NFDFilterItem.nname(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public String nameString() {
        return NFDFilterItem.nnameString(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public ByteBuffer spec() {
        return NFDFilterItem.nspec(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public String specString() {
        return NFDFilterItem.nspecString(this.address());
    }

    public NFDFilterItem name(@NativeType(value="nfdchar_t const *") ByteBuffer value2) {
        NFDFilterItem.nname(this.address(), value2);
        return this;
    }

    public NFDFilterItem spec(@NativeType(value="nfdchar_t const *") ByteBuffer value2) {
        NFDFilterItem.nspec(this.address(), value2);
        return this;
    }

    public NFDFilterItem set(ByteBuffer name, ByteBuffer spec) {
        this.name(name);
        this.spec(spec);
        return this;
    }

    public NFDFilterItem set(NFDFilterItem src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NFDFilterItem malloc() {
        return new NFDFilterItem(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NFDFilterItem calloc() {
        return new NFDFilterItem(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NFDFilterItem create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NFDFilterItem(MemoryUtil.memAddress(container), container);
    }

    public static NFDFilterItem create(long address) {
        return new NFDFilterItem(address, null);
    }

    @Nullable
    public static NFDFilterItem createSafe(long address) {
        return address == 0L ? null : new NFDFilterItem(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NFDFilterItem.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDFilterItem.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NFDFilterItem malloc(MemoryStack stack) {
        return new NFDFilterItem(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NFDFilterItem calloc(MemoryStack stack) {
        return new NFDFilterItem(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static ByteBuffer nspec(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)SPEC));
    }

    public static String nspecString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)SPEC));
    }

    public static void nname(long struct, ByteBuffer value2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value2);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value2));
    }

    public static void nspec(long struct, ByteBuffer value2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value2);
        }
        MemoryUtil.memPutAddress(struct + (long)SPEC, MemoryUtil.memAddress(value2));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPEC));
    }

    static {
        Struct.Layout layout = NFDFilterItem.__struct(NFDFilterItem.__member(POINTER_SIZE), NFDFilterItem.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SPEC = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NFDFilterItem, Buffer>
    implements NativeResource {
        private static final NFDFilterItem ELEMENT_FACTORY = NFDFilterItem.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NFDFilterItem getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nfdchar_t const *")
        public ByteBuffer name() {
            return NFDFilterItem.nname(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public String nameString() {
            return NFDFilterItem.nnameString(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public ByteBuffer spec() {
            return NFDFilterItem.nspec(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public String specString() {
            return NFDFilterItem.nspecString(this.address());
        }

        public Buffer name(@NativeType(value="nfdchar_t const *") ByteBuffer value2) {
            NFDFilterItem.nname(this.address(), value2);
            return this;
        }

        public Buffer spec(@NativeType(value="nfdchar_t const *") ByteBuffer value2) {
            NFDFilterItem.nspec(this.address(), value2);
            return this;
        }
    }
}

