/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.ApplicationWindow;
import org.openrndr.CursorType;
import org.openrndr.MouseCursorHideMode;
import org.openrndr.MouseEvent;
import org.openrndr.MouseEvents;
import org.openrndr.events.Event;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010$\u00a8\u00061"}, d2={"Lorg/openrndr/ApplicationWindowMouse;", "Lorg/openrndr/MouseEvents;", "applicationWindow", "Lkotlin/Function0;", "Lorg/openrndr/ApplicationWindow;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "value", "Lorg/openrndr/math/Vector2;", "position", "getPosition", "()Lorg/openrndr/math/Vector2;", "setPosition", "(Lorg/openrndr/math/Vector2;)V", "", "cursorVisible", "getCursorVisible", "()Z", "setCursorVisible", "(Z)V", "Lorg/openrndr/MouseCursorHideMode;", "cursorHideMode", "getCursorHideMode", "()Lorg/openrndr/MouseCursorHideMode;", "setCursorHideMode", "(Lorg/openrndr/MouseCursorHideMode;)V", "Lorg/openrndr/CursorType;", "cursorType", "getCursorType", "()Lorg/openrndr/CursorType;", "setCursorType", "(Lorg/openrndr/CursorType;)V", "buttonDown", "Lorg/openrndr/events/Event;", "Lorg/openrndr/MouseEvent;", "getButtonDown", "()Lorg/openrndr/events/Event;", "buttonUp", "getButtonUp", "dragged", "getDragged", "moved", "getMoved", "scrolled", "getScrolled", "entered", "getEntered", "exited", "getExited", "openrndr-application"})
public final class ApplicationWindowMouse
implements MouseEvents {
    @NotNull
    private final Function0<ApplicationWindow> applicationWindow;
    @NotNull
    private final Event<MouseEvent> buttonDown;
    @NotNull
    private final Event<MouseEvent> buttonUp;
    @NotNull
    private final Event<MouseEvent> dragged;
    @NotNull
    private final Event<MouseEvent> moved;
    @NotNull
    private final Event<MouseEvent> scrolled;
    @NotNull
    private final Event<MouseEvent> entered;
    @NotNull
    private final Event<MouseEvent> exited;

    public ApplicationWindowMouse(@NotNull Function0<? extends ApplicationWindow> applicationWindow) {
        Intrinsics.checkNotNullParameter(applicationWindow, "applicationWindow");
        this.applicationWindow = applicationWindow;
        this.buttonDown = new Event("mouse-button-down", true);
        this.buttonUp = new Event("mouse-button-up", true);
        this.dragged = new Event("mouse-dragged", true);
        this.moved = new Event("mouse-moved", true);
        this.scrolled = new Event("mouse-scrolled", true);
        this.entered = new Event("mouse-entered", true);
        this.exited = new Event("mouse-exited", true);
    }

    @Override
    @NotNull
    public Vector2 getPosition() {
        return this.applicationWindow.invoke().getCursorPosition();
    }

    public void setPosition(@NotNull Vector2 value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.applicationWindow.invoke().setCursorPosition(value2);
    }

    public final boolean getCursorVisible() {
        return this.applicationWindow.invoke().getCursorVisible();
    }

    public final void setCursorVisible(boolean value2) {
        this.applicationWindow.invoke().setCursorVisible(value2);
    }

    @NotNull
    public final MouseCursorHideMode getCursorHideMode() {
        return this.applicationWindow.invoke().getCursorHideMode();
    }

    public final void setCursorHideMode(@NotNull MouseCursorHideMode value2) {
        Intrinsics.checkNotNullParameter((Object)value2, "value");
        this.applicationWindow.invoke().setCursorHideMode(value2);
    }

    @NotNull
    public final CursorType getCursorType() {
        return this.applicationWindow.invoke().getCursorType();
    }

    public final void setCursorType(@NotNull CursorType value2) {
        Intrinsics.checkNotNullParameter((Object)value2, "value");
        this.applicationWindow.invoke().setCursorType(value2);
    }

    @Override
    @NotNull
    public Event<MouseEvent> getButtonDown() {
        return this.buttonDown;
    }

    @Override
    @NotNull
    public Event<MouseEvent> getButtonUp() {
        return this.buttonUp;
    }

    @Override
    @NotNull
    public Event<MouseEvent> getDragged() {
        return this.dragged;
    }

    @Override
    @NotNull
    public Event<MouseEvent> getMoved() {
        return this.moved;
    }

    @Override
    @NotNull
    public Event<MouseEvent> getScrolled() {
        return this.scrolled;
    }

    @Override
    @NotNull
    public Event<MouseEvent> getEntered() {
        return this.entered;
    }

    @Override
    @NotNull
    public Event<MouseEvent> getExited() {
        return this.exited;
    }
}

