/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.binpack;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.binpack.PackNode;
import org.openrndr.binpack.Splitter;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/openrndr/binpack/DefaultSplitter;", "Lorg/openrndr/binpack/Splitter;", "<init>", "()V", "split", "", "Lorg/openrndr/binpack/PackNode;", "node", "rectangle", "Lorg/openrndr/shape/IntRectangle;", "openrndr-binpack"})
public final class DefaultSplitter
implements Splitter {
    @Override
    @NotNull
    public List<PackNode> split(@NotNull PackNode node, @NotNull IntRectangle rectangle) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        int dw = node.getArea().width() - rectangle.width();
        int dh = node.getArea().height() - rectangle.height();
        int sanding = 0;
        IntRectangle lrect = null;
        IntRectangle rrect = null;
        if (dw > dh) {
            lrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y(), rectangle.width(), node.getArea().height());
            rrect = IntRectangleKt.IntRectangle(node.getArea().x() + rectangle.width() + sanding, node.getArea().y(), node.getArea().width() - rectangle.width() - sanding, node.getArea().height());
        } else {
            lrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y(), node.getArea().width(), rectangle.height());
            rrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y() + rectangle.height() + sanding, node.getArea().width(), node.getArea().height() - rectangle.height() - sanding);
        }
        PackNode[] packNodeArray = new PackNode[]{new PackNode(lrect, node), new PackNode(rrect, node)};
        return CollectionsKt.listOf(packNodeArray);
    }
}

