/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa$;
import org.openrndr.color.ColorHSLaKt;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSLa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.Linearity;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 J2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\u00020\u0006:\u0002JKB)\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rB;\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\f\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020$J\u0010\u0010(\u001a\u00020)2\b\b\u0002\u0010'\u001a\u00020$J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010'\u001a\u00020$J\u0010\u0010,\u001a\u00020-2\b\b\u0002\u0010'\u001a\u00020$J\u0006\u0010.\u001a\u00020/J\u0011\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000H\u0096\u0002J\u0011\u00102\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000H\u0096\u0002J\u0011\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\bH\u0096\u0002J\b\u00105\u001a\u000206H\u0016J\t\u00107\u001a\u00020\bH\u00c6\u0003J\t\u00108\u001a\u00020\bH\u00c6\u0003J\t\u00109\u001a\u00020\bH\u00c6\u0003J\t\u0010:\u001a\u00020\bH\u00c6\u0003J1\u0010;\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010<\u001a\u00020=2\b\u0010\u001c\u001a\u0004\u0018\u00010>H\u00d6\u0003J\t\u0010?\u001a\u00020\u000fH\u00d6\u0001J\t\u0010@\u001a\u00020AH\u00d6\u0001J%\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0001\u00a2\u0006\u0002\bIR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0013R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0019\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006L"}, d2={"Lorg/openrndr/color/ColorHSLa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/AlgebraicColor;", "Ljava/lang/Record;", "h", "", "s", "l", "alpha", "<init>", "(DDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "opacify", "factor", "withHue", "hue", "withSaturation", "saturation", "shade", "mix", "other", "unit", "()Lorg/openrndr/color/ColorHSLa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toXYZa", "Lorg/openrndr/color/ColorXYZa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "ref", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toLCHABa", "Lorg/openrndr/color/ColorLCHABa;", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toXSLa", "Lorg/openrndr/color/ColorXSLa;", "plus", "right", "minus", "times", "scale", "toVector4", "Lorg/openrndr/math/Vector4;", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
public final class ColorHSLa
extends Record
implements ColorModel<ColorHSLa>,
ShadableColor<ColorHSLa>,
HueShiftableColor<ColorHSLa>,
SaturatableColor<ColorHSLa>,
AlgebraicColor<ColorHSLa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double h;
    private final double s;
    private final double l;
    private final double alpha;

    public ColorHSLa(double h, double s, double l, double alpha) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = alpha;
    }

    public /* synthetic */ ColorHSLa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double h() {
        return this.h;
    }

    public final double s() {
        return this.s;
    }

    public final double l() {
        return this.l;
    }

    public double alpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorHSLa opacify(double factor) {
        return ColorHSLa.copy$default(this, 0.0, 0.0, 0.0, this.alpha() * factor, 7, null);
    }

    @Override
    @NotNull
    public ColorHSLa withHue(double hue) {
        return ColorHSLa.copy$default(this, hue, 0.0, 0.0, 0.0, 14, null);
    }

    public double hue() {
        return this.h;
    }

    @Override
    @NotNull
    public ColorHSLa withSaturation(double saturation) {
        return ColorHSLa.copy$default(this, 0.0, saturation, 0.0, 0.0, 13, null);
    }

    public double saturation() {
        return this.s;
    }

    @Override
    @NotNull
    public ColorHSLa shade(double factor) {
        return ColorHSLa.copy$default(this, 0.0, 0.0, this.l * factor, 0.0, 11, null);
    }

    @Override
    @NotNull
    public ColorHSLa mix(@NotNull ColorHSLa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorHSLaKt.mix(this, other, factor);
    }

    @NotNull
    public final ColorHSLa unit() {
        return ColorHSLa.copy$default(this, (this.h % (double)360 + (double)360) % (double)360, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        ColorRGBa colorRGBa;
        if (this.s == 0.0) {
            colorRGBa = new ColorRGBa(this.l, this.l, this.l, this.alpha(), Linearity.SRGB);
        } else {
            double q = this.l < 0.5 ? this.l * (1.0 + this.s) : this.l + this.s - this.l * this.s;
            double p = (double)2 * this.l - q;
            double r = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0 + 0.3333333333333333);
            double g = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0);
            double b = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0 - 0.3333333333333333);
            colorRGBa = new ColorRGBa(r, g, b, this.alpha(), Linearity.SRGB);
        }
        return colorRGBa;
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return this.toRGBa().toHSVa();
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return this.toRGBa().toXYZa();
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toRGBa().toXYZa().toLABa(ref);
    }

    public static /* synthetic */ ColorLABa toLABa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLABa(colorXYZa);
    }

    @NotNull
    public final ColorLUVa toLUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toRGBa().toXYZa().toLUVa(ref);
    }

    public static /* synthetic */ ColorLUVa toLUVa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLUVa(colorXYZa);
    }

    @NotNull
    public final ColorLCHABa toLCHABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toLABa(ref).toLCHABa();
    }

    public static /* synthetic */ ColorLCHABa toLCHABa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLCHABa(colorXYZa);
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toLUVa(ref).toLCHUVa();
    }

    public static /* synthetic */ ColorLCHUVa toLCHUVa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLCHUVa(colorXYZa);
    }

    @NotNull
    public final ColorXSLa toXSLa() {
        return ColorXSLa.Companion.fromHSLa(this);
    }

    @Override
    @NotNull
    public ColorHSLa plus(@NotNull ColorHSLa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h + right.h, this.s + right.s, this.l + right.l, this.alpha() + right.alpha());
    }

    @Override
    @NotNull
    public ColorHSLa minus(@NotNull ColorHSLa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h - right.h, this.s - right.s, this.l - right.l, this.alpha() - right.alpha());
    }

    @Override
    @NotNull
    public ColorHSLa times(double scale) {
        return this.copy(this.h * scale, this.s * scale, this.l * scale, this.alpha() * scale);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.h, this.s, this.l, this.alpha());
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.l;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorHSLa copy(double h, double s, double l, double alpha) {
        return new ColorHSLa(h, s, l, alpha);
    }

    public static /* synthetic */ ColorHSLa copy$default(ColorHSLa colorHSLa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSLa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSLa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSLa.l;
        }
        if ((n & 8) != 0) {
            d4 = colorHSLa.alpha;
        }
        return colorHSLa.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "ColorHSLa(h=" + this.h + ", s=" + this.s + ", l=" + this.l + ", alpha=" + this.alpha + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.h);
        result2 = result2 * 31 + Double.hashCode(this.s);
        result2 = result2 * 31 + Double.hashCode(this.l);
        result2 = result2 * 31 + Double.hashCode(this.alpha);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorHSLa)) {
            return false;
        }
        ColorHSLa colorHSLa = (ColorHSLa)other;
        if (Double.compare(this.h, colorHSLa.h) != 0) {
            return false;
        }
        if (Double.compare(this.s, colorHSLa.s) != 0) {
            return false;
        }
        if (Double.compare(this.l, colorHSLa.l) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorHSLa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorHSLa shiftHue(double shiftInDegrees) {
        return HueShiftableColor.DefaultImpls.shiftHue(this, shiftInDegrees);
    }

    @Override
    @NotNull
    public ColorHSLa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorHSLa saturate(double factor) {
        return SaturatableColor.DefaultImpls.saturate(this, factor);
    }

    @Override
    @NotNull
    public ColorHSLa mixSaturation(double saturation, double factor) {
        return SaturatableColor.DefaultImpls.mixSaturation(this, saturation, factor);
    }

    @Override
    @NotNull
    public ColorHSLa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorHSLa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.h);
        output.encodeDoubleElement(serialDesc, 1, self.s);
        output.encodeDoubleElement(serialDesc, 2, self.l);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.alpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.alpha());
        }
    }

    public /* synthetic */ ColorHSLa(int seen0, double h, double s, double l, double alpha, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/color/ColorHSLa$Companion;", "", "<init>", "()V", "fromRGBa", "Lorg/openrndr/color/ColorHSLa;", "rgb", "Lorg/openrndr/color/ColorRGBa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorHSLa fromRGBa(@NotNull ColorRGBa rgb) {
            Intrinsics.checkNotNullParameter(rgb, "rgb");
            ColorRGBa srgb = rgb.toSRGB();
            double min = srgb.getMinValue();
            double max = 0.0;
            ColorRGBa.Component maxArg = null;
            if (srgb.getR() >= srgb.getB() && srgb.getR() >= srgb.getG()) {
                maxArg = ColorRGBa.Component.R;
                max = srgb.getR();
            } else if (srgb.getG() >= srgb.getB() && srgb.getG() >= srgb.getR()) {
                maxArg = ColorRGBa.Component.G;
                max = srgb.getG();
            } else {
                maxArg = ColorRGBa.Component.B;
                max = srgb.getB();
            }
            if (min == max) {
                return new ColorHSLa(0.0, 0.0, max, srgb.getAlpha());
            }
            double delta = max - min;
            double l = (max + min) / 2.0;
            double s = l > 0.5 ? delta / (2.0 - max - min) : delta / (max + min);
            double h = 60.0 * (switch (WhenMappings.$EnumSwitchMapping$0[maxArg.ordinal()]) {
                case 1 -> (srgb.getG() - srgb.getB()) / delta + (double)(srgb.getG() < srgb.getB() ? 6 : 0);
                case 2 -> (srgb.getB() - srgb.getR()) / delta + 2.0;
                case 3 -> (srgb.getR() - srgb.getG()) / delta + 4.0;
                default -> throw new NoWhenBranchMatchedException();
            });
            return new ColorHSLa(h, s, l, srgb.getAlpha());
        }

        @NotNull
        public final KSerializer<ColorHSLa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorRGBa.Component.values().length];
                try {
                    nArray[ColorRGBa.Component.R.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorRGBa.Component.G.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorRGBa.Component.B.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

