/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSVa$;
import org.openrndr.color.ColorHSVaKt;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSVa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.Linearity;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\u00020\u0006:\u0002=>B)\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rB;\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\f\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bH\u0096\u0002J\b\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J1\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u0010\u001c\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u00020\u000fH\u00d6\u0001J\t\u00103\u001a\u000204H\u00d6\u0001J%\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0001\u00a2\u0006\u0002\b<R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0013R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0019\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006?"}, d2={"Lorg/openrndr/color/ColorHSVa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/AlgebraicColor;", "Ljava/lang/Record;", "h", "", "s", "v", "alpha", "<init>", "(DDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "opacify", "factor", "withHue", "hue", "withSaturation", "saturation", "shade", "mix", "other", "unit", "()Lorg/openrndr/color/ColorHSVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "plus", "right", "minus", "times", "scale", "toVector4", "Lorg/openrndr/math/Vector4;", "toXSVa", "Lorg/openrndr/color/ColorXSVa;", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
public final class ColorHSVa
extends Record
implements ColorModel<ColorHSVa>,
ShadableColor<ColorHSVa>,
HueShiftableColor<ColorHSVa>,
SaturatableColor<ColorHSVa>,
AlgebraicColor<ColorHSVa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double h;
    private final double s;
    private final double v;
    private final double alpha;

    public ColorHSVa(double h, double s, double v, double alpha) {
        this.h = h;
        this.s = s;
        this.v = v;
        this.alpha = alpha;
    }

    public /* synthetic */ ColorHSVa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double h() {
        return this.h;
    }

    public final double s() {
        return this.s;
    }

    public final double v() {
        return this.v;
    }

    public double alpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorHSVa opacify(double factor) {
        return ColorHSVa.copy$default(this, 0.0, 0.0, 0.0, this.alpha() * factor, 7, null);
    }

    @Override
    @NotNull
    public ColorHSVa withHue(double hue) {
        return ColorHSVa.copy$default(this, hue, 0.0, 0.0, 0.0, 14, null);
    }

    public double hue() {
        return this.h;
    }

    @Override
    @NotNull
    public ColorHSVa withSaturation(double saturation) {
        return ColorHSVa.copy$default(this, 0.0, saturation, 0.0, 0.0, 13, null);
    }

    public double saturation() {
        return this.s;
    }

    @Override
    @NotNull
    public ColorHSVa shade(double factor) {
        return ColorHSVa.copy$default(this, 0.0, 0.0, this.v * factor, 0.0, 11, null);
    }

    @Override
    @NotNull
    public ColorHSVa mix(@NotNull ColorHSVa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorHSVaKt.mix(this, other, factor);
    }

    @NotNull
    public final ColorHSVa unit() {
        return ColorHSVa.copy$default(this, (this.h % (double)360 + (double)360) % (double)360, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        int i = 0;
        double f = 0.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        ColorHSVa hsv = this;
        double sh = FunctionsKt.mod(hsv.h, 360.0) / (double)60;
        i = (int)Math.floor(sh);
        f = sh - (double)i;
        double p = hsv.v * (1.0 - hsv.s);
        double q = hsv.v * (1.0 - hsv.s * f);
        double t = hsv.v * (1.0 - hsv.s * (1.0 - f));
        if (this.s > 1.0E-5) {
            switch (i) {
                case 0: {
                    r = hsv.v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = hsv.v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = hsv.v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = hsv.v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = hsv.v;
                    break;
                }
                default: {
                    r = hsv.v;
                    g = p;
                    b = q;
                    break;
                }
            }
        } else {
            r = hsv.v;
            g = hsv.v;
            b = hsv.v;
        }
        return new ColorRGBa(r, g, b, hsv.alpha(), Linearity.SRGB);
    }

    @Override
    @NotNull
    public ColorHSVa plus(@NotNull ColorHSVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h + right.h, this.s + right.s, this.v + right.v, this.alpha() + right.alpha());
    }

    @Override
    @NotNull
    public ColorHSVa minus(@NotNull ColorHSVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h - right.h, this.s - right.s, this.v - right.v, this.alpha() - right.alpha());
    }

    @Override
    @NotNull
    public ColorHSVa times(double scale) {
        return this.copy(this.h * scale, this.s * scale, this.v * scale, this.alpha() * scale);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.h, this.s, this.v, this.alpha());
    }

    @NotNull
    public final ColorXSVa toXSVa() {
        return ColorXSVa.Companion.fromHSVa(this);
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.v;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorHSVa copy(double h, double s, double v, double alpha) {
        return new ColorHSVa(h, s, v, alpha);
    }

    public static /* synthetic */ ColorHSVa copy$default(ColorHSVa colorHSVa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSVa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSVa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSVa.v;
        }
        if ((n & 8) != 0) {
            d4 = colorHSVa.alpha;
        }
        return colorHSVa.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "ColorHSVa(h=" + this.h + ", s=" + this.s + ", v=" + this.v + ", alpha=" + this.alpha + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.h);
        result2 = result2 * 31 + Double.hashCode(this.s);
        result2 = result2 * 31 + Double.hashCode(this.v);
        result2 = result2 * 31 + Double.hashCode(this.alpha);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorHSVa)) {
            return false;
        }
        ColorHSVa colorHSVa = (ColorHSVa)other;
        if (Double.compare(this.h, colorHSVa.h) != 0) {
            return false;
        }
        if (Double.compare(this.s, colorHSVa.s) != 0) {
            return false;
        }
        if (Double.compare(this.v, colorHSVa.v) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorHSVa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorHSVa shiftHue(double shiftInDegrees) {
        return HueShiftableColor.DefaultImpls.shiftHue(this, shiftInDegrees);
    }

    @Override
    @NotNull
    public ColorHSVa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorHSVa saturate(double factor) {
        return SaturatableColor.DefaultImpls.saturate(this, factor);
    }

    @Override
    @NotNull
    public ColorHSVa mixSaturation(double saturation, double factor) {
        return SaturatableColor.DefaultImpls.mixSaturation(this, saturation, factor);
    }

    @Override
    @NotNull
    public ColorHSVa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorHSVa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.h);
        output.encodeDoubleElement(serialDesc, 1, self.s);
        output.encodeDoubleElement(serialDesc, 2, self.v);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.alpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.alpha());
        }
    }

    public /* synthetic */ ColorHSVa(int seen0, double h, double s, double v, double alpha, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.h = h;
        this.s = s;
        this.v = v;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/color/ColorHSVa$Companion;", "", "<init>", "()V", "fromRGBa", "Lorg/openrndr/color/ColorHSVa;", "rgb", "Lorg/openrndr/color/ColorRGBa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorHSVa fromRGBa(@NotNull ColorRGBa rgb) {
            Intrinsics.checkNotNullParameter(rgb, "rgb");
            ColorRGBa srgb = rgb.toSRGB();
            double min = srgb.getMinValue();
            double max = 0.0;
            ColorRGBa.Component maxArg = null;
            if (srgb.getR() >= srgb.getB() && srgb.getR() >= srgb.getG()) {
                maxArg = ColorRGBa.Component.R;
                max = srgb.getR();
            } else if (srgb.getG() >= srgb.getB() && srgb.getG() >= srgb.getR()) {
                maxArg = ColorRGBa.Component.G;
                max = srgb.getG();
            } else {
                maxArg = ColorRGBa.Component.B;
                max = srgb.getB();
            }
            double v = max;
            if (min == max) {
                return new ColorHSVa(0.0, 0.0, v, srgb.getAlpha());
            }
            double delta = max - min;
            double s = delta / max;
            double d = 60;
            double h = d * (switch (WhenMappings.$EnumSwitchMapping$0[maxArg.ordinal()]) {
                case 1 -> (srgb.getG() - srgb.getB()) / delta;
                case 2 -> (srgb.getB() - srgb.getR()) / delta + 2.0;
                case 3 -> (srgb.getR() - srgb.getG()) / delta + 4.0;
                default -> throw new NoWhenBranchMatchedException();
            });
            if (h < 0.0) {
                h += 360.0;
            }
            return new ColorHSVa(h, s, v, srgb.getAlpha());
        }

        @NotNull
        public final KSerializer<ColorHSVa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorRGBa.Component.values().length];
                try {
                    nArray[ColorRGBa.Component.R.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorRGBa.Component.G.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorRGBa.Component.B.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

