/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLSHUVa$;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ColorXYZa$;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.LuminosityColor;
import org.openrndr.color.ReferenceWhitePoint;
import org.openrndr.color.SaturatableColor;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 H2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\b\u0012\u0004\u0012\u00020\u00000\u0006:\u0002HIB3\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fBE\b\u0010\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u000e\u0010\u0014J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\bH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\bH\u0016J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\bH\u0096\u0002J\u0018\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\bH\u0016J\t\u00104\u001a\u00020\bH\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J\t\u00106\u001a\u00020\bH\u00c6\u0003J\t\u00107\u001a\u00020\bH\u00c6\u0003J\t\u00108\u001a\u00020\rH\u00c6\u0003J;\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010:\u001a\u00020;2\b\u00100\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020\u0011H\u00d6\u0001J\t\u0010>\u001a\u00020?H\u00d6\u0001J%\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0001\u00a2\u0006\u0002\bGR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010%\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0016R\u0014\u0010(\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R\u0014\u00102\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0016\u00a8\u0006J"}, d2={"Lorg/openrndr/color/ColorLSHUVa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ReferenceWhitePoint;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/LuminosityColor;", "Lorg/openrndr/color/AlgebraicColor;", "l", "", "s", "h", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "<init>", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLorg/openrndr/color/ColorXYZa;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getL", "()D", "getS", "getH", "getAlpha", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "opacify", "factor", "toVector4", "Lorg/openrndr/math/Vector4;", "withHue", "hue", "getHue", "withSaturation", "saturation", "getSaturation", "plus", "right", "minus", "times", "scale", "mix", "other", "withLuminosity", "luminosity", "getLuminosity", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
public final class ColorLSHUVa
implements ColorModel<ColorLSHUVa>,
ReferenceWhitePoint,
HueShiftableColor<ColorLSHUVa>,
SaturatableColor<ColorLSHUVa>,
LuminosityColor<ColorLSHUVa>,
AlgebraicColor<ColorLSHUVa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double l;
    private final double s;
    private final double h;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;

    public ColorLSHUVa(double l, double s, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.l = l;
        this.s = s;
        this.h = h;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLSHUVa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    public final double getL() {
        return this.l;
    }

    public final double getS() {
        return this.s;
    }

    public final double getH() {
        return this.h;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorXYZa getRef() {
        return this.ref;
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa() {
        double maxC = ColorLCHUVa.Companion.findMaxChroma(this.l, this.h, this.getRef());
        return new ColorLCHUVa(this.l, this.s * maxC, this.h, this.getAlpha(), this.getRef());
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toLCHUVa().toRGBa();
    }

    @Override
    @NotNull
    public ColorLSHUVa opacify(double factor) {
        return ColorLSHUVa.copy$default(this, 0.0, 0.0, 0.0, this.getAlpha() * factor, null, 23, null);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.l, this.s, this.h, this.getAlpha());
    }

    @Override
    @NotNull
    public ColorLSHUVa withHue(double hue) {
        return ColorLSHUVa.copy$default(this, 0.0, 0.0, hue, 0.0, null, 27, null);
    }

    @Override
    public double getHue() {
        return this.h;
    }

    @Override
    @NotNull
    public ColorLSHUVa withSaturation(double saturation) {
        return ColorLSHUVa.copy$default(this, 0.0, saturation, 0.0, 0.0, null, 29, null);
    }

    @Override
    public double getSaturation() {
        return this.s;
    }

    @Override
    @NotNull
    public ColorLSHUVa plus(@NotNull ColorLSHUVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLSHUVa.copy$default(this, this.l + right.l, this.s + right.s, this.h + right.h, this.getAlpha() + right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLSHUVa minus(@NotNull ColorLSHUVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLSHUVa.copy$default(this, this.l - right.l, this.s - right.s, this.h - right.h, this.getAlpha() - right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLSHUVa times(double scale) {
        return ColorLSHUVa.copy$default(this, this.l * scale, this.s * scale, this.h * scale, this.getAlpha() * scale, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLSHUVa mix(@NotNull ColorLSHUVa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        double sx = RangesKt.coerceIn(factor, 0.0, 1.0);
        return new ColorLSHUVa((1.0 - sx) * this.l + sx * other.l, (1.0 - sx) * this.s + sx * other.s, MappingKt.mixAngle(this.h, other.h, sx), (1.0 - sx) * this.getAlpha() + sx * other.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLSHUVa withLuminosity(double luminosity) {
        return ColorLSHUVa.copy$default(this, luminosity, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    public double getLuminosity() {
        return this.l;
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.h;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLSHUVa copy(double l, double s, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return new ColorLSHUVa(l, s, h, alpha, ref);
    }

    public static /* synthetic */ ColorLSHUVa copy$default(ColorLSHUVa colorLSHUVa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLSHUVa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLSHUVa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorLSHUVa.h;
        }
        if ((n & 8) != 0) {
            d4 = colorLSHUVa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLSHUVa.ref;
        }
        return colorLSHUVa.copy(d, d2, d3, d4, colorXYZa);
    }

    @NotNull
    public String toString() {
        return "ColorLSHUVa(l=" + this.l + ", s=" + this.s + ", h=" + this.h + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.l);
        result2 = result2 * 31 + Double.hashCode(this.s);
        result2 = result2 * 31 + Double.hashCode(this.h);
        result2 = result2 * 31 + Double.hashCode(this.alpha);
        result2 = result2 * 31 + this.ref.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorLSHUVa)) {
            return false;
        }
        ColorLSHUVa colorLSHUVa = (ColorLSHUVa)other;
        if (Double.compare(this.l, colorLSHUVa.l) != 0) {
            return false;
        }
        if (Double.compare(this.s, colorLSHUVa.s) != 0) {
            return false;
        }
        if (Double.compare(this.h, colorLSHUVa.h) != 0) {
            return false;
        }
        if (Double.compare(this.alpha, colorLSHUVa.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.ref, colorLSHUVa.ref);
    }

    @Override
    @NotNull
    public ColorLSHUVa shiftHue(double shiftInDegrees) {
        return HueShiftableColor.DefaultImpls.shiftHue(this, shiftInDegrees);
    }

    @Override
    @NotNull
    public ColorLSHUVa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorLSHUVa saturate(double factor) {
        return SaturatableColor.DefaultImpls.saturate(this, factor);
    }

    @Override
    @NotNull
    public ColorLSHUVa mixSaturation(double saturation, double factor) {
        return SaturatableColor.DefaultImpls.mixSaturation(this, saturation, factor);
    }

    @Override
    @NotNull
    public ColorLSHUVa shadeLuminosity(double factor) {
        return LuminosityColor.DefaultImpls.shadeLuminosity(this, factor);
    }

    @Override
    @NotNull
    public ColorLSHUVa mixLuminosity(double luminosity, double factor) {
        return LuminosityColor.DefaultImpls.mixLuminosity(this, luminosity, factor);
    }

    @Override
    @NotNull
    public ColorLSHUVa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorLSHUVa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.l);
        output.encodeDoubleElement(serialDesc, 1, self.s);
        output.encodeDoubleElement(serialDesc, 2, self.h);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.getAlpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.getAlpha());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual(self.getRef(), ColorXYZa.Companion.getNEUTRAL())) {
            output.encodeSerializableElement(serialDesc, 4, ColorXYZa$.serializer.INSTANCE, self.getRef());
        }
    }

    public /* synthetic */ ColorLSHUVa(int seen0, double l, double s, double h, double alpha, ColorXYZa ref, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.l = l;
        this.s = s;
        this.h = h;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
        this.ref = (seen0 & 0x10) == 0 ? ColorXYZa.Companion.getNEUTRAL() : ref;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/color/ColorLSHUVa$Companion;", "", "<init>", "()V", "fromLCHUVa", "Lorg/openrndr/color/ColorLSHUVa;", "lcha", "Lorg/openrndr/color/ColorLCHUVa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorLSHUVa fromLCHUVa(@NotNull ColorLCHUVa lcha) {
            Intrinsics.checkNotNullParameter(lcha, "lcha");
            double maxC = ColorLCHUVa.Companion.findMaxChroma(lcha.getL(), lcha.getH(), lcha.getRef());
            return new ColorLSHUVa(lcha.getL(), lcha.getC() / maxC, lcha.getH(), lcha.getAlpha(), lcha.getRef());
        }

        @NotNull
        public final KSerializer<ColorLSHUVa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

