/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa$;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ColorXYZa$;
import org.openrndr.color.LuminosityColor;
import org.openrndr.color.ReferenceWhitePoint;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 H2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u0005:\u0002HIB1\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eBE\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\r\u0010\u0013J\u0006\u0010\u001b\u001a\u00020\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010 \u001a\u00020!2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0007H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0007H\u0016J\t\u00103\u001a\u00020\u0007H\u00c6\u0003J\t\u00104\u001a\u00020\u0007H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\t\u00106\u001a\u00020\u0007H\u00c6\u0003J\t\u00107\u001a\u00020\fH\u00c6\u0003J;\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020\u0010H\u00d6\u0001J\t\u0010>\u001a\u00020?H\u00d6\u0001J%\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0001\u00a2\u0006\u0002\bGR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u00101\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0015\u00a8\u0006J"}, d2={"Lorg/openrndr/color/ColorLUVa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ReferenceWhitePoint;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/LuminosityColor;", "Lorg/openrndr/color/AlgebraicColor;", "l", "", "u", "v", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "<init>", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLorg/openrndr/color/ColorXYZa;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getL", "()D", "getU", "getV", "getAlpha", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "toXYZa", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "opacify", "factor", "shade", "plus", "right", "minus", "times", "scale", "toVector4", "Lorg/openrndr/math/Vector4;", "withLuminosity", "luminosity", "getLuminosity", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
public final class ColorLUVa
implements ColorModel<ColorLUVa>,
ReferenceWhitePoint,
ShadableColor<ColorLUVa>,
LuminosityColor<ColorLUVa>,
AlgebraicColor<ColorLUVa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double l;
    private final double u;
    private final double v;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;

    public ColorLUVa(double l, double u, double v, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.l = l;
        this.u = u;
        this.v = v;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLUVa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    public final double getL() {
        return this.l;
    }

    public final double getU() {
        return this.u;
    }

    public final double getV() {
        return this.v;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorXYZa getRef() {
        return this.ref;
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        double divr = this.getRef().getX() + this.getRef().getY() * (double)15 + this.getRef().getZ() * 3.0;
        double ur = divr == 0.0 ? 0.0 : this.getRef().getX() * 4.0 / divr;
        double vr = divr == 0.0 ? 0.0 : this.getRef().getY() * 9.0 / divr;
        double divp = (double)13 * this.l;
        double up = divp == 0.0 ? 0.0 : this.u / divp + ur;
        double vp = divp == 0.0 ? 0.0 : this.v / divp + vr;
        double y = this.l <= 8.0 ? this.getRef().getY() * this.l * Math.pow(0.10344827586206896, 3.0) : this.getRef().getY() * Math.pow((this.l + (double)16) / 116.0, 3.0);
        double x = vp == 0.0 ? 0.0 : y * ((double)9 * up / ((double)4 * vp));
        double z = vp == 0.0 ? 0.0 : y * (((double)12 - (double)3 * up - (double)20 * vp) / ((double)4 * vp));
        return new ColorXYZa(x, y, z, this.getAlpha());
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toXYZa().toRGBa();
    }

    @NotNull
    public final ColorRGBa toRGBa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toXYZa().toRGBa();
    }

    public static /* synthetic */ ColorRGBa toRGBa$default(ColorLUVa colorLUVa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = colorLUVa.getRef();
        }
        return colorLUVa.toRGBa(colorXYZa);
    }

    @NotNull
    public final ColorHSVa toHSVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toXYZa().toRGBa().toHSVa();
    }

    public static /* synthetic */ ColorHSVa toHSVa$default(ColorLUVa colorLUVa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = colorLUVa.getRef();
        }
        return colorLUVa.toHSVa(colorXYZa);
    }

    @NotNull
    public final ColorHSLa toHSLa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toXYZa().toRGBa().toHSLa();
    }

    public static /* synthetic */ ColorHSLa toHSLa$default(ColorLUVa colorLUVa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = colorLUVa.getRef();
        }
        return colorLUVa.toHSLa(colorXYZa);
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toXYZa().toLABa(ref);
    }

    public static /* synthetic */ ColorLABa toLABa$default(ColorLUVa colorLUVa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = colorLUVa.getRef();
        }
        return colorLUVa.toLABa(colorXYZa);
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa() {
        return ColorLCHUVa.Companion.fromLUVa(this);
    }

    @Override
    @NotNull
    public ColorLUVa opacify(double factor) {
        return ColorLUVa.copy$default(this, 0.0, 0.0, 0.0, this.getAlpha() * factor, null, 23, null);
    }

    @Override
    @NotNull
    public ColorLUVa shade(double factor) {
        return ColorLUVa.copy$default(this, this.l * factor, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    @NotNull
    public ColorLUVa plus(@NotNull ColorLUVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLUVa.copy$default(this, this.l + right.l, this.u + right.u, this.v + right.v, this.getAlpha() + right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLUVa minus(@NotNull ColorLUVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLUVa.copy$default(this, this.l - right.l, this.u - right.u, this.v - right.v, this.getAlpha() - right.getAlpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLUVa times(double scale) {
        return ColorLUVa.copy$default(this, this.l * scale, this.u * scale, this.v * scale, this.getAlpha() * scale, null, 16, null);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.l, this.u, this.v, this.getAlpha());
    }

    @Override
    @NotNull
    public ColorLUVa withLuminosity(double luminosity) {
        return ColorLUVa.copy$default(this, luminosity, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    public double getLuminosity() {
        return this.l;
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.u;
    }

    public final double component3() {
        return this.v;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLUVa copy(double l, double u, double v, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return new ColorLUVa(l, u, v, alpha, ref);
    }

    public static /* synthetic */ ColorLUVa copy$default(ColorLUVa colorLUVa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLUVa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLUVa.u;
        }
        if ((n & 4) != 0) {
            d3 = colorLUVa.v;
        }
        if ((n & 8) != 0) {
            d4 = colorLUVa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLUVa.ref;
        }
        return colorLUVa.copy(d, d2, d3, d4, colorXYZa);
    }

    @NotNull
    public String toString() {
        return "ColorLUVa(l=" + this.l + ", u=" + this.u + ", v=" + this.v + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.l);
        result2 = result2 * 31 + Double.hashCode(this.u);
        result2 = result2 * 31 + Double.hashCode(this.v);
        result2 = result2 * 31 + Double.hashCode(this.alpha);
        result2 = result2 * 31 + this.ref.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorLUVa)) {
            return false;
        }
        ColorLUVa colorLUVa = (ColorLUVa)other;
        if (Double.compare(this.l, colorLUVa.l) != 0) {
            return false;
        }
        if (Double.compare(this.u, colorLUVa.u) != 0) {
            return false;
        }
        if (Double.compare(this.v, colorLUVa.v) != 0) {
            return false;
        }
        if (Double.compare(this.alpha, colorLUVa.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.ref, colorLUVa.ref);
    }

    @Override
    @NotNull
    public ColorLUVa shadeLuminosity(double factor) {
        return LuminosityColor.DefaultImpls.shadeLuminosity(this, factor);
    }

    @Override
    @NotNull
    public ColorLUVa mixLuminosity(double luminosity, double factor) {
        return LuminosityColor.DefaultImpls.mixLuminosity(this, luminosity, factor);
    }

    @Override
    @NotNull
    public ColorLUVa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @Override
    @NotNull
    public ColorLUVa mix(@NotNull ColorLUVa other, double factor) {
        return (ColorLUVa)AlgebraicColor.DefaultImpls.mix(this, (AlgebraicColor)other, factor);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorLUVa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.l);
        output.encodeDoubleElement(serialDesc, 1, self.u);
        output.encodeDoubleElement(serialDesc, 2, self.v);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.getAlpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.getAlpha());
        }
        output.encodeSerializableElement(serialDesc, 4, ColorXYZa$.serializer.INSTANCE, self.getRef());
    }

    public /* synthetic */ ColorLUVa(int seen0, double l, double u, double v, double alpha, ColorXYZa ref, SerializationConstructorMarker serializationConstructorMarker) {
        if (23 != (0x17 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 23, $serializer.INSTANCE.getDescriptor());
        }
        this.l = l;
        this.u = u;
        this.v = v;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
        this.ref = ref;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/color/ColorLUVa$Companion;", "", "<init>", "()V", "fromXYZa", "Lorg/openrndr/color/ColorLUVa;", "xyz", "Lorg/openrndr/color/ColorXYZa;", "ref", "fromRGBa", "rgba", "Lorg/openrndr/color/ColorRGBa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorLUVa fromXYZa(@NotNull ColorXYZa xyz, @NotNull ColorXYZa ref) {
            Intrinsics.checkNotNullParameter(xyz, "xyz");
            Intrinsics.checkNotNullParameter(ref, "ref");
            double y = !(ref.getY() == 0.0) ? xyz.getY() / ref.getY() : 0.0;
            double l = y <= Math.pow(0.20689655172413793, 3.0) ? Math.pow(9.666666666666666, 3.0) * y : 116.0 * Math.pow(y, 0.3333333333333333) - 16.0;
            double div0 = xyz.getX() + xyz.getY() * 15.0 + xyz.getZ() * 3.0;
            double up = div0 == 0.0 ? 0.0 : xyz.getX() * 4.0 / div0;
            double vp = div0 == 0.0 ? 0.0 : xyz.getY() * 9.0 / div0;
            double div1 = ref.getX() + ref.getY() * (double)15 + ref.getZ() * 3.0;
            double ur = div1 == 0.0 ? 0.0 : ref.getX() * 4.0 / div1;
            double vr = div1 == 0.0 ? 0.0 : ref.getY() * 9.0 / div1;
            double u = 13.0 * l * (up - ur);
            double v = 13.0 * l * (vp - vr);
            return new ColorLUVa(l, u, v, xyz.getAlpha(), ref);
        }

        @NotNull
        public final ColorLUVa fromRGBa(@NotNull ColorRGBa rgba, @NotNull ColorXYZa ref) {
            Intrinsics.checkNotNullParameter(rgba, "rgba");
            Intrinsics.checkNotNullParameter(ref, "ref");
            return this.fromXYZa(ColorXYZa.Companion.fromRGBa(rgba), ref);
        }

        public static /* synthetic */ ColorLUVa fromRGBa$default(Companion companion, ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
            if ((n & 2) != 0) {
                colorXYZa = ColorXYZa.Companion.getNEUTRAL();
            }
            return companion.fromRGBa(colorRGBa, colorXYZa);
        }

        @NotNull
        public final KSerializer<ColorLUVa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

