/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSVa$;
import org.openrndr.color.ColorXSVaKt;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u0005:\u0002FGB)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fBC\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u000b\u0010\u0012J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0007H\u0096\u0002J\u0018\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007H\u0016J\b\u00101\u001a\u000202H\u0016J\t\u00103\u001a\u00020\u0007H\u00c6\u0003J\t\u00104\u001a\u00020\u0007H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\t\u00106\u001a\u00020\u0007H\u00c6\u0003J1\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u00108\u001a\u0002092\b\u00100\u001a\u0004\u0018\u00010:H\u00d6\u0003J\t\u0010;\u001a\u00020\u000eH\u00d6\u0001J\t\u0010<\u001a\u00020=H\u00d6\u0001J%\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0001\u00a2\u0006\u0002\bER\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001c\u0010\u000f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u0014R\u0014\u0010\"\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0014R\u0014\u0010%\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0014\u00a8\u0006H"}, d2={"Lorg/openrndr/color/ColorXSVa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/AlgebraicColor;", "x", "", "s", "v", "alpha", "<init>", "(DDDD)V", "seen0", "", "a", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getX", "()D", "getS", "getV", "getAlpha", "getA$annotations", "()V", "getA", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "shiftHue", "shiftInDegrees", "withHue", "hue", "getHue", "withSaturation", "saturation", "getSaturation", "shade", "factor", "opacify", "plus", "right", "minus", "times", "scale", "mix", "other", "toVector4", "Lorg/openrndr/math/Vector4;", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
public final class ColorXSVa
implements ColorModel<ColorXSVa>,
ShadableColor<ColorXSVa>,
HueShiftableColor<ColorXSVa>,
SaturatableColor<ColorXSVa>,
AlgebraicColor<ColorXSVa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double s;
    private final double v;
    private final double alpha;
    private final double a;

    public ColorXSVa(double x, double s, double v, double alpha) {
        this.x = x;
        this.s = s;
        this.v = v;
        this.alpha = alpha;
        this.a = this.getAlpha();
    }

    public /* synthetic */ ColorXSVa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double getX() {
        return this.x;
    }

    public final double getS() {
        return this.s;
    }

    public final double getV() {
        return this.v;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public final double getA() {
        return this.a;
    }

    @Deprecated(message="Legacy alpha parameter name", replaceWith=@ReplaceWith(expression="alpha", imports={}))
    public static /* synthetic */ void getA$annotations() {
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        double x = this.x % 360.0;
        double h = 0.0 <= x && x < 60.0 ? ColorXSVaKt.access$map(x, 0.0, 60.0, 0.0, 35.0) : (60.0 <= x && x < 120.0 ? ColorXSVaKt.access$map(x, 60.0, 120.0, 35.0, 60.0) : (120.0 <= x && x < 180.0 ? ColorXSVaKt.access$map(x, 120.0, 180.0, 60.0, 135.0) : (180.0 <= x && x < 240.0 ? ColorXSVaKt.access$map(x, 180.0, 240.0, 135.0, 225.0) : (240.0 <= x && x < 300.0 ? ColorXSVaKt.access$map(x, 240.0, 300.0, 225.0, 275.0) : ColorXSVaKt.access$map(x, 300.0, 360.0, 275.0, 360.0)))));
        return new ColorHSVa(h, this.s, this.v, this.getAlpha());
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toHSVa().toRGBa();
    }

    @Override
    @NotNull
    public ColorXSVa shiftHue(double shiftInDegrees) {
        return ColorXSVa.copy$default(this, this.x + shiftInDegrees, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorXSVa withHue(double hue) {
        return ColorXSVa.copy$default(this, hue, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    public double getHue() {
        return this.x;
    }

    @Override
    @NotNull
    public ColorXSVa withSaturation(double saturation) {
        return ColorXSVa.copy$default(this, 0.0, saturation, 0.0, 0.0, 13, null);
    }

    @Override
    public double getSaturation() {
        return this.s;
    }

    @Override
    @NotNull
    public ColorXSVa shade(double factor) {
        return ColorXSVa.copy$default(this, 0.0, 0.0, this.v * factor, 0.0, 11, null);
    }

    @Override
    @NotNull
    public ColorXSVa opacify(double factor) {
        return ColorXSVa.copy$default(this, 0.0, 0.0, 0.0, this.getAlpha() * factor, 7, null);
    }

    @Override
    @NotNull
    public ColorXSVa plus(@NotNull ColorXSVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.x + right.x, this.s + right.s, this.v + right.v, this.getAlpha() + right.getAlpha());
    }

    @Override
    @NotNull
    public ColorXSVa minus(@NotNull ColorXSVa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.x - right.x, this.s - right.s, this.v - right.v, this.getAlpha() - right.getAlpha());
    }

    @Override
    @NotNull
    public ColorXSVa times(double scale) {
        return this.copy(this.x * scale, this.s * scale, this.v * scale, this.getAlpha() * scale);
    }

    @Override
    @NotNull
    public ColorXSVa mix(@NotNull ColorXSVa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorXSVaKt.mix(this, other, factor);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.x, this.s, this.v, this.getAlpha());
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.v;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXSVa copy(double x, double s, double v, double alpha) {
        return new ColorXSVa(x, s, v, alpha);
    }

    public static /* synthetic */ ColorXSVa copy$default(ColorXSVa colorXSVa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorXSVa.x;
        }
        if ((n & 2) != 0) {
            d2 = colorXSVa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorXSVa.v;
        }
        if ((n & 8) != 0) {
            d4 = colorXSVa.alpha;
        }
        return colorXSVa.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ColorXSVa(x=" + this.x + ", s=" + this.s + ", v=" + this.v + ", alpha=" + this.alpha + ")";
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.s);
        result2 = result2 * 31 + Double.hashCode(this.v);
        result2 = result2 * 31 + Double.hashCode(this.alpha);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorXSVa)) {
            return false;
        }
        ColorXSVa colorXSVa = (ColorXSVa)other;
        if (Double.compare(this.x, colorXSVa.x) != 0) {
            return false;
        }
        if (Double.compare(this.s, colorXSVa.s) != 0) {
            return false;
        }
        if (Double.compare(this.v, colorXSVa.v) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorXSVa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorXSVa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorXSVa saturate(double factor) {
        return SaturatableColor.DefaultImpls.saturate(this, factor);
    }

    @Override
    @NotNull
    public ColorXSVa mixSaturation(double saturation, double factor) {
        return SaturatableColor.DefaultImpls.mixSaturation(this, saturation, factor);
    }

    @Override
    @NotNull
    public ColorXSVa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorXSVa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.x);
        output.encodeDoubleElement(serialDesc, 1, self.s);
        output.encodeDoubleElement(serialDesc, 2, self.v);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.getAlpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.getAlpha());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : Double.compare(self.a, self.getAlpha()) != 0) {
            output.encodeDoubleElement(serialDesc, 4, self.a);
        }
    }

    public /* synthetic */ ColorXSVa(int seen0, double x, double s, double v, double alpha, double a, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.s = s;
        this.v = v;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
        this.a = (seen0 & 0x10) == 0 ? this.getAlpha() : a;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/color/ColorXSVa$Companion;", "", "<init>", "()V", "fromHSVa", "Lorg/openrndr/color/ColorXSVa;", "hsva", "Lorg/openrndr/color/ColorHSVa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorXSVa fromHSVa(@NotNull ColorHSVa hsva) {
            Intrinsics.checkNotNullParameter(hsva, "hsva");
            double h = (hsva.h() % 360.0 + 360.0) % 360.0;
            double x = 0.0 <= h && h < 35.0 ? ColorXSVaKt.access$map(h, 0.0, 35.0, 0.0, 60.0) : (35.0 <= h && h < 60.0 ? ColorXSVaKt.access$map(h, 35.0, 60.0, 60.0, 120.0) : (60.0 <= h && h < 135.0 ? ColorXSVaKt.access$map(h, 60.0, 135.0, 120.0, 180.0) : (135.0 <= h && h < 225.0 ? ColorXSVaKt.access$map(h, 135.0, 225.0, 180.0, 240.0) : (225.0 <= h && h < 275.0 ? ColorXSVaKt.access$map(h, 225.0, 275.0, 240.0, 300.0) : ColorXSVaKt.access$map(h, 275.0, 360.0, 300.0, 360.0)))));
            return new ColorXSVa(x, hsva.s(), hsva.v(), hsva.alpha());
        }

        @NotNull
        public final KSerializer<ColorXSVa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

