/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dds;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.dds.DDSPixelFormat;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b;\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010u\u001a\u00020vH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\u001a\u0010\u0018\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000bR\u001a\u0010\u001b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\t\"\u0004\b,\u0010\u000bR\u001a\u0010-\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\t\"\u0004\b/\u0010\u000bR\u001a\u00100\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\t\"\u0004\b2\u0010\u000bR\u001a\u00103\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\t\"\u0004\b5\u0010\u000bR\u001a\u00106\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\t\"\u0004\b8\u0010\u000bR\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>R\u001a\u0010B\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010<\"\u0004\bD\u0010>R\u001a\u0010E\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010<\"\u0004\bG\u0010>R\u001a\u0010H\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010<\"\u0004\bJ\u0010>R\u001a\u0010K\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010<\"\u0004\bM\u0010>R\u001a\u0010N\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010<\"\u0004\bP\u0010>R\u001a\u0010Q\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010<\"\u0004\bS\u0010>R\u001a\u0010T\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010<\"\u0004\bV\u0010>R\u001a\u0010W\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010<\"\u0004\bY\u0010>R\u001a\u0010Z\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010<\"\u0004\b\\\u0010>R\u001a\u0010]\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010<\"\u0004\b_\u0010>R\u001a\u0010`\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010<\"\u0004\bb\u0010>R\u001a\u0010c\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010<\"\u0004\be\u0010>R\u001a\u0010f\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010<\"\u0004\bh\u0010>R\u001a\u0010i\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010<\"\u0004\bk\u0010>R\u001a\u0010l\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010<\"\u0004\bn\u0010>R\u001a\u0010o\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010<\"\u0004\bq\u0010>R\u001a\u0010r\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010<\"\u0004\bt\u0010>\u00a8\u0006w"}, d2={"Lorg/openrndr/dds/DDSHeader;", "", "header", "Lorg/openrndr/utils/buffer/MPPBuffer;", "<init>", "(Lorg/openrndr/utils/buffer/MPPBuffer;)V", "size", "", "getSize", "()I", "setSize", "(I)V", "flags", "getFlags", "setFlags", "height", "getHeight", "setHeight", "width", "getWidth", "setWidth", "pitchOrLinearSize", "getPitchOrLinearSize", "setPitchOrLinearSize", "depth", "getDepth", "setDepth", "mipmapCount", "getMipmapCount", "setMipmapCount", "reserved", "", "getReserved", "()[I", "setReserved", "([I)V", "pixelFormat", "Lorg/openrndr/dds/DDSPixelFormat;", "getPixelFormat", "()Lorg/openrndr/dds/DDSPixelFormat;", "setPixelFormat", "(Lorg/openrndr/dds/DDSPixelFormat;)V", "caps", "getCaps", "setCaps", "caps2", "getCaps2", "setCaps2", "caps3", "getCaps3", "setCaps3", "caps4", "getCaps4", "setCaps4", "reserved2", "getReserved2", "setReserved2", "hasFlagMipMapCount", "", "getHasFlagMipMapCount", "()Z", "setHasFlagMipMapCount", "(Z)V", "hasFlagCaps", "getHasFlagCaps", "setHasFlagCaps", "hasFlagHeight", "getHasFlagHeight", "setHasFlagHeight", "hasFlagWidth", "getHasFlagWidth", "setHasFlagWidth", "hasFlagPitch", "getHasFlagPitch", "setHasFlagPitch", "hasFlagPixelFormat", "getHasFlagPixelFormat", "setHasFlagPixelFormat", "hasFlagLinearSize", "getHasFlagLinearSize", "setHasFlagLinearSize", "hasFlagDepth", "getHasFlagDepth", "setHasFlagDepth", "hasCapsComplex", "getHasCapsComplex", "setHasCapsComplex", "hasCapsMipMap", "getHasCapsMipMap", "setHasCapsMipMap", "hasCapsTexture", "getHasCapsTexture", "setHasCapsTexture", "hasCaps2CubeMap", "getHasCaps2CubeMap", "setHasCaps2CubeMap", "hasCaps2CubeMapPX", "getHasCaps2CubeMapPX", "setHasCaps2CubeMapPX", "hasCaps2CubeMapNX", "getHasCaps2CubeMapNX", "setHasCaps2CubeMapNX", "hasCaps2CubeMapPY", "getHasCaps2CubeMapPY", "setHasCaps2CubeMapPY", "hasCaps2CubeMapNY", "getHasCaps2CubeMapNY", "setHasCaps2CubeMapNY", "hasCaps2CubeMapPZ", "getHasCaps2CubeMapPZ", "setHasCaps2CubeMapPZ", "hasCaps2CubeMapNZ", "getHasCaps2CubeMapNZ", "setHasCaps2CubeMapNZ", "hasCaps2Volume", "getHasCaps2Volume", "setHasCaps2Volume", "toString", "", "openrndr-dds"})
final class DDSHeader {
    private int size;
    private int flags;
    private int height;
    private int width;
    private int pitchOrLinearSize;
    private int depth;
    private int mipmapCount;
    @NotNull
    private int[] reserved;
    @NotNull
    private DDSPixelFormat pixelFormat;
    private int caps;
    private int caps2;
    private int caps3;
    private int caps4;
    private int reserved2;
    private boolean hasFlagMipMapCount;
    private boolean hasFlagCaps;
    private boolean hasFlagHeight;
    private boolean hasFlagWidth;
    private boolean hasFlagPitch;
    private boolean hasFlagPixelFormat;
    private boolean hasFlagLinearSize;
    private boolean hasFlagDepth;
    private boolean hasCapsComplex;
    private boolean hasCapsMipMap;
    private boolean hasCapsTexture;
    private boolean hasCaps2CubeMap;
    private boolean hasCaps2CubeMapPX;
    private boolean hasCaps2CubeMapNX;
    private boolean hasCaps2CubeMapPY;
    private boolean hasCaps2CubeMapNY;
    private boolean hasCaps2CubeMapPZ;
    private boolean hasCaps2CubeMapNZ;
    private boolean hasCaps2Volume;

    public DDSHeader(@NotNull MPPBuffer header) {
        Intrinsics.checkNotNullParameter(header, "header");
        this.reserved = new int[11];
        if (header.capacity() != 124) {
            throw new RuntimeException("Expected header size of 124 bytes (is " + header.capacity() + " bytes");
        }
        this.size = header.getInt();
        this.flags = header.getInt();
        this.height = header.getInt();
        this.width = header.getInt();
        this.pitchOrLinearSize = header.getInt();
        this.depth = header.getInt();
        this.mipmapCount = header.getInt();
        int n = this.reserved.length;
        for (int i = 0; i < n; ++i) {
            this.reserved[i] = header.getInt();
        }
        this.pixelFormat = new DDSPixelFormat(header);
        this.caps = header.getInt();
        this.caps2 = header.getInt();
        this.caps3 = header.getInt();
        this.caps4 = header.getInt();
        this.reserved2 = header.getInt();
        this.hasFlagCaps = (this.flags & 1) == 1;
        this.hasFlagHeight = (this.flags & 2) == 2;
        this.hasFlagWidth = (this.flags & 4) == 4;
        this.hasFlagPitch = (this.flags & 8) == 8;
        this.hasFlagPixelFormat = (this.flags & 0x1000) == 4096;
        this.hasFlagMipMapCount = (this.flags & 0x20000) == 131072;
        this.hasFlagLinearSize = (this.flags & 0x80000) == 524288;
        this.hasFlagDepth = (this.flags & 0x800000) == 0x800000;
        this.hasCapsComplex = (this.caps & 8) == 8;
        this.hasCapsMipMap = (this.caps & 0x400000) == 0x400000;
        this.hasCapsTexture = (this.caps & 0x1000) == 4096;
        this.hasCaps2CubeMap = (this.caps2 & 0x200) == 512;
        this.hasCaps2CubeMapPX = (this.caps2 & 0x400) == 1024;
        this.hasCaps2CubeMapNX = (this.caps2 & 0x800) == 2048;
        this.hasCaps2CubeMapPY = (this.caps2 & 0x1000) == 4096;
        this.hasCaps2CubeMapNY = (this.caps2 & 0x2000) == 8192;
        this.hasCaps2CubeMapPZ = (this.caps2 & 0x4000) == 16384;
        this.hasCaps2CubeMapNZ = (this.caps2 & 0x8000) == 32768;
        boolean bl = this.hasCaps2Volume = (this.caps2 & 0x200000) == 0x200000;
        if (!(this.hasFlagCaps && this.hasFlagHeight && this.hasFlagWidth && this.hasFlagPixelFormat)) {
            throw new RuntimeException("missing required flags");
        }
        if (!this.hasCapsTexture) {
            throw new RuntimeException("missing required caps");
        }
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int n) {
        this.flags = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getPitchOrLinearSize() {
        return this.pitchOrLinearSize;
    }

    public final void setPitchOrLinearSize(int n) {
        this.pitchOrLinearSize = n;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final void setDepth(int n) {
        this.depth = n;
    }

    public final int getMipmapCount() {
        return this.mipmapCount;
    }

    public final void setMipmapCount(int n) {
        this.mipmapCount = n;
    }

    @NotNull
    public final int[] getReserved() {
        return this.reserved;
    }

    public final void setReserved(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.reserved = nArray;
    }

    @NotNull
    public final DDSPixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public final void setPixelFormat(@NotNull DDSPixelFormat dDSPixelFormat) {
        Intrinsics.checkNotNullParameter(dDSPixelFormat, "<set-?>");
        this.pixelFormat = dDSPixelFormat;
    }

    public final int getCaps() {
        return this.caps;
    }

    public final void setCaps(int n) {
        this.caps = n;
    }

    public final int getCaps2() {
        return this.caps2;
    }

    public final void setCaps2(int n) {
        this.caps2 = n;
    }

    public final int getCaps3() {
        return this.caps3;
    }

    public final void setCaps3(int n) {
        this.caps3 = n;
    }

    public final int getCaps4() {
        return this.caps4;
    }

    public final void setCaps4(int n) {
        this.caps4 = n;
    }

    public final int getReserved2() {
        return this.reserved2;
    }

    public final void setReserved2(int n) {
        this.reserved2 = n;
    }

    public final boolean getHasFlagMipMapCount() {
        return this.hasFlagMipMapCount;
    }

    public final void setHasFlagMipMapCount(boolean bl) {
        this.hasFlagMipMapCount = bl;
    }

    public final boolean getHasFlagCaps() {
        return this.hasFlagCaps;
    }

    public final void setHasFlagCaps(boolean bl) {
        this.hasFlagCaps = bl;
    }

    public final boolean getHasFlagHeight() {
        return this.hasFlagHeight;
    }

    public final void setHasFlagHeight(boolean bl) {
        this.hasFlagHeight = bl;
    }

    public final boolean getHasFlagWidth() {
        return this.hasFlagWidth;
    }

    public final void setHasFlagWidth(boolean bl) {
        this.hasFlagWidth = bl;
    }

    public final boolean getHasFlagPitch() {
        return this.hasFlagPitch;
    }

    public final void setHasFlagPitch(boolean bl) {
        this.hasFlagPitch = bl;
    }

    public final boolean getHasFlagPixelFormat() {
        return this.hasFlagPixelFormat;
    }

    public final void setHasFlagPixelFormat(boolean bl) {
        this.hasFlagPixelFormat = bl;
    }

    public final boolean getHasFlagLinearSize() {
        return this.hasFlagLinearSize;
    }

    public final void setHasFlagLinearSize(boolean bl) {
        this.hasFlagLinearSize = bl;
    }

    public final boolean getHasFlagDepth() {
        return this.hasFlagDepth;
    }

    public final void setHasFlagDepth(boolean bl) {
        this.hasFlagDepth = bl;
    }

    public final boolean getHasCapsComplex() {
        return this.hasCapsComplex;
    }

    public final void setHasCapsComplex(boolean bl) {
        this.hasCapsComplex = bl;
    }

    public final boolean getHasCapsMipMap() {
        return this.hasCapsMipMap;
    }

    public final void setHasCapsMipMap(boolean bl) {
        this.hasCapsMipMap = bl;
    }

    public final boolean getHasCapsTexture() {
        return this.hasCapsTexture;
    }

    public final void setHasCapsTexture(boolean bl) {
        this.hasCapsTexture = bl;
    }

    public final boolean getHasCaps2CubeMap() {
        return this.hasCaps2CubeMap;
    }

    public final void setHasCaps2CubeMap(boolean bl) {
        this.hasCaps2CubeMap = bl;
    }

    public final boolean getHasCaps2CubeMapPX() {
        return this.hasCaps2CubeMapPX;
    }

    public final void setHasCaps2CubeMapPX(boolean bl) {
        this.hasCaps2CubeMapPX = bl;
    }

    public final boolean getHasCaps2CubeMapNX() {
        return this.hasCaps2CubeMapNX;
    }

    public final void setHasCaps2CubeMapNX(boolean bl) {
        this.hasCaps2CubeMapNX = bl;
    }

    public final boolean getHasCaps2CubeMapPY() {
        return this.hasCaps2CubeMapPY;
    }

    public final void setHasCaps2CubeMapPY(boolean bl) {
        this.hasCaps2CubeMapPY = bl;
    }

    public final boolean getHasCaps2CubeMapNY() {
        return this.hasCaps2CubeMapNY;
    }

    public final void setHasCaps2CubeMapNY(boolean bl) {
        this.hasCaps2CubeMapNY = bl;
    }

    public final boolean getHasCaps2CubeMapPZ() {
        return this.hasCaps2CubeMapPZ;
    }

    public final void setHasCaps2CubeMapPZ(boolean bl) {
        this.hasCaps2CubeMapPZ = bl;
    }

    public final boolean getHasCaps2CubeMapNZ() {
        return this.hasCaps2CubeMapNZ;
    }

    public final void setHasCaps2CubeMapNZ(boolean bl) {
        this.hasCaps2CubeMapNZ = bl;
    }

    public final boolean getHasCaps2Volume() {
        return this.hasCaps2Volume;
    }

    public final void setHasCaps2Volume(boolean bl) {
        this.hasCaps2Volume = bl;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.reserved);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return "DDSHeader(size=" + this.size + ", flags=" + this.flags + ", height=" + this.height + ", width=" + this.width + ", pitchOrLinearSize=" + this.pitchOrLinearSize + ", depth=" + this.depth + ", mipmapCount=" + this.mipmapCount + ", reserved=" + string + ", pixelFormat=" + this.pixelFormat + ", caps=" + this.caps + ", caps2=" + this.caps2 + ", caps3=" + this.caps3 + ", caps4=" + this.caps4 + ", reserved2=" + this.reserved2 + ", hasFlagMipMapCount=" + this.hasFlagMipMapCount + ", hasFlagCaps=" + this.hasFlagCaps + ", hasFlagHeight=" + this.hasFlagHeight + ", hasFlagWidth=" + this.hasFlagWidth + ", hasFlagPitch=" + this.hasFlagPitch + ", hasFlagPixelFormat=" + this.hasFlagPixelFormat + ", hasFlagLinearSize=" + this.hasFlagLinearSize + ", hasFlagDepth=" + this.hasFlagDepth + ", hasCapsComplex=" + this.hasCapsComplex + ", hasCapsMipMap=" + this.hasCapsMipMap + ", hasCapsTexture=" + this.hasCapsTexture + ", hasCaps2CubeMap=" + this.hasCaps2CubeMap + ", hasCaps2CubeMapPX=" + this.hasCaps2CubeMapPX + ", hasCaps2CubeMapNX=" + this.hasCaps2CubeMapNX + ", hasCaps2CubeMapPY=" + this.hasCaps2CubeMapPY + ", hasCaps2CubeMapNY=" + this.hasCaps2CubeMapNY + ", hasCaps2CubeMapPZ=" + this.hasCaps2CubeMapPZ + ", hasCaps2CubeMapNZ=" + this.hasCaps2CubeMapNZ + ", hasCaps2Volume=" + this.hasCaps2Volume + ")";
    }
}

