/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dds;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0018\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010>\u001a\u00020\"2\u0006\u0010?\u001a\u00020\u0007H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\u001a\u0010\u0018\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000bR\u001a\u0010\u001b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u001a\u0010\u001e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\t\"\u0004\b \u0010\u000bR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R\u001a\u0010/\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010)\"\u0004\b1\u0010+R\u001a\u00102\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010)\"\u0004\b4\u0010+R\u001a\u00105\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010)\"\u0004\b7\u0010+R\u001a\u00108\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010)\"\u0004\b:\u0010+R\u001a\u0010;\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010)\"\u0004\b=\u0010+\u00a8\u0006@"}, d2={"Lorg/openrndr/dds/DDSPixelFormat;", "", "header", "Lorg/openrndr/utils/buffer/MPPBuffer;", "<init>", "(Lorg/openrndr/utils/buffer/MPPBuffer;)V", "dwSize", "", "getDwSize", "()I", "setDwSize", "(I)V", "dwFlags", "getDwFlags", "setDwFlags", "dwFourCC", "getDwFourCC", "setDwFourCC", "dwRGBBitCount", "getDwRGBBitCount", "setDwRGBBitCount", "dwRBitMask", "getDwRBitMask", "setDwRBitMask", "dwGBitMask", "getDwGBitMask", "setDwGBitMask", "dwBBitMask", "getDwBBitMask", "setDwBBitMask", "dwABitMask", "getDwABitMask", "setDwABitMask", "sFourCC", "", "getSFourCC", "()Ljava/lang/String;", "setSFourCC", "(Ljava/lang/String;)V", "isCompressed", "", "()Z", "setCompressed", "(Z)V", "hasFlagAlphaPixels", "getHasFlagAlphaPixels", "setHasFlagAlphaPixels", "hasFlagAlpha", "getHasFlagAlpha", "setHasFlagAlpha", "hasFlagFourCC", "getHasFlagFourCC", "setHasFlagFourCC", "hasFlagRgb", "getHasFlagRgb", "setHasFlagRgb", "hasFlagYuv", "getHasFlagYuv", "setHasFlagYuv", "hasFlagLuminance", "getHasFlagLuminance", "setHasFlagLuminance", "createFourCCString", "fourCC", "openrndr-dds"})
public final class DDSPixelFormat {
    private int dwSize;
    private int dwFlags;
    private int dwFourCC;
    private int dwRGBBitCount;
    private int dwRBitMask;
    private int dwGBitMask;
    private int dwBBitMask;
    private int dwABitMask;
    @NotNull
    private String sFourCC;
    private boolean isCompressed;
    private boolean hasFlagAlphaPixels;
    private boolean hasFlagAlpha;
    private boolean hasFlagFourCC;
    private boolean hasFlagRgb;
    private boolean hasFlagYuv;
    private boolean hasFlagLuminance;

    public DDSPixelFormat(@NotNull MPPBuffer header) {
        Intrinsics.checkNotNullParameter(header, "header");
        this.dwSize = header.getInt();
        this.dwFlags = header.getInt();
        this.dwFourCC = header.getInt();
        this.dwRGBBitCount = header.getInt();
        this.dwRBitMask = header.getInt();
        this.dwGBitMask = header.getInt();
        this.dwBBitMask = header.getInt();
        this.dwABitMask = header.getInt();
        if (this.dwSize != 32) {
            throw new RuntimeException("size is not 32 bytes (is " + this.dwSize + " bytes)");
        }
        this.hasFlagAlphaPixels = (this.dwFlags & 1) == 1;
        this.hasFlagAlpha = (this.dwFlags & 2) == 2;
        this.hasFlagFourCC = (this.dwFlags & 4) == 4;
        this.hasFlagRgb = (this.dwFlags & 0x40) == 64;
        this.hasFlagYuv = (this.dwFlags & 0x200) == 512;
        this.hasFlagLuminance = (this.dwFlags & 0x20000) == 131072;
        String string = this.sFourCC = this.hasFlagFourCC ? this.createFourCCString(this.dwFourCC) : "";
        if (this.hasFlagFourCC) {
            this.isCompressed = true;
        } else if (this.hasFlagRgb) {
            this.isCompressed = false;
        }
    }

    public final int getDwSize() {
        return this.dwSize;
    }

    public final void setDwSize(int n) {
        this.dwSize = n;
    }

    public final int getDwFlags() {
        return this.dwFlags;
    }

    public final void setDwFlags(int n) {
        this.dwFlags = n;
    }

    public final int getDwFourCC() {
        return this.dwFourCC;
    }

    public final void setDwFourCC(int n) {
        this.dwFourCC = n;
    }

    public final int getDwRGBBitCount() {
        return this.dwRGBBitCount;
    }

    public final void setDwRGBBitCount(int n) {
        this.dwRGBBitCount = n;
    }

    public final int getDwRBitMask() {
        return this.dwRBitMask;
    }

    public final void setDwRBitMask(int n) {
        this.dwRBitMask = n;
    }

    public final int getDwGBitMask() {
        return this.dwGBitMask;
    }

    public final void setDwGBitMask(int n) {
        this.dwGBitMask = n;
    }

    public final int getDwBBitMask() {
        return this.dwBBitMask;
    }

    public final void setDwBBitMask(int n) {
        this.dwBBitMask = n;
    }

    public final int getDwABitMask() {
        return this.dwABitMask;
    }

    public final void setDwABitMask(int n) {
        this.dwABitMask = n;
    }

    @NotNull
    public final String getSFourCC() {
        return this.sFourCC;
    }

    public final void setSFourCC(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.sFourCC = string;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    public final void setCompressed(boolean bl) {
        this.isCompressed = bl;
    }

    public final boolean getHasFlagAlphaPixels() {
        return this.hasFlagAlphaPixels;
    }

    public final void setHasFlagAlphaPixels(boolean bl) {
        this.hasFlagAlphaPixels = bl;
    }

    public final boolean getHasFlagAlpha() {
        return this.hasFlagAlpha;
    }

    public final void setHasFlagAlpha(boolean bl) {
        this.hasFlagAlpha = bl;
    }

    public final boolean getHasFlagFourCC() {
        return this.hasFlagFourCC;
    }

    public final void setHasFlagFourCC(boolean bl) {
        this.hasFlagFourCC = bl;
    }

    public final boolean getHasFlagRgb() {
        return this.hasFlagRgb;
    }

    public final void setHasFlagRgb(boolean bl) {
        this.hasFlagRgb = bl;
    }

    public final boolean getHasFlagYuv() {
        return this.hasFlagYuv;
    }

    public final void setHasFlagYuv(boolean bl) {
        this.hasFlagYuv = bl;
    }

    public final boolean getHasFlagLuminance() {
        return this.hasFlagLuminance;
    }

    public final void setHasFlagLuminance(boolean bl) {
        this.hasFlagLuminance = bl;
    }

    private final String createFourCCString(int fourCC) {
        char[] fourCCString = new char[4];
        int n = fourCCString.length;
        for (int i = 0; i < n; ++i) {
            fourCCString[i] = (char)(fourCC >> i * 8 & 0xFF);
        }
        return StringsKt.concatToString(fourCCString);
    }
}

