/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dds;

import java.io.File;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.dds.DDSData;
import org.openrndr.dds.DDSReaderKt;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"loadDDS", "Lorg/openrndr/dds/DDSData;", "file", "Ljava/io/File;", "buffer", "Ljava/nio/ByteBuffer;", "inputStream", "Ljava/io/InputStream;", "newByteBuffer", "data", "", "openrndr-dds"})
@JvmName(name="DDSReaderFunctions")
public final class DDSReaderFunctions {
    @NotNull
    public static final DDSData loadDDS(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        byte[] ba = FilesKt.readBytes(file);
        return DDSReaderKt.loadDDS$default(new MPPBuffer(DDSReaderFunctions.newByteBuffer(ba)), false, 2, null);
    }

    @NotNull
    public static final DDSData loadDDS(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        return DDSReaderKt.loadDDS$default(new MPPBuffer(buffer), false, 2, null);
    }

    @NotNull
    public static final DDSData loadDDS(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        byte[] ba = new byte[inputStream.available()];
        inputStream.read(ba);
        return DDSReaderKt.loadDDS$default(new MPPBuffer(DDSReaderFunctions.newByteBuffer(ba)), false, 2, null);
    }

    private static final ByteBuffer newByteBuffer(byte[] data) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(data.length).order(ByteOrder.nativeOrder());
        buffer.put(data);
        Intrinsics.checkNotNull(buffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)buffer).flip();
        return buffer;
    }
}

