/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dialogs;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.nfd.NFDFilterItem;
import org.lwjgl.util.nfd.NFDPathSetEnum;
import org.lwjgl.util.nfd.NativeFileDialog;
import org.openrndr.exceptions.StacktraceToolsKt;
import org.openrndr.platform.Platform;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\"\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\\\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\t2 \b\u0002\u0010\u0012\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00130\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0016\u001ab\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\t2 \b\u0002\u0010\u0012\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00130\u00140\u00132\u0018\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0013\u0012\u0004\u0012\u00020\r0\u0016\u001a:\u0010\u0018\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0016\u001ah\u0010\u0019\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\t2 \b\u0002\u0010\u0012\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00130\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0016\u001a2\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u001e\u0010\u001f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00130\u00140\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006 "}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "nfd", "", "getNfd", "()I", "nfd$delegate", "Lkotlin/Lazy;", "getDefaultPathForContext", "", "programName", "contextID", "setDefaultPathForContext", "", "file", "Ljava/io/File;", "openFileDialog", "defaultPath", "supportedExtensions", "", "Lkotlin/Pair;", "function", "Lkotlin/Function1;", "openFilesDialog", "openFolderDialog", "saveFileDialog", "suggestedFilename", "filterItems", "Lorg/lwjgl/util/nfd/NFDFilterItem$Buffer;", "stack", "Lorg/lwjgl/system/MemoryStack;", "extensions", "openrndr-dialogs"})
@SourceDebugExtension(value={"SMAP\nFileDialogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileDialogs.kt\norg/openrndr/dialogs/FileDialogsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n1#2:274\n2632#3,3:275\n*S KotlinDebug\n*F\n+ 1 FileDialogs.kt\norg/openrndr/dialogs/FileDialogsKt\n*L\n234#1:275,3\n*E\n"})
public final class FileDialogsKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(FileDialogsKt::logger$lambda$0);
    @NotNull
    private static final Lazy nfd$delegate = LazyKt.lazy(FileDialogsKt::nfd_delegate$lambda$1);

    public static final int getNfd() {
        Lazy lazy = nfd$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Nullable
    public static final String getDefaultPathForContext(@NotNull String programName, @NotNull String contextID) {
        String string;
        Intrinsics.checkNotNullParameter(programName, "programName");
        Intrinsics.checkNotNullParameter(contextID, "contextID");
        Properties props = new Properties();
        try {
            String string2;
            File f = new File(Platform.INSTANCE.supportDirectory(programName), ".file-dialog.properties");
            if (f.exists()) {
                FileInputStream is = new FileInputStream(f);
                props.load(is);
                is.close();
                String path = props.getProperty(programName + "." + contextID, null);
                logger.debug(() -> FileDialogsKt.getDefaultPathForContext$lambda$2(programName, contextID, path));
                string2 = path;
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String getDefaultPathForContext$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = StacktraceToolsKt.stackRootClassName$default(null, false, 3, null);
        }
        if ((n & 2) != 0) {
            string2 = "global";
        }
        return FileDialogsKt.getDefaultPathForContext(string, string2);
    }

    public static final void setDefaultPathForContext(@NotNull String programName, @NotNull String contextID, @NotNull File file) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        Intrinsics.checkNotNullParameter(contextID, "contextID");
        Intrinsics.checkNotNullParameter(file, "file");
        logger.debug(() -> FileDialogsKt.setDefaultPathForContext$lambda$3(programName, contextID, file));
        Properties props = new Properties();
        File it = file;
        boolean bl = false;
        String defaultPath = it.isDirectory() ? it.getAbsolutePath() : it.getParentFile().getAbsolutePath();
        try {
            File f = new File(Platform.INSTANCE.supportDirectory(programName), ".file-dialog.properties");
            if (!f.exists()) {
                f.createNewFile();
            }
            FileInputStream is = new FileInputStream(f);
            props.load(is);
            props.setProperty(programName + "." + contextID, defaultPath);
            is.close();
            FileOutputStream os = new FileOutputStream(f);
            props.store(os, "File dialog properties for " + programName);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static /* synthetic */ void setDefaultPathForContext$default(String string, String string2, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = StacktraceToolsKt.stackRootClassName$default(null, false, 3, null);
        }
        if ((n & 2) != 0) {
            string2 = "global";
        }
        FileDialogsKt.setDefaultPathForContext(string, string2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void openFileDialog(@NotNull String programName, @NotNull String contextID, @Nullable String defaultPath, @NotNull List<? extends Pair<String, ? extends List<String>>> supportedExtensions, @NotNull Function1<? super File, Unit> function2) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        Intrinsics.checkNotNullParameter(contextID, "contextID");
        Intrinsics.checkNotNullParameter(supportedExtensions, "supportedExtensions");
        Intrinsics.checkNotNullParameter(function2, "function");
        FileDialogsKt.getNfd();
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull(stack);
            NFDFilterItem.Buffer filterList = FileDialogsKt.filterItems(stack, supportedExtensions);
            PointerBuffer out = stack.mallocPointer(1);
            int r = NativeFileDialog.NFD_OpenDialog(out, filterList, defaultPath);
            if (r == 1) {
                long ptr = out.get(0);
                String str = MemoryUtil.memUTF8(ptr);
                File f = new File(str);
                FileDialogsKt.setDefaultPathForContext(programName, contextID, f);
                function2.invoke(f);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public static /* synthetic */ void openFileDialog$default(String string, String string2, String string3, List list, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = StacktraceToolsKt.stackRootClassName$default(null, false, 3, null);
        }
        if ((n & 2) != 0) {
            string2 = "global";
        }
        if ((n & 4) != 0) {
            string3 = FileDialogsKt.getDefaultPathForContext(string, string2);
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        FileDialogsKt.openFileDialog(string, string2, string3, list, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void openFilesDialog(@NotNull String programName, @NotNull String contextID, @Nullable String defaultPath, @NotNull List<? extends Pair<String, ? extends List<String>>> supportedExtensions, @NotNull Function1<? super List<? extends File>, Unit> function2) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        Intrinsics.checkNotNullParameter(contextID, "contextID");
        Intrinsics.checkNotNullParameter(supportedExtensions, "supportedExtensions");
        Intrinsics.checkNotNullParameter(function2, "function");
        FileDialogsKt.getNfd();
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull(stack);
            NFDFilterItem.Buffer filterList = FileDialogsKt.filterItems(stack, supportedExtensions);
            PointerBuffer pp = stack.mallocPointer(1);
            int r = NativeFileDialog.NFD_OpenDialogMultiple(pp, filterList, defaultPath);
            List files = new ArrayList();
            if (r == 1) {
                long pathSet = pp.get(0);
                NFDPathSetEnum psEnum = NFDPathSetEnum.calloc(stack);
                NativeFileDialog.NFD_PathSet_GetEnum(pathSet, psEnum);
                while (NativeFileDialog.NFD_PathSet_EnumNext(psEnum, pp) == 1 && pp.get(0) != 0L) {
                    files.add(new File(pp.getStringUTF8(0)));
                    NativeFileDialog.NFD_PathSet_FreePath(pp.get(0));
                }
                NativeFileDialog.NFD_PathSet_FreeEnum(psEnum);
                NativeFileDialog.NFD_PathSet_Free(pathSet);
            }
            if (!((Collection)files).isEmpty()) {
                FileDialogsKt.setDefaultPathForContext(programName, contextID, (File)files.get(0));
                function2.invoke(files);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public static /* synthetic */ void openFilesDialog$default(String string, String string2, String string3, List list, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = StacktraceToolsKt.stackRootClassName$default(null, false, 3, null);
        }
        if ((n & 2) != 0) {
            string2 = "global";
        }
        if ((n & 4) != 0) {
            string3 = FileDialogsKt.getDefaultPathForContext(string, string2);
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        FileDialogsKt.openFilesDialog(string, string2, string3, list, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void openFolderDialog(@NotNull String programName, @NotNull String contextID, @Nullable String defaultPath, @NotNull Function1<? super File, Unit> function2) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        Intrinsics.checkNotNullParameter(contextID, "contextID");
        Intrinsics.checkNotNullParameter(function2, "function");
        FileDialogsKt.getNfd();
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            PointerBuffer out = stack.mallocPointer(1);
            int r = NativeFileDialog.NFD_PickFolder(out, defaultPath);
            if (r == 1) {
                long ptr = out.get(0);
                String str = MemoryUtil.memUTF8(ptr);
                File f = new File(str);
                FileDialogsKt.setDefaultPathForContext(programName, contextID, f);
                function2.invoke(f);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public static /* synthetic */ void openFolderDialog$default(String string, String string2, String string3, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = StacktraceToolsKt.stackRootClassName$default(null, false, 3, null);
        }
        if ((n & 2) != 0) {
            string2 = "global";
        }
        if ((n & 4) != 0) {
            string3 = FileDialogsKt.getDefaultPathForContext(string, string2);
        }
        FileDialogsKt.openFolderDialog(string, string2, string3, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final void saveFileDialog(@NotNull String programName, @NotNull String contextID, @Nullable String defaultPath, @Nullable String suggestedFilename, @NotNull List<? extends Pair<String, ? extends List<String>>> supportedExtensions, @NotNull Function1<? super File, Unit> function) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        Intrinsics.checkNotNullParameter(contextID, "contextID");
        Intrinsics.checkNotNullParameter(supportedExtensions, "supportedExtensions");
        Intrinsics.checkNotNullParameter(function, "function");
        FileDialogsKt.getNfd();
        var6_6 = MemoryStack.stackPush();
        var7_7 = null;
        try {
            stack = (MemoryStack)var6_6;
            $i$a$-use-FileDialogsKt$saveFileDialog$1 = false;
            Intrinsics.checkNotNull(stack);
            filterList = FileDialogsKt.filterItems(stack, supportedExtensions);
            v0 = defaultPath;
            if (v0 == null && (v0 = FileDialogsKt.getDefaultPathForContext(programName, contextID)) == null) {
                v0 = ".";
            }
            defaultPathBase = Paths.get(v0, new String[0]).normalize().toString();
            FileDialogsKt.logger.debug((Function0<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, saveFileDialog$lambda$13$lambda$8(java.lang.String ), ()Ljava/lang/Object;)((String)defaultPathBase));
            out = stack.mallocPointer(1);
            switch (NativeFileDialog.NFD_SaveDialog(out, filterList, defaultPathBase, suggestedFilename)) {
                case 1: {
                    ptr = out.get(0);
                    pickedFilename = MemoryUtil.memUTF8(ptr);
                    pickedFile = new File(pickedFilename);
                    if (!(((Collection)supportedExtensions).isEmpty() == false)) ** GOTO lbl-1000
                    $this$none$iv = supportedExtensions;
                    $i$f$none = false;
                    if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl32
                    v1 = true;
                    ** GOTO lbl39
lbl32:
                    // 2 sources

                    for (T element$iv : $this$none$iv) {
                        it = (Pair)element$iv;
                        $i$a$-none-FileDialogsKt$saveFileDialog$1$finalFile$1 = false;
                        if (!((List)it.getSecond()).contains(FilesKt.getExtension(pickedFile))) continue;
                        v1 = false;
                        ** GOTO lbl39
                    }
                    v1 = true;
lbl39:
                    // 3 sources

                    if (v1) {
                        fixedFilename = pickedFilename + "." + CollectionsKt.first(CollectionsKt.first(supportedExtensions).getSecond());
                        FileDialogsKt.logger.warn((Function0<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, saveFileDialog$lambda$13$lambda$10(java.lang.String ), ()Ljava/lang/Object;)((String)fixedFilename));
                        v2 = new File(fixedFilename);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = pickedFile;
                    }
                    finalFile = v2;
                    try {
                        function.invoke(finalFile);
                    }
                    catch (Throwable e) {
                        FileDialogsKt.logger.error((Function0<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, saveFileDialog$lambda$13$lambda$11(java.io.File ), ()Ljava/lang/Object;)((File)finalFile));
                        throw e;
                    }
                    FileDialogsKt.setDefaultPathForContext(programName, contextID, finalFile);
                    break;
                }
                case 0: {
                    FileDialogsKt.logger.error((Function0<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, saveFileDialog$lambda$13$lambda$12(), ()Ljava/lang/Object;)());
                }
            }
            var8_8 = Unit.INSTANCE;
        }
        catch (Throwable var8_9) {
            var7_7 = var8_9;
            throw var8_9;
        }
        finally {
            AutoCloseableKt.closeFinally(var6_6, var7_7);
        }
    }

    public static /* synthetic */ void saveFileDialog$default(String string, String string2, String string3, String string4, List list, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = StacktraceToolsKt.stackRootClassName$default(null, false, 3, null);
        }
        if ((n & 2) != 0) {
            string2 = "global";
        }
        if ((n & 4) != 0) {
            string3 = FileDialogsKt.getDefaultPathForContext(string, string2);
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        FileDialogsKt.saveFileDialog(string, string2, string3, string4, list, function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final NFDFilterItem.Buffer filterItems(MemoryStack stack, List<? extends Pair<String, ? extends List<String>>> extensions) {
        NFDFilterItem.Buffer buffer;
        if (!((Collection)extensions).isEmpty()) {
            void var2_2;
            NFDFilterItem.Buffer filters = NFDFilterItem.malloc(extensions.size());
            int n = ((Collection)extensions).size();
            for (int i = 0; i < n; ++i) {
                ((NFDFilterItem)filters.get(i)).name(stack.UTF8(extensions.get(i).getFirst())).spec(stack.UTF8(CollectionsKt.joinToString$default(extensions.get(i).getSecond(), ",", null, null, 0, null, null, 62, null)));
            }
            buffer = var2_2;
        } else {
            buffer = null;
        }
        return buffer;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final int nfd_delegate$lambda$1() {
        return NativeFileDialog.NFD_Init();
    }

    private static final Object getDefaultPathForContext$lambda$2(String $programName, String $contextID, String $path) {
        Intrinsics.checkNotNullParameter($programName, "$programName");
        Intrinsics.checkNotNullParameter($contextID, "$contextID");
        return "Resolved default path for '" + $programName + "::" + $contextID + "' to '" + $path + "'";
    }

    private static final Object setDefaultPathForContext$lambda$3(String $programName, String $contextID, File $file) {
        Intrinsics.checkNotNullParameter($programName, "$programName");
        Intrinsics.checkNotNullParameter($contextID, "$contextID");
        Intrinsics.checkNotNullParameter($file, "$file");
        return "Setting default path for '" + $programName + "::" + $contextID + "' to '" + $file.getAbsolutePath() + "'";
    }

    private static final Object saveFileDialog$lambda$13$lambda$8(String $defaultPathBase) {
        Intrinsics.checkNotNullParameter($defaultPathBase, "$defaultPathBase");
        return "Default path is " + $defaultPathBase;
    }

    private static final Object saveFileDialog$lambda$13$lambda$10(String $fixedFilename) {
        Intrinsics.checkNotNullParameter($fixedFilename, "$fixedFilename");
        return "User has picked either no or an unsupported extension, fixed filename to '" + $fixedFilename + "'";
    }

    private static final Object saveFileDialog$lambda$13$lambda$11(File $finalFile) {
        Intrinsics.checkNotNullParameter($finalFile, "$finalFile");
        return "Caught exception while saving to file '" + $finalFile.getAbsolutePath();
    }

    private static final Object saveFileDialog$lambda$13$lambda$12() {
        return "error NFD_SaveDialog returned NFD_ERROR";
    }
}

