/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferTextureFileFormat;
import org.openrndr.draw.BufferTextureShadow;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nJ$\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005H&J$\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005H&J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\b\u0010+\u001a\u00020\tH&J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0005H&R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006/"}, d2={"Lorg/openrndr/draw/BufferTexture;", "", "<init>", "()V", "put", "", "putter", "Lkotlin/Function1;", "Lorg/openrndr/draw/BufferWriter;", "", "Lkotlin/ExtensionFunctionType;", "read", "target", "Ljava/nio/ByteBuffer;", "offset", "elementReadCount", "write", "source", "elementWriteCount", "saveToFile", "file", "Ljava/io/File;", "fileFormat", "Lorg/openrndr/draw/BufferTextureFileFormat;", "session", "Lorg/openrndr/draw/Session;", "getSession", "()Lorg/openrndr/draw/Session;", "shadow", "Lorg/openrndr/draw/BufferTextureShadow;", "getShadow", "()Lorg/openrndr/draw/BufferTextureShadow;", "format", "Lorg/openrndr/draw/ColorFormat;", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "getType", "()Lorg/openrndr/draw/ColorType;", "elementCount", "getElementCount", "()I", "destroy", "bind", "unit", "Companion", "openrndr-draw"})
public abstract class BufferTexture {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int put(@NotNull Function1<? super BufferWriter, Unit> putter) {
        Intrinsics.checkNotNullParameter(putter, "putter");
        BufferWriter w = this.getShadow().writer();
        w.rewind();
        putter.invoke(w);
        int count2 = w.getPositionElements();
        this.getShadow().upload(0, w.getPosition());
        w.rewind();
        return count2;
    }

    public abstract void read(@NotNull ByteBuffer var1, int var2, int var3);

    public static /* synthetic */ void read$default(BufferTexture bufferTexture, ByteBuffer byteBuffer, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = bufferTexture.getElementCount();
        }
        bufferTexture.read(byteBuffer, n, n2);
    }

    public abstract void write(@NotNull ByteBuffer var1, int var2, int var3);

    public static /* synthetic */ void write$default(BufferTexture bufferTexture, ByteBuffer byteBuffer, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = bufferTexture.getElementCount();
        }
        bufferTexture.write(byteBuffer, n, n2);
    }

    public final void saveToFile(@NotNull File file, @NotNull BufferTextureFileFormat fileFormat) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter((Object)fileFormat, "fileFormat");
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.getElementCount() * this.getFormat().getComponentCount() * this.getType().getComponentSize());
        ByteBuffer header = ByteBuffer.allocateDirect(12);
        header.order(ByteOrder.nativeOrder());
        header.putInt(buffer.capacity());
        header.putInt(this.getFormat().ordinal());
        header.putInt(this.getType().ordinal());
        buffer.order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNull(buffer);
        BufferTexture.read$default(this, buffer, 0, 0, 6, null);
        buffer.rewind();
        header.rewind();
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel chan = raf.getChannel();
        chan.write(header);
        chan.write(buffer);
        chan.close();
        raf.close();
    }

    public static /* synthetic */ void saveToFile$default(BufferTexture bufferTexture, File file, BufferTextureFileFormat bufferTextureFileFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveToFile");
        }
        if ((n & 2) != 0) {
            bufferTextureFileFormat = BufferTextureFileFormat.ORB;
        }
        bufferTexture.saveToFile(file, bufferTextureFileFormat);
    }

    @Nullable
    public abstract Session getSession();

    @NotNull
    public abstract BufferTextureShadow getShadow();

    @NotNull
    public abstract ColorFormat getFormat();

    @NotNull
    public abstract ColorType getType();

    public abstract int getElementCount();

    public abstract void destroy();

    public abstract void bind(int var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/draw/BufferTexture$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/draw/BufferTexture;", "elementCount", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "session", "Lorg/openrndr/draw/Session;", "openrndr-draw"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BufferTexture create(int elementCount, @NotNull ColorFormat format, @NotNull ColorType type, @Nullable Session session) {
            BufferTexture bufferTexture;
            block0: {
                Intrinsics.checkNotNullParameter((Object)format, "format");
                Intrinsics.checkNotNullParameter((Object)type, "type");
                bufferTexture = Driver.DefaultImpls.createBufferTexture$default(Driver.Companion.getInstance(), elementCount, format, type, null, 8, null);
                Session session2 = session;
                if (session2 == null) break block0;
                session2.track(bufferTexture);
            }
            return bufferTexture;
        }

        public static /* synthetic */ BufferTexture create$default(Companion companion, int n, ColorFormat colorFormat, ColorType colorType, Session session, int n2, Object object) {
            if ((n2 & 2) != 0) {
                colorFormat = ColorFormat.RGBa;
            }
            if ((n2 & 4) != 0) {
                colorType = ColorType.FLOAT32;
            }
            if ((n2 & 8) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.create(n, colorFormat, colorType, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

