/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ImageData;
import org.openrndr.internal.ImageDriver;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aT\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001aX\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00112\b\b\u0002\u0010\u0016\u001a\u00020\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00112\b\b\u0002\u0010\u0019\u001a\u00020\u0011\u001aP\u0010\u001a\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0003\u001a2\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\""}, d2={"colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "width", "", "height", "contentScale", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "levels", "session", "Lorg/openrndr/draw/Session;", "isEquivalentTo", "", "other", "ignoreWidth", "ignoreHeight", "ignoreContentScale", "ignoreFormat", "ignoreType", "ignoreMultisample", "ignoreLevels", "createEquivalent", "loadImage", "buffer", "Lorg/openrndr/utils/buffer/MPPBuffer;", "name", "", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "openrndr-draw"})
public final class ColorBufferKt {
    @NotNull
    public static final ColorBuffer colorBuffer(int width, int height, double contentScale, @NotNull ColorFormat format, @NotNull ColorType type, @NotNull BufferMultisample multisample, int levels, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        return Driver.Companion.getInstance().createColorBuffer(width, height, contentScale, format, type, multisample, levels, session);
    }

    public static /* synthetic */ ColorBuffer colorBuffer$default(int n, int n2, double d, ColorFormat colorFormat, ColorType colorType, BufferMultisample bufferMultisample, int n3, Session session, int n4, Object object) {
        if ((n4 & 4) != 0) {
            d = 1.0;
        }
        if ((n4 & 8) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n4 & 0x10) != 0) {
            colorType = ColorType.UINT8;
        }
        if ((n4 & 0x20) != 0) {
            bufferMultisample = BufferMultisample.Disabled.INSTANCE;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x80) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferKt.colorBuffer(n, n2, d, colorFormat, colorType, bufferMultisample, n3, session);
    }

    public static final boolean isEquivalentTo(@NotNull ColorBuffer $this$isEquivalentTo, @NotNull ColorBuffer other, boolean ignoreWidth, boolean ignoreHeight, boolean ignoreContentScale, boolean ignoreFormat, boolean ignoreType, boolean ignoreMultisample, boolean ignoreLevels) {
        Intrinsics.checkNotNullParameter($this$isEquivalentTo, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return !(!ignoreWidth && $this$isEquivalentTo.getWidth() != other.getWidth() || !ignoreHeight && $this$isEquivalentTo.getHeight() != other.getHeight() || !ignoreContentScale && !($this$isEquivalentTo.getContentScale() == other.getContentScale()) || !ignoreFormat && $this$isEquivalentTo.getFormat() != other.getFormat() || !ignoreType && $this$isEquivalentTo.getType() != other.getType() || !ignoreMultisample && !Intrinsics.areEqual($this$isEquivalentTo.getMultisample(), other.getMultisample()) || !ignoreLevels && $this$isEquivalentTo.getLevels() != other.getLevels());
    }

    public static /* synthetic */ boolean isEquivalentTo$default(ColorBuffer colorBuffer, ColorBuffer colorBuffer2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            bl5 = false;
        }
        if ((n & 0x40) != 0) {
            bl6 = false;
        }
        if ((n & 0x80) != 0) {
            bl7 = false;
        }
        return ColorBufferKt.isEquivalentTo(colorBuffer, colorBuffer2, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    @NotNull
    public static final ColorBuffer createEquivalent(@NotNull ColorBuffer $this$createEquivalent, int width, int height, double contentScale, @NotNull ColorFormat format, @NotNull ColorType type, @NotNull BufferMultisample multisample, int levels) {
        Intrinsics.checkNotNullParameter($this$createEquivalent, "<this>");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        return ColorBufferKt.colorBuffer$default(width, height, contentScale, format, type, multisample, levels, null, 128, null);
    }

    public static /* synthetic */ ColorBuffer createEquivalent$default(ColorBuffer colorBuffer, int n, int n2, double d, ColorFormat colorFormat, ColorType colorType, BufferMultisample bufferMultisample, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = colorBuffer.getWidth();
        }
        if ((n4 & 2) != 0) {
            n2 = colorBuffer.getHeight();
        }
        if ((n4 & 4) != 0) {
            d = colorBuffer.getContentScale();
        }
        if ((n4 & 8) != 0) {
            colorFormat = colorBuffer.getFormat();
        }
        if ((n4 & 0x10) != 0) {
            colorType = colorBuffer.getType();
        }
        if ((n4 & 0x20) != 0) {
            bufferMultisample = colorBuffer.getMultisample();
        }
        if ((n4 & 0x40) != 0) {
            n3 = colorBuffer.getLevels();
        }
        return ColorBufferKt.createEquivalent(colorBuffer, n, n2, d, colorFormat, colorType, bufferMultisample, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ColorBuffer loadImage(@NotNull MPPBuffer buffer, @Nullable String name, @Nullable ImageFileFormat formatHint, @Nullable Session session) {
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        try (ImageData data = ImageDriver.Companion.getInstance().loadImage(buffer, name, formatHint);){
            ColorBuffer cb = ColorBufferKt.colorBuffer$default(data.getWidth(), data.getHeight(), 1.0, data.getFormat(), data.getType(), null, 0, session, 96, null);
            MPPBuffer mPPBuffer = data.getData();
            if (mPPBuffer == null) {
                throw new IllegalStateException("no data".toString());
            }
            ColorBuffer.write$default(cb, mPPBuffer, null, null, 0, 0, 0, 0, 0, 254, null);
            colorBuffer = cb;
        }
        return colorBuffer;
    }

    public static /* synthetic */ ColorBuffer loadImage$default(MPPBuffer mPPBuffer, String string, ImageFileFormat imageFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            imageFileFormat = null;
        }
        if ((n & 8) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferKt.loadImage(mPPBuffer, string, imageFileFormat, session);
    }
}

