/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferProxyKt;
import org.openrndr.events.Event;
import org.openrndr.internal.ColorBufferLoader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001:\u0003=>?B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000201J\u0006\u00103\u001a\u000201J\u0006\u00104\u001a\u000201J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\u0007H\u00c6\u0003J'\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u00109\u001a\u00020\u00072\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010;\u001a\u00020\u0015H\u00d6\u0001J\t\u0010<\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R*\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020!@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,\u00a8\u0006@"}, d2={"Lorg/openrndr/draw/ColorBufferProxy;", "", "url", "", "loader", "Lorg/openrndr/internal/ColorBufferLoader;", "persistent", "", "<init>", "(Ljava/lang/String;Lorg/openrndr/internal/ColorBufferLoader;Z)V", "getUrl", "()Ljava/lang/String;", "getLoader", "()Lorg/openrndr/internal/ColorBufferLoader;", "getPersistent", "()Z", "events", "Lorg/openrndr/draw/ColorBufferProxy$Events;", "getEvents", "()Lorg/openrndr/draw/ColorBufferProxy$Events;", "priority", "", "getPriority", "()I", "setPriority", "(I)V", "value", "Lorg/openrndr/draw/ColorBuffer;", "colorBuffer", "getColorBuffer", "()Lorg/openrndr/draw/ColorBuffer;", "setColorBuffer$openrndr_draw", "(Lorg/openrndr/draw/ColorBuffer;)V", "Lorg/openrndr/draw/ColorBufferProxy$State;", "state", "getState", "()Lorg/openrndr/draw/ColorBufferProxy$State;", "setState$openrndr_draw", "(Lorg/openrndr/draw/ColorBufferProxy$State;)V", "lastTouched", "", "getLastTouched$openrndr_draw", "()J", "setLastTouched$openrndr_draw", "(J)V", "lastTouchedShadow", "getLastTouchedShadow$openrndr_draw", "setLastTouchedShadow$openrndr_draw", "cancel", "", "queue", "touch", "retry", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "ProxyEvent", "Events", "State", "openrndr-draw"})
public final class ColorBufferProxy {
    @NotNull
    private final String url;
    @NotNull
    private final ColorBufferLoader loader;
    private final boolean persistent;
    @NotNull
    private final Events events;
    private int priority;
    @Nullable
    private ColorBuffer colorBuffer;
    @NotNull
    private State state;
    private long lastTouched;
    private long lastTouchedShadow;

    public ColorBufferProxy(@NotNull String url, @NotNull ColorBufferLoader loader, boolean persistent) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(loader, "loader");
        this.url = url;
        this.loader = loader;
        this.persistent = persistent;
        this.events = new Events();
        this.priority = 100;
        this.state = State.NOT_LOADED;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final ColorBufferLoader getLoader() {
        return this.loader;
    }

    public final boolean getPersistent() {
        return this.persistent;
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int n) {
        this.priority = n;
    }

    @Nullable
    public final ColorBuffer getColorBuffer() {
        this.lastTouched = System.currentTimeMillis();
        if (this.state == State.NOT_LOADED) {
            this.queue();
        }
        return this.colorBuffer;
    }

    public final void setColorBuffer$openrndr_draw(@Nullable ColorBuffer colorBuffer) {
        this.colorBuffer = colorBuffer;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState$openrndr_draw(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, "<set-?>");
        this.state = state;
    }

    public final long getLastTouched$openrndr_draw() {
        return this.lastTouched;
    }

    public final void setLastTouched$openrndr_draw(long l) {
        this.lastTouched = l;
    }

    public final long getLastTouchedShadow$openrndr_draw() {
        return this.lastTouchedShadow;
    }

    public final void setLastTouchedShadow$openrndr_draw(long l) {
        this.lastTouchedShadow = l;
    }

    public final void cancel() {
        this.touch();
        if (this.state == State.QUEUED) {
            this.loader.cancel(this);
            this.state = State.NOT_LOADED;
            ColorBufferProxyKt.access$getLogger$p().debug(() -> ColorBufferProxy.cancel$lambda$0(this));
        } else {
            ColorBufferProxyKt.access$getLogger$p().warn(() -> ColorBufferProxy.cancel$lambda$1(this));
        }
    }

    public final void queue() {
        this.touch();
        if (this.state == State.NOT_LOADED) {
            this.loader.queue(this);
            this.state = State.QUEUED;
        }
    }

    public final void touch() {
        this.lastTouched = System.currentTimeMillis();
    }

    public final void retry() {
        if (this.state == State.RETRY) {
            ColorBufferProxyKt.access$getLogger$p().debug(ColorBufferProxy::retry$lambda$2);
            this.state = State.NOT_LOADED;
        } else {
            ColorBufferProxyKt.access$getLogger$p().warn(ColorBufferProxy::retry$lambda$3);
        }
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final ColorBufferLoader component2() {
        return this.loader;
    }

    public final boolean component3() {
        return this.persistent;
    }

    @NotNull
    public final ColorBufferProxy copy(@NotNull String url, @NotNull ColorBufferLoader loader, boolean persistent) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(loader, "loader");
        return new ColorBufferProxy(url, loader, persistent);
    }

    public static /* synthetic */ ColorBufferProxy copy$default(ColorBufferProxy colorBufferProxy, String string, ColorBufferLoader colorBufferLoader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = colorBufferProxy.url;
        }
        if ((n & 2) != 0) {
            colorBufferLoader = colorBufferProxy.loader;
        }
        if ((n & 4) != 0) {
            bl = colorBufferProxy.persistent;
        }
        return colorBufferProxy.copy(string, colorBufferLoader, bl);
    }

    @NotNull
    public String toString() {
        return "ColorBufferProxy(url=" + this.url + ", loader=" + this.loader + ", persistent=" + this.persistent + ")";
    }

    public int hashCode() {
        int result2 = this.url.hashCode();
        result2 = result2 * 31 + this.loader.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.persistent);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorBufferProxy)) {
            return false;
        }
        ColorBufferProxy colorBufferProxy = (ColorBufferProxy)other;
        if (!Intrinsics.areEqual(this.url, colorBufferProxy.url)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.loader, colorBufferProxy.loader)) {
            return false;
        }
        return this.persistent == colorBufferProxy.persistent;
    }

    private static final Object cancel$lambda$0(ColorBufferProxy this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "canceled " + this$0;
    }

    private static final Object cancel$lambda$1(ColorBufferProxy this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "proxy is not queued, so it cannot be canceled: " + this$0;
    }

    private static final Object retry$lambda$2() {
        return "retry requested";
    }

    private static final Object retry$lambda$3() {
        return "proxy is not in retry";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/draw/ColorBufferProxy$Events;", "", "<init>", "()V", "loaded", "Lorg/openrndr/events/Event;", "Lorg/openrndr/draw/ColorBufferProxy$ProxyEvent;", "getLoaded", "()Lorg/openrndr/events/Event;", "unloaded", "getUnloaded", "retry", "getRetry", "error", "getError", "openrndr-draw"})
    public static final class Events {
        @NotNull
        private final Event<ProxyEvent> loaded = new Event("proxy-loaded", false);
        @NotNull
        private final Event<ProxyEvent> unloaded = new Event("proxy-unloaded", false);
        @NotNull
        private final Event<ProxyEvent> retry = new Event("proxy-retry", false);
        @NotNull
        private final Event<ProxyEvent> error = new Event("proxy-error", false);

        @NotNull
        public final Event<ProxyEvent> getLoaded() {
            return this.loaded;
        }

        @NotNull
        public final Event<ProxyEvent> getUnloaded() {
            return this.unloaded;
        }

        @NotNull
        public final Event<ProxyEvent> getRetry() {
            return this.retry;
        }

        @NotNull
        public final Event<ProxyEvent> getError() {
            return this.error;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/openrndr/draw/ColorBufferProxy$ProxyEvent;", "", "<init>", "()V", "openrndr-draw"})
    public static final class ProxyEvent {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/draw/ColorBufferProxy$State;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_LOADED", "QUEUED", "LOADED", "RETRY", "ERROR", "openrndr-draw"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_LOADED = new State();
        public static final /* enum */ State QUEUED = new State();
        public static final /* enum */ State LOADED = new State();
        public static final /* enum */ State RETRY = new State();
        public static final /* enum */ State ERROR = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_LOADED, State.QUEUED, State.LOADED, State.RETRY, State.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

