/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.Session;
import org.openrndr.internal.CubemapImageData;
import org.openrndr.internal.Driver;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u001a\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000e"}, d2={"cubemap", "Lorg/openrndr/draw/Cubemap;", "width", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "levels", "session", "Lorg/openrndr/draw/Session;", "loadCubemap", "data", "Lorg/openrndr/internal/CubemapImageData;", "openrndr-draw"})
@JvmName(name="CubemapFunctions")
public final class CubemapFunctions {
    @NotNull
    public static final Cubemap cubemap(int width, @NotNull ColorFormat format, @NotNull ColorType type, int levels, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        return Driver.Companion.getInstance().createCubemap(width, format, type, levels, session);
    }

    public static /* synthetic */ Cubemap cubemap$default(int n, ColorFormat colorFormat, ColorType colorType, int n2, Session session, int n3, Object object) {
        if ((n3 & 2) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n3 & 4) != 0) {
            colorType = ColorType.UINT8;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        if ((n3 & 0x10) != 0) {
            session = Session.Companion.getActive();
        }
        return CubemapFunctions.cubemap(n, colorFormat, colorType, n2, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Cubemap loadCubemap(@NotNull CubemapImageData data, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(data, "data");
        try {
            Cubemap cm = CubemapFunctions.cubemap(data.getWidth(), data.getFormat(), data.getType(), data.getMipmaps(), session);
            int n = data.getMipmaps();
            for (int level = 0; level < n; ++level) {
                int levelWidth = data.getWidth() / (1 << level);
                for (CubemapSide side : CubemapSide.getEntries()) {
                    cm.write(side, data.side(side, level), data.getFormat(), data.getType(), 0, 0, levelWidth, levelWidth, level);
                }
            }
            if (data.getMipmaps() == 1) {
                cm.generateMipmaps();
            }
            cm.filter(MinifyingFilter.LINEAR_MIPMAP_LINEAR, MagnifyingFilter.LINEAR);
            Cubemap cubemap = cm;
            return cubemap;
        }
        finally {
            data.close();
        }
    }

    public static /* synthetic */ Cubemap loadCubemap$default(CubemapImageData cubemapImageData, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            session = Session.Companion.getActive();
        }
        return CubemapFunctions.loadCubemap(cubemapImageData, session);
    }
}

