/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.CharacterPair;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.FontImageMapDescriptor;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.FontMapKt;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.internal.Driver;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ,2\u00020\u0001:\u0001,Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000e\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\r\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0014\u0010\u000f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0014\u0010\u0010\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001d\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u000b0$\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/openrndr/draw/FontImageMap;", "Lorg/openrndr/draw/FontMap;", "texture", "Lorg/openrndr/draw/ColorBuffer;", "map", "", "", "Lorg/openrndr/shape/IntRectangle;", "glyphMetrics", "Lorg/openrndr/draw/GlyphMetrics;", "size", "", "contentScale", "ascenderLength", "descenderLength", "height", "leading", "name", "", "<init>", "(Lorg/openrndr/draw/ColorBuffer;Ljava/util/Map;Ljava/util/Map;DDDDDDLjava/lang/String;)V", "getTexture", "()Lorg/openrndr/draw/ColorBuffer;", "getMap", "()Ljava/util/Map;", "getGlyphMetrics", "getSize", "()D", "getContentScale", "getAscenderLength", "getDescenderLength", "getHeight", "getLeading", "getName", "()Ljava/lang/String;", "kerningTable", "", "Lorg/openrndr/draw/CharacterPair;", "getKerningTable", "characterWidth", "character", "kerning", "left", "right", "Companion", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nFontMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontMap.kt\norg/openrndr/draw/FontImageMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class FontImageMap
extends FontMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorBuffer texture;
    @NotNull
    private final Map<Character, IntRectangle> map;
    @NotNull
    private final Map<Character, GlyphMetrics> glyphMetrics;
    private final double size;
    private final double contentScale;
    private final double ascenderLength;
    private final double descenderLength;
    private final double height;
    private final double leading;
    @NotNull
    private final String name;
    @NotNull
    private final Map<CharacterPair, Double> kerningTable;

    public FontImageMap(@NotNull ColorBuffer texture, @NotNull Map<Character, IntRectangle> map2, @NotNull Map<Character, GlyphMetrics> glyphMetrics, double size, double contentScale, double ascenderLength, double descenderLength, double height, double leading, @NotNull String name) {
        Intrinsics.checkNotNullParameter(texture, "texture");
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter(glyphMetrics, "glyphMetrics");
        Intrinsics.checkNotNullParameter(name, "name");
        this.texture = texture;
        this.map = map2;
        this.glyphMetrics = glyphMetrics;
        this.size = size;
        this.contentScale = contentScale;
        this.ascenderLength = ascenderLength;
        this.descenderLength = descenderLength;
        this.height = height;
        this.leading = leading;
        this.name = name;
        this.kerningTable = new LinkedHashMap();
    }

    @NotNull
    public final ColorBuffer getTexture() {
        return this.texture;
    }

    @NotNull
    public final Map<Character, IntRectangle> getMap() {
        return this.map;
    }

    @NotNull
    public final Map<Character, GlyphMetrics> getGlyphMetrics() {
        return this.glyphMetrics;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    public final double getContentScale() {
        return this.contentScale;
    }

    @Override
    public double getAscenderLength() {
        return this.ascenderLength;
    }

    @Override
    public double getDescenderLength() {
        return this.descenderLength;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getLeading() {
        return this.leading;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Map<CharacterPair, Double> getKerningTable() {
        return this.kerningTable;
    }

    public final double characterWidth(char character) {
        IntRectangle intRectangle = this.map.get(Character.valueOf(character));
        return intRectangle != null ? (double)intRectangle.width() : 0.0;
    }

    public final double kerning(char left, char right) {
        Map<CharacterPair, Double> map2 = this.kerningTable;
        Double d = map2.get(new CharacterPair(left, right));
        if (d == null) {
            boolean bl = false;
            d = 0.0;
        }
        return ((Number)d).doubleValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\tJ0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/draw/FontImageMap$Companion;", "", "<init>", "()V", "fromUrl", "Lorg/openrndr/draw/FontImageMap;", "fontUrl", "", "size", "", "characterSet", "", "", "contentScale", "fromFile", "file", "openrndr-draw"})
    @SourceDebugExtension(value={"SMAP\nFontMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontMap.kt\norg/openrndr/draw/FontImageMap$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,102:1\n381#2,7:103\n381#2,7:110\n*S KotlinDebug\n*F\n+ 1 FontMap.kt\norg/openrndr/draw/FontImageMap$Companion\n*L\n72#1:103,7\n77#1:110,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FontImageMap fromUrl(@NotNull String fontUrl, double size, @NotNull Set<Character> characterSet, double contentScale) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(fontUrl, "fontUrl");
            Intrinsics.checkNotNullParameter(characterSet, "characterSet");
            Map map2 = FontMapKt.access$getFontImageMaps$p();
            FontImageMapDescriptor key$iv = new FontImageMapDescriptor(fontUrl, size, characterSet, contentScale);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                FontImageMap answer$iv = Driver.Companion.getInstance().getFontImageMapManager().fontMapFromUrl(fontUrl, size, characterSet, contentScale);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (FontImageMap)object;
        }

        public static /* synthetic */ FontImageMap fromUrl$default(Companion companion, String string, double d, Set set, double d2, int n, Object object) {
            if ((n & 4) != 0) {
                set = FontMapKt.getDefaultFontmapCharacterSet();
            }
            if ((n & 8) != 0) {
                d2 = 1.0;
            }
            return companion.fromUrl(string, d, set, d2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FontImageMap fromFile(@NotNull String file, double size, @NotNull Set<Character> characterSet, double contentScale) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(characterSet, "characterSet");
            Map map2 = FontMapKt.access$getFontImageMaps$p();
            FontImageMapDescriptor key$iv = new FontImageMapDescriptor("file:" + file, size, characterSet, contentScale);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                FontImageMap answer$iv = Driver.Companion.getInstance().getFontImageMapManager().fontMapFromUrl("file:" + file, size, characterSet, contentScale);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (FontImageMap)object;
        }

        public static /* synthetic */ FontImageMap fromFile$default(Companion companion, String string, double d, Set set, double d2, int n, Object object) {
            if ((n & 4) != 0) {
                set = FontMapKt.getDefaultFontmapCharacterSet();
            }
            if ((n & 8) != 0) {
                d2 = 1.0;
            }
            return companion.fromFile(string, d, set, d2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

