/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMapKt;
import org.openrndr.draw.RenderTarget;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0007\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\f\u001a\u0004\u0018\u00010\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "loadFont", "Lorg/openrndr/draw/FontImageMap;", "fileOrUrl", "", "size", "", "characterSet", "", "", "contentScale", "defaultFontMap", "getDefaultFontMap", "()Lorg/openrndr/draw/FontImageMap;", "defaultFontMap$delegate", "Lkotlin/Lazy;", "openrndr-draw"})
@JvmName(name="FontMapJVM")
public final class FontMapJVM {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(FontMapJVM::logger$lambda$0);
    @NotNull
    private static final Lazy defaultFontMap$delegate = LazyKt.lazy(FontMapJVM::defaultFontMap_delegate$lambda$3);

    @NotNull
    public static final FontImageMap loadFont(@NotNull String fileOrUrl, double size, @NotNull Set<Character> characterSet, double contentScale) {
        FontImageMap fontImageMap;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        Intrinsics.checkNotNullParameter(characterSet, "characterSet");
        Set<Character> activeSet = characterSet.contains(Character.valueOf(' ')) ? characterSet : SetsKt.plus(characterSet, Character.valueOf(' '));
        try {
            new URL(fileOrUrl);
            fontImageMap = FontImageMap.Companion.fromUrl(fileOrUrl, size, activeSet, contentScale);
        }
        catch (MalformedURLException e) {
            File file = new File(fileOrUrl);
            if (!file.exists()) {
                boolean $i$a$-require-FontMapJVM$loadFont$32 = false;
                String $i$a$-require-FontMapJVM$loadFont$32 = "failed to load font: file '" + file.getAbsolutePath() + "' does not exist.";
                throw new IllegalArgumentException($i$a$-require-FontMapJVM$loadFont$32.toString());
            }
            String[] stringArray = new String[]{"ttf", "otf"};
            Set<String> set = SetsKt.setOf(stringArray);
            String string = FilesKt.getExtension(file).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            if (!set.contains(string)) {
                boolean bl = false;
                String string2 = "failed to load font: file '" + file.getAbsolutePath() + "' is not a .ttf or .otf file";
                throw new IllegalArgumentException(string2.toString());
            }
            fontImageMap = FontImageMap.Companion.fromFile(fileOrUrl, size, activeSet, contentScale);
        }
        return fontImageMap;
    }

    public static /* synthetic */ FontImageMap loadFont$default(String string, double d, Set set, double d2, int n, Object object) {
        if ((n & 4) != 0) {
            set = FontMapKt.getDefaultFontmapCharacterSet();
        }
        if ((n & 8) != 0) {
            d2 = 1.0;
        }
        return FontMapJVM.loadFont(string, d, set, d2);
    }

    @Nullable
    public static final FontImageMap getDefaultFontMap() {
        Lazy lazy = defaultFontMap$delegate;
        return (FontImageMap)lazy.getValue();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final FontImageMap defaultFontMap_delegate$lambda$3() {
        FontImageMap fontImageMap;
        File defaultFontPath = new File("data/fonts/default.otf");
        if (defaultFontPath.isFile()) {
            logger.info("loading default font from " + defaultFontPath.getAbsolutePath());
            String string = defaultFontPath.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            fontImageMap = FontMapJVM.loadFont$default(string, 16.0, null, RenderTarget.Companion.getActive().getContentScale(), 4, null);
        } else {
            logger.warn("default font " + defaultFontPath.getAbsolutePath() + " not found");
            fontImageMap = null;
        }
        return fontImageMap;
    }
}

