/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BatchBuilder;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.PointBatch;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0013J\u001b\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0007\u00a2\u0006\u0002\b\u0017J\u001b\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0007\u00a2\u0006\u0002\b\u0018J\u0012\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001aR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/draw/PointBatchBuilder;", "Lorg/openrndr/draw/BatchBuilder;", "drawer", "Lorg/openrndr/draw/Drawer;", "<init>", "(Lorg/openrndr/draw/Drawer;)V", "entries", "", "Lorg/openrndr/draw/PointBatchBuilder$Entry;", "getEntries", "()Ljava/util/List;", "point", "", "x", "", "y", "z", "position", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "points", "positions", "", "points3D", "points2D", "batch", "Lorg/openrndr/draw/PointBatch;", "existingBatch", "Entry", "openrndr-draw"})
public final class PointBatchBuilder
extends BatchBuilder {
    @NotNull
    private final List<Entry> entries;

    public PointBatchBuilder(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        super(drawer);
        this.entries = new ArrayList();
    }

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    public final void point(double x, double y) {
        this.entries.add(new Entry(this.getFill(), new Vector3(x, y, 0.0)));
    }

    public final void point(double x, double y, double z) {
        this.entries.add(new Entry(this.getFill(), new Vector3(x, y, z)));
    }

    public final void point(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.entries.add(new Entry(this.getFill(), position.xy0()));
    }

    public final void point(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.entries.add(new Entry(this.getFill(), position));
    }

    @JvmName(name="points3D")
    public final void points3D(@NotNull List<Vector3> positions) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        for (Vector3 position : positions) {
            this.point(position);
        }
    }

    @JvmName(name="points2D")
    public final void points2D(@NotNull List<Vector2> positions) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        for (Vector2 position : positions) {
            this.point(position);
        }
    }

    @NotNull
    public final PointBatch batch(@Nullable PointBatch existingBatch) {
        Object object = existingBatch;
        if (object == null || (object = ((PointBatch)object).getGeometry()) == null) {
            object = VertexBufferKt.vertexBuffer$default(BatchesKt.getPointFormat(), this.entries.size(), null, 4, null);
        }
        Object geometry = object;
        VertexBuffer.put$default((VertexBuffer)geometry, 0, arg_0 -> PointBatchBuilder.batch$lambda$0(this, arg_0), 1, null);
        Object object2 = existingBatch;
        if (object2 == null || (object2 = ((PointBatch)object2).getDrawStyle()) == null) {
            object2 = VertexBufferKt.vertexBuffer$default(BatchesKt.getDrawStyleFormat(), this.entries.size(), null, 4, null);
        }
        Object drawStyle = object2;
        VertexBuffer.put$default((VertexBuffer)drawStyle, 0, arg_0 -> PointBatchBuilder.batch$lambda$1(this, arg_0), 1, null);
        PointBatch pointBatch = existingBatch;
        if (pointBatch == null) {
            pointBatch = new PointBatch((VertexBuffer)geometry, (VertexBuffer)drawStyle);
        }
        return pointBatch;
    }

    public static /* synthetic */ PointBatch batch$default(PointBatchBuilder pointBatchBuilder, PointBatch pointBatch, int n, Object object) {
        if ((n & 1) != 0) {
            pointBatch = null;
        }
        return pointBatchBuilder.batch(pointBatch);
    }

    private static final Unit batch$lambda$0(PointBatchBuilder this$0, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (Entry entry : this$0.entries) {
            $this$put.write(entry.getOffset());
        }
        return Unit.INSTANCE;
    }

    private static final Unit batch$lambda$1(PointBatchBuilder this$0, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (Entry entry : this$0.entries) {
            ColorRGBa colorRGBa = entry.getFill();
            if (colorRGBa == null) {
                colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
            }
            $this$put.write(colorRGBa);
            ColorRGBa colorRGBa2 = entry.getFill();
            if (colorRGBa2 == null) {
                colorRGBa2 = ColorRGBa.Companion.getTRANSPARENT();
            }
            $this$put.write(colorRGBa2);
            $this$put.write(1.0f);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/openrndr/draw/PointBatchBuilder$Entry;", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "offset", "Lorg/openrndr/math/Vector3;", "<init>", "(Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/math/Vector3;)V", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getOffset", "()Lorg/openrndr/math/Vector3;", "openrndr-draw"})
    public static final class Entry {
        @Nullable
        private final ColorRGBa fill;
        @NotNull
        private final Vector3 offset;

        public Entry(@Nullable ColorRGBa fill, @NotNull Vector3 offset) {
            Intrinsics.checkNotNullParameter(offset, "offset");
            this.fill = fill;
            this.offset = offset;
        }

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @NotNull
        public final Vector3 getOffset() {
            return this.offset;
        }
    }
}

