/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BatchBuilder;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RectangleBatch;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u000eJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u000eJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\u000eJ\u0014\u0010\u0016\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017J\u0012\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0019R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/draw/RectangleBatchBuilder;", "Lorg/openrndr/draw/BatchBuilder;", "drawer", "Lorg/openrndr/draw/Drawer;", "<init>", "(Lorg/openrndr/draw/Drawer;)V", "entries", "", "Lorg/openrndr/draw/RectangleBatchBuilder$Entry;", "getEntries", "()Ljava/util/List;", "rectangle", "", "x", "", "y", "width", "height", "rotationInDegrees", "corner", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/Rectangle;", "rectangles", "", "batch", "Lorg/openrndr/draw/RectangleBatch;", "existingBatch", "Entry", "openrndr-draw"})
public final class RectangleBatchBuilder
extends BatchBuilder {
    @NotNull
    private final List<Entry> entries;

    public RectangleBatchBuilder(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        super(drawer);
        this.entries = new ArrayList();
    }

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    public final void rectangle(double x, double y, double width, double height, double rotationInDegrees) {
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), new Vector3(x, y, 0.0), new Vector2(width, height), rotationInDegrees));
    }

    public static /* synthetic */ void rectangle$default(RectangleBatchBuilder rectangleBatchBuilder, double d, double d2, double d3, double d4, double d5, int n, Object object) {
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        rectangleBatchBuilder.rectangle(d, d2, d3, d4, d5);
    }

    public final void rectangle(@NotNull Vector2 corner, double width, double height, double rotationInDegrees) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), corner.xy0(), new Vector2(width, height), rotationInDegrees));
    }

    public static /* synthetic */ void rectangle$default(RectangleBatchBuilder rectangleBatchBuilder, Vector2 vector2, double d, double d2, double d3, int n, Object object) {
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        rectangleBatchBuilder.rectangle(vector2, d, d2, d3);
    }

    public final void rectangle(@NotNull Rectangle rectangle, double rotationInDegrees) {
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), rectangle.corner().xy0(), new Vector2(rectangle.width(), rectangle.height()), rotationInDegrees));
    }

    public static /* synthetic */ void rectangle$default(RectangleBatchBuilder rectangleBatchBuilder, Rectangle rectangle, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        rectangleBatchBuilder.rectangle(rectangle, d);
    }

    public final void rectangles(@NotNull List<Rectangle> rectangles) {
        Intrinsics.checkNotNullParameter(rectangles, "rectangles");
        for (Rectangle rectangle : rectangles) {
            RectangleBatchBuilder.rectangle$default(this, rectangle, 0.0, 2, null);
        }
    }

    @NotNull
    public final RectangleBatch batch(@Nullable RectangleBatch existingBatch) {
        Object object = existingBatch;
        if (object == null || (object = ((RectangleBatch)object).getGeometry()) == null) {
            object = VertexBufferKt.vertexBuffer$default(BatchesKt.getRectangleFormat(), this.entries.size(), null, 4, null);
        }
        Object geometry = object;
        VertexBuffer.put$default((VertexBuffer)geometry, 0, arg_0 -> RectangleBatchBuilder.batch$lambda$0(this, arg_0), 1, null);
        Object object2 = existingBatch;
        if (object2 == null || (object2 = ((RectangleBatch)object2).getDrawStyle()) == null) {
            object2 = VertexBufferKt.vertexBuffer$default(BatchesKt.getDrawStyleFormat(), this.entries.size(), null, 4, null);
        }
        Object drawStyle = object2;
        VertexBuffer.put$default((VertexBuffer)drawStyle, 0, arg_0 -> RectangleBatchBuilder.batch$lambda$1(this, arg_0), 1, null);
        RectangleBatch rectangleBatch = existingBatch;
        if (rectangleBatch == null) {
            rectangleBatch = new RectangleBatch((VertexBuffer)geometry, (VertexBuffer)drawStyle);
        }
        return rectangleBatch;
    }

    public static /* synthetic */ RectangleBatch batch$default(RectangleBatchBuilder rectangleBatchBuilder, RectangleBatch rectangleBatch, int n, Object object) {
        if ((n & 1) != 0) {
            rectangleBatch = null;
        }
        return rectangleBatchBuilder.batch(rectangleBatch);
    }

    private static final Unit batch$lambda$0(RectangleBatchBuilder this$0, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (Entry entry : this$0.entries) {
            $this$put.write(entry.getOffset());
            $this$put.write(entry.getDimensions());
            $this$put.write((float)entry.getRotation());
        }
        return Unit.INSTANCE;
    }

    private static final Unit batch$lambda$1(RectangleBatchBuilder this$0, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (Entry entry : this$0.entries) {
            ColorRGBa colorRGBa = entry.getFill();
            if (colorRGBa == null) {
                colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
            }
            $this$put.write(colorRGBa);
            ColorRGBa colorRGBa2 = entry.getStroke();
            if (colorRGBa2 == null) {
                colorRGBa2 = ColorRGBa.Companion.getTRANSPARENT();
            }
            $this$put.write(colorRGBa2);
            $this$put.write(entry.getStroke() == null ? 0.0f : (float)entry.getStrokeWeight());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/draw/RectangleBatchBuilder$Entry;", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "stroke", "strokeWeight", "", "offset", "Lorg/openrndr/math/Vector3;", "dimensions", "Lorg/openrndr/math/Vector2;", "rotation", "<init>", "(Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/color/ColorRGBa;DLorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector2;D)V", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getStroke", "getStrokeWeight", "()D", "getOffset", "()Lorg/openrndr/math/Vector3;", "getDimensions", "()Lorg/openrndr/math/Vector2;", "getRotation", "openrndr-draw"})
    public static final class Entry {
        @Nullable
        private final ColorRGBa fill;
        @Nullable
        private final ColorRGBa stroke;
        private final double strokeWeight;
        @NotNull
        private final Vector3 offset;
        @NotNull
        private final Vector2 dimensions;
        private final double rotation;

        public Entry(@Nullable ColorRGBa fill, @Nullable ColorRGBa stroke, double strokeWeight, @NotNull Vector3 offset, @NotNull Vector2 dimensions, double rotation) {
            Intrinsics.checkNotNullParameter(offset, "offset");
            Intrinsics.checkNotNullParameter(dimensions, "dimensions");
            this.fill = fill;
            this.stroke = stroke;
            this.strokeWeight = strokeWeight;
            this.offset = offset;
            this.dimensions = dimensions;
            this.rotation = rotation;
        }

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @Nullable
        public final ColorRGBa getStroke() {
            return this.stroke;
        }

        public final double getStrokeWeight() {
            return this.strokeWeight;
        }

        @NotNull
        public final Vector3 getOffset() {
            return this.offset;
        }

        @NotNull
        public final Vector2 getDimensions() {
            return this.dimensions;
        }

        public final double getRotation() {
            return this.rotation;
        }
    }
}

