/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayCubemap;
import org.openrndr.draw.ArrayTexture;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorAttachment;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferAttachment;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.Session;
import org.openrndr.draw.VolumeTexture;
import org.openrndr.internal.Driver;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\bf\u0018\u0000 T2\u00020\u0001:\u0001TJ\u0017\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J&\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J\u0010\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'H&J.\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00072\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J6\u0010*\u001a\u00020+2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00101\u001a\u00020\u00072\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J.\u0010*\u001a\u00020+2\u0006\u00106\u001a\u0002072\u0006\u00104\u001a\u0002052\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J.\u0010*\u001a\u00020+2\u0006\u00108\u001a\u0002092\u0006\u00101\u001a\u00020\u00072\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J&\u0010:\u001a\u00020+2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J&\u0010:\u001a\u00020+2\u0006\u00102\u001a\u0002032\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J&\u0010:\u001a\u00020+2\u0006\u00106\u001a\u0002072\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J&\u0010:\u001a\u00020+2\u0006\u00108\u001a\u0002092\b\b\u0002\u0010.\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H&J\b\u0010;\u001a\u00020+H&J\b\u0010<\u001a\u00020+H'J\b\u0010=\u001a\u00020+H&J\b\u0010>\u001a\u00020+H&J\u0010\u0010,\u001a\u00020-2\u0006\u0010?\u001a\u00020\u0007H&J\u0018\u0010@\u001a\u00020+2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010A\u001a\u00020BH&J\u001c\u0010C\u001a\u00020+2\b\b\u0002\u0010D\u001a\u00020\r2\b\b\u0002\u0010E\u001a\u00020\u0007H&J\u0018\u0010F\u001a\u00020+2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010F\u001a\u00020GH&J\b\u0010H\u001a\u00020+H&J\b\u0010I\u001a\u00020+H&J\u0010\u0010R\u001a\u00020+2\u0006\u0010S\u001a\u00020\u0000H\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u0014\u0010\u001a\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\tR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010&\u001a\u0004\u0018\u00010'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0012\u0010J\u001a\u00020KX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0012\u0010N\u001a\u00020KX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010MR\u0012\u0010P\u001a\u00020KX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010M\u00a8\u0006U"}, d2={"Lorg/openrndr/draw/RenderTarget;", "", "session", "Lorg/openrndr/draw/Session;", "getSession", "()Lorg/openrndr/draw/Session;", "width", "", "getWidth", "()I", "height", "getHeight", "contentScale", "", "getContentScale", "()D", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "effectiveWidth", "getEffectiveWidth", "pixelWidth", "getPixelWidth", "effectiveHeight", "getEffectiveHeight", "pixelHeight", "getPixelHeight", "colorAttachments", "", "Lorg/openrndr/draw/ColorAttachment;", "getColorAttachments", "()Ljava/util/List;", "colorAttachmentIndexByName", "name", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "colorAttachmentByName", "depthBuffer", "Lorg/openrndr/draw/DepthBuffer;", "getDepthBuffer", "()Lorg/openrndr/draw/DepthBuffer;", "attach", "", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "level", "arrayTexture", "Lorg/openrndr/draw/ArrayTexture;", "layer", "arrayCubemap", "Lorg/openrndr/draw/ArrayCubemap;", "side", "Lorg/openrndr/draw/CubemapSide;", "cubemap", "Lorg/openrndr/draw/Cubemap;", "volumeTexture", "Lorg/openrndr/draw/VolumeTexture;", "attachLayered", "detachColorAttachments", "detachColorBuffers", "detachDepthBuffer", "destroy", "index", "clearColor", "color", "Lorg/openrndr/color/ColorRGBa;", "clearDepth", "depth", "stencil", "blendMode", "Lorg/openrndr/draw/BlendMode;", "bind", "unbind", "hasDepthBuffer", "", "getHasDepthBuffer", "()Z", "hasStencilBuffer", "getHasStencilBuffer", "hasColorAttachments", "getHasColorAttachments", "resolveTo", "to", "Companion", "openrndr-draw"})
public interface RenderTarget {
    @NotNull
    public static final Companion Companion = org.openrndr.draw.RenderTarget$Companion.$$INSTANCE;

    @Nullable
    public Session getSession();

    public int getWidth();

    public int getHeight();

    public double getContentScale();

    @NotNull
    public BufferMultisample getMultisample();

    public int getEffectiveWidth();

    public int getPixelWidth();

    public int getEffectiveHeight();

    public int getPixelHeight();

    @NotNull
    public List<ColorAttachment> getColorAttachments();

    @Nullable
    public Integer colorAttachmentIndexByName(@NotNull String var1);

    @Nullable
    public ColorAttachment colorAttachmentByName(@NotNull String var1);

    @Nullable
    public DepthBuffer getDepthBuffer();

    public void attach(@NotNull ColorBuffer var1, int var2, @Nullable String var3);

    public void attach(@NotNull DepthBuffer var1);

    public void attach(@NotNull ArrayTexture var1, int var2, int var3, @Nullable String var4);

    public void attach(@NotNull ArrayCubemap var1, @NotNull CubemapSide var2, int var3, int var4, @Nullable String var5);

    public void attach(@NotNull Cubemap var1, @NotNull CubemapSide var2, int var3, @Nullable String var4);

    public void attach(@NotNull VolumeTexture var1, int var2, int var3, @Nullable String var4);

    public void attachLayered(@NotNull ArrayTexture var1, int var2, @Nullable String var3);

    public void attachLayered(@NotNull ArrayCubemap var1, int var2, @Nullable String var3);

    public void attachLayered(@NotNull Cubemap var1, int var2, @Nullable String var3);

    public void attachLayered(@NotNull VolumeTexture var1, int var2, @Nullable String var3);

    public void detachColorAttachments();

    @Deprecated(message="detachColorBuffer is deprecated, use detachColorAttachments", replaceWith=@ReplaceWith(expression="detachColorAttachments", imports={}))
    public void detachColorBuffers();

    public void detachDepthBuffer();

    public void destroy();

    @NotNull
    public ColorBuffer colorBuffer(int var1);

    public void clearColor(int var1, @NotNull ColorRGBa var2);

    public void clearDepth(double var1, int var3);

    public void blendMode(int var1, @NotNull BlendMode var2);

    public void bind();

    public void unbind();

    public boolean getHasDepthBuffer();

    public boolean getHasStencilBuffer();

    public boolean getHasColorAttachments();

    public void resolveTo(@NotNull RenderTarget var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/draw/RenderTarget$Companion;", "", "<init>", "()V", "active", "Lorg/openrndr/draw/RenderTarget;", "getActive", "()Lorg/openrndr/draw/RenderTarget;", "openrndr-draw"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final RenderTarget getActive() {
            return Driver.Companion.getInstance().getActiveRenderTarget();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nRenderTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderTarget.kt\norg/openrndr/draw/RenderTarget$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1#2:437\n*E\n"})
    public static final class DefaultImpls {
        public static int getEffectiveWidth(@NotNull RenderTarget $this) {
            return (int)((double)$this.getWidth() * $this.getContentScale());
        }

        public static int getPixelWidth(@NotNull RenderTarget $this) {
            return (int)((double)$this.getWidth() * $this.getContentScale());
        }

        public static int getEffectiveHeight(@NotNull RenderTarget $this) {
            return (int)((double)$this.getHeight() * $this.getContentScale());
        }

        public static int getPixelHeight(@NotNull RenderTarget $this) {
            return (int)((double)$this.getHeight() * $this.getContentScale());
        }

        @Nullable
        public static Integer colorAttachmentIndexByName(@NotNull RenderTarget $this, @NotNull String name) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(name, "name");
                Iterable iterable = $this.getColorAttachments();
                for (Object t : iterable) {
                    ColorAttachment it = (ColorAttachment)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            ColorAttachment colorAttachment = v0;
            return colorAttachment != null ? Integer.valueOf(colorAttachment.getIndex()) : null;
        }

        @Nullable
        public static ColorAttachment colorAttachmentByName(@NotNull RenderTarget $this, @NotNull String name) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(name, "name");
                Iterable iterable = $this.getColorAttachments();
                for (Object t : iterable) {
                    ColorAttachment it = (ColorAttachment)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public static /* synthetic */ void attach$default(RenderTarget renderTarget, ColorBuffer colorBuffer, int n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attach");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                string = null;
            }
            renderTarget.attach(colorBuffer, n, string);
        }

        public static /* synthetic */ void attach$default(RenderTarget renderTarget, ArrayTexture arrayTexture, int n, int n2, String string, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attach");
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            if ((n3 & 8) != 0) {
                string = null;
            }
            renderTarget.attach(arrayTexture, n, n2, string);
        }

        public static /* synthetic */ void attach$default(RenderTarget renderTarget, ArrayCubemap arrayCubemap, CubemapSide cubemapSide, int n, int n2, String string, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attach");
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            if ((n3 & 0x10) != 0) {
                string = null;
            }
            renderTarget.attach(arrayCubemap, cubemapSide, n, n2, string);
        }

        public static /* synthetic */ void attach$default(RenderTarget renderTarget, Cubemap cubemap, CubemapSide cubemapSide, int n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attach");
            }
            if ((n2 & 4) != 0) {
                n = 0;
            }
            if ((n2 & 8) != 0) {
                string = null;
            }
            renderTarget.attach(cubemap, cubemapSide, n, string);
        }

        public static /* synthetic */ void attach$default(RenderTarget renderTarget, VolumeTexture volumeTexture, int n, int n2, String string, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attach");
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            if ((n3 & 8) != 0) {
                string = null;
            }
            renderTarget.attach(volumeTexture, n, n2, string);
        }

        public static /* synthetic */ void attachLayered$default(RenderTarget renderTarget, ArrayTexture arrayTexture, int n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attachLayered");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                string = null;
            }
            renderTarget.attachLayered(arrayTexture, n, string);
        }

        public static /* synthetic */ void attachLayered$default(RenderTarget renderTarget, ArrayCubemap arrayCubemap, int n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attachLayered");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                string = null;
            }
            renderTarget.attachLayered(arrayCubemap, n, string);
        }

        public static /* synthetic */ void attachLayered$default(RenderTarget renderTarget, Cubemap cubemap, int n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attachLayered");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                string = null;
            }
            renderTarget.attachLayered(cubemap, n, string);
        }

        public static /* synthetic */ void attachLayered$default(RenderTarget renderTarget, VolumeTexture volumeTexture, int n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: attachLayered");
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                string = null;
            }
            renderTarget.attachLayered(volumeTexture, n, string);
        }

        public static /* synthetic */ void clearDepth$default(RenderTarget renderTarget, double d, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clearDepth");
            }
            if ((n2 & 1) != 0) {
                d = 1.0;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            renderTarget.clearDepth(d, n);
        }

        public static void resolveTo(@NotNull RenderTarget $this, @NotNull RenderTarget to) {
            block4: {
                Intrinsics.checkNotNullParameter(to, "to");
                if (!($this.getWidth() == to.getWidth() && $this.getHeight() == to.getHeight())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!($this.getColorAttachments().size() == to.getColorAttachments().size())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(to.getDepthBuffer() == null == ($this.getDepthBuffer() == null))) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int n = ((Collection)$this.getColorAttachments()).size();
                for (int i = 0; i < n; ++i) {
                    ColorAttachment a = $this.getColorAttachments().get(i);
                    if (!(a instanceof ColorBufferAttachment)) continue;
                    IntRectangle sourceRectangle = IntRectangleKt.IntRectangle(0, 0, $this.getEffectiveWidth() / 1, $this.getEffectiveHeight() / 1);
                    IntRectangle targetRectangle = IntRectangleKt.IntRectangle(0, 0, sourceRectangle.width(), sourceRectangle.height());
                    ColorBuffer colorBuffer = ((ColorBufferAttachment)a).getColorBuffer();
                    ColorAttachment colorAttachment = to.getColorAttachments().get(i);
                    Intrinsics.checkNotNull(colorAttachment, "null cannot be cast to non-null type org.openrndr.draw.ColorBufferAttachment");
                    ColorBuffer.copyTo$default(colorBuffer, ((ColorBufferAttachment)colorAttachment).getColorBuffer(), 0, 0, sourceRectangle, targetRectangle, null, 38, null);
                }
                DepthBuffer depthBuffer = $this.getDepthBuffer();
                if (depthBuffer == null) break block4;
                DepthBuffer depthBuffer2 = to.getDepthBuffer();
                Intrinsics.checkNotNull(depthBuffer2);
                depthBuffer.resolveTo(depthBuffer2);
            }
        }
    }
}

