/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorAttachment;
import org.openrndr.draw.ColorBufferAttachment;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001BN\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u001a\u001a\u00020\u000e2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0006R\"\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/draw/ResizableRenderTarget;", "", "width", "", "height", "contentScale", "", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "session", "Lorg/openrndr/draw/Session;", "builder", "Lkotlin/Function1;", "Lorg/openrndr/draw/RenderTargetBuilder;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(IIDLorg/openrndr/draw/BufferMultisample;Lorg/openrndr/draw/Session;Lkotlin/jvm/functions/Function1;)V", "getBuilder", "()Lkotlin/jvm/functions/Function1;", "renderTarget", "Lorg/openrndr/draw/RenderTarget;", "getRenderTarget", "()Lorg/openrndr/draw/RenderTarget;", "setRenderTarget", "(Lorg/openrndr/draw/RenderTarget;)V", "resize", "newWidth", "newHeight", "newContentScale", "openrndr-draw"})
public final class ResizableRenderTarget {
    @NotNull
    private final Function1<RenderTargetBuilder, Unit> builder;
    @NotNull
    private RenderTarget renderTarget;

    public ResizableRenderTarget(int width, int height, double contentScale, @NotNull BufferMultisample multisample, @Nullable Session session, @NotNull Function1<? super RenderTargetBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.builder = builder;
        this.renderTarget = RenderTargetKt.renderTarget(width, height, contentScale, multisample, session, this.builder);
    }

    public /* synthetic */ ResizableRenderTarget(int n, int n2, double d, BufferMultisample bufferMultisample, Session session, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bufferMultisample = BufferMultisample.Disabled.INSTANCE;
        }
        this(n, n2, d, bufferMultisample, session, function1);
    }

    @NotNull
    public final Function1<RenderTargetBuilder, Unit> getBuilder() {
        return this.builder;
    }

    @NotNull
    public final RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    public final void setRenderTarget(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter(renderTarget, "<set-?>");
        this.renderTarget = renderTarget;
    }

    public final void resize(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter(renderTarget, "renderTarget");
        this.resize(renderTarget.getWidth(), renderTarget.getHeight(), renderTarget.getContentScale());
    }

    public final void resize(int newWidth, int newHeight, double newContentScale) {
        if (this.renderTarget.getWidth() != newWidth || this.renderTarget.getHeight() != newHeight || !(this.renderTarget.getContentScale() == newContentScale)) {
            for (ColorAttachment attachment : this.renderTarget.getColorAttachments()) {
                if (attachment instanceof ColorBufferAttachment) {
                    ((ColorBufferAttachment)attachment).getColorBuffer().destroy();
                    continue;
                }
                throw new IllegalStateException(("unsupported attachment `" + attachment + "` in ResizableRenderTarget").toString());
            }
            DepthBuffer depthBuffer = this.renderTarget.getDepthBuffer();
            if (depthBuffer != null) {
                depthBuffer.destroy();
            }
            this.renderTarget.detachColorAttachments();
            this.renderTarget.detachDepthBuffer();
            this.renderTarget.destroy();
            this.renderTarget = RenderTargetKt.renderTarget(newWidth, newHeight, newContentScale, this.renderTarget.getMultisample(), this.renderTarget.getSession(), this.builder);
        }
    }

    public static /* synthetic */ void resize$default(ResizableRenderTarget resizableRenderTarget, int n, int n2, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = resizableRenderTarget.renderTarget.getWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = resizableRenderTarget.renderTarget.getHeight();
        }
        if ((n3 & 4) != 0) {
            d = resizableRenderTarget.renderTarget.getContentScale();
        }
        resizableRenderTarget.resize(n, n2, d);
    }
}

