/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.ShaderStorageBuffer;
import org.openrndr.draw.ShaderStorageElement;
import org.openrndr.draw.ShaderStorageFormat;
import org.openrndr.draw.ShaderStoragePrimitive;
import org.openrndr.draw.ShaderStorageStruct;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Driver;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"shaderStorageFormat", "Lorg/openrndr/draw/ShaderStorageFormat;", "builder", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "shaderStorageFormatToVertexFormat", "Lorg/openrndr/draw/VertexFormat;", "format", "shaderStorageBuffer", "Lorg/openrndr/draw/ShaderStorageBuffer;", "openrndr-draw"})
public final class ShaderStorageBufferKt {
    @NotNull
    public static final ShaderStorageFormat shaderStorageFormat(@NotNull Function1<? super ShaderStorageFormat, Unit> builder) {
        ShaderStorageFormat shaderStorageFormat;
        Intrinsics.checkNotNullParameter(builder, "builder");
        ShaderStorageFormat $this$shaderStorageFormat_u24lambda_u240 = shaderStorageFormat = new ShaderStorageFormat();
        boolean bl = false;
        builder.invoke($this$shaderStorageFormat_u24lambda_u240);
        $this$shaderStorageFormat_u24lambda_u240.commit();
        return shaderStorageFormat;
    }

    @NotNull
    public static final VertexFormat shaderStorageFormatToVertexFormat(@NotNull ShaderStorageFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        return VertexFormatKt.vertexFormat(arg_0 -> ShaderStorageBufferKt.shaderStorageFormatToVertexFormat$lambda$1(format, arg_0));
    }

    @NotNull
    public static final ShaderStorageBuffer shaderStorageBuffer(@NotNull ShaderStorageFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        return Driver.DefaultImpls.createShaderStorageBuffer$default(Driver.Companion.getInstance(), format, null, 2, null);
    }

    private static final Unit shaderStorageFormatToVertexFormat$lambda$1(ShaderStorageFormat $format, VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($format, "$format");
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        if (CollectionsKt.first($format.getElements()) instanceof ShaderStorageStruct) {
            ShaderStorageElement shaderStorageElement = CollectionsKt.first($format.getElements());
            Intrinsics.checkNotNull(shaderStorageElement, "null cannot be cast to non-null type org.openrndr.draw.ShaderStorageStruct");
            ShaderStorageStruct outerStruct = (ShaderStorageStruct)shaderStorageElement;
            for (ShaderStorageElement member : outerStruct.getElements()) {
                if (!(member instanceof ShaderStoragePrimitive)) continue;
                VertexElementType vet = switch (WhenMappings.$EnumSwitchMapping$0[((ShaderStoragePrimitive)member).getType().ordinal()]) {
                    case 1 -> VertexElementType.VECTOR4_FLOAT32;
                    case 2 -> VertexElementType.VECTOR3_FLOAT32;
                    case 3 -> VertexElementType.VECTOR2_FLOAT32;
                    case 4 -> VertexElementType.MATRIX33_FLOAT32;
                    case 5 -> VertexElementType.MATRIX33_FLOAT32;
                    case 6 -> VertexElementType.MATRIX44_FLOAT32;
                    case 7 -> VertexElementType.INT32;
                    case 8 -> VertexElementType.UINT32;
                    case 9 -> VertexElementType.FLOAT32;
                    default -> throw new IllegalStateException(("unsupported type '" + ((ShaderStoragePrimitive)member).getType()).toString());
                };
                int padding = ((ShaderStoragePrimitive)member).getPadding();
                VertexFormat.attribute$default($this$vertexFormat, ((ShaderStoragePrimitive)member).getName(), vet, 0, 4, null);
                if (padding <= 0) continue;
                $this$vertexFormat.padding(padding);
            }
        } else {
            throw new IllegalStateException("first item of storage buffer format must be a struct".toString());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BufferPrimitiveType.values().length];
            try {
                nArray[BufferPrimitiveType.VECTOR4_FLOAT32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_FLOAT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_FLOAT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX22_FLOAT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX33_FLOAT32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX44_FLOAT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.INT32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.UINT32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.FLOAT32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

