/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.ShaderStorageElement;
import org.openrndr.draw.ShaderStoragePrimitive;
import org.openrndr.draw.ShaderStorageStruct;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\fJ9\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\f2\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00110\u001a\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0006\u0010 \u001a\u00020\u0011J\u0013\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/openrndr/draw/ShaderStorageFormat;", "", "<init>", "()V", "elements", "", "Lorg/openrndr/draw/ShaderStorageElement;", "getElements", "()Ljava/util/List;", "setElements", "(Ljava/util/List;)V", "formatSize", "", "size", "getSize", "()I", "primitive", "", "name", "", "type", "Lorg/openrndr/draw/BufferPrimitiveType;", "arraySize", "struct", "structName", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "toString", "hasMember", "", "hashCode", "commit", "equals", "other", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nShaderStorageBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderStorageBuffer.kt\norg/openrndr/draw/ShaderStorageFormat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n808#2,11:263\n1755#2,3:274\n1#3:277\n*S KotlinDebug\n*F\n+ 1 ShaderStorageBuffer.kt\norg/openrndr/draw/ShaderStorageFormat\n*L\n101#1:263,11\n114#1:274,3\n*E\n"})
public final class ShaderStorageFormat {
    @NotNull
    private List<ShaderStorageElement> elements = new ArrayList();
    private int formatSize;

    @NotNull
    public final List<ShaderStorageElement> getElements() {
        return this.elements;
    }

    public final void setElements(@NotNull List<ShaderStorageElement> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.elements = list;
    }

    public final int getSize() {
        return this.formatSize;
    }

    public final void primitive(@NotNull String name, @NotNull BufferPrimitiveType type, int arraySize) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        ShaderStoragePrimitive item = new ShaderStoragePrimitive(name, type, arraySize, 0, 0, 24, null);
        this.elements.add(item);
    }

    public static /* synthetic */ void primitive$default(ShaderStorageFormat shaderStorageFormat, String string, BufferPrimitiveType bufferPrimitiveType, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        shaderStorageFormat.primitive(string, bufferPrimitiveType, n);
    }

    /*
     * WARNING - void declaration
     */
    public final void struct(@NotNull String structName, @NotNull String name, int arraySize, @NotNull Function1<? super ShaderStorageFormat, Unit> builder) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(structName, "structName");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(builder, "builder");
        ShaderStorageFormat it = new ShaderStorageFormat();
        boolean $i$a$-let-ShaderStorageFormat$struct$structElements$22 = false;
        builder.invoke(it);
        Iterable iterable = it.elements;
        boolean $i$f$filterIsInstance = false;
        void $i$a$-let-ShaderStorageFormat$struct$structElements$22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ShaderStoragePrimitive)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List structElements = (List)destination$iv$iv;
        ShaderStorageStruct struct = new ShaderStorageStruct(structName, name, structElements, arraySize, 0, 16, null);
        this.elements.add(struct);
    }

    public static /* synthetic */ void struct$default(ShaderStorageFormat shaderStorageFormat, String string, String string2, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        shaderStorageFormat.struct(string, string2, n, function1);
    }

    @NotNull
    public String toString() {
        return "ShaderStorageFormat{items=" + this.elements + ", formatSize=" + this.formatSize + "}";
    }

    public final boolean hasMember(@NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$any$iv = this.elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ShaderStorageElement it = (ShaderStorageElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final void commit() {
        int endPadding;
        int n;
        Iterable iterable = this.elements;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            ShaderStorageElement shaderStorageElement = (ShaderStorageElement)t;
            int n3 = n2;
            n = 0;
            int n4 = it instanceof ShaderStorageStruct ? ((ShaderStorageStruct)it).getElements().size() : 1;
            n2 = n3 + n4;
        }
        int memberCount = n2;
        int[] paddings = new int[memberCount];
        int largestAlign = 0;
        int ints = 0;
        int paddingIdx = -1;
        n = ((Collection)this.elements).size();
        for (int idx = 0; idx < n; ++idx) {
            int align;
            ShaderStorageElement element = this.elements.get(idx);
            if (element instanceof ShaderStoragePrimitive) {
                int len = ((ShaderStoragePrimitive)element).getArraySize();
                align = ((ShaderStoragePrimitive)element).getType().getAlignmentInBytes();
                largestAlign = Math.max(largestAlign, align);
                if (idx >= 1) {
                    int neededPadding;
                    paddings[paddingIdx] = neededPadding = (align - ints % align) % align;
                    ints += neededPadding;
                }
                ints += ((ShaderStoragePrimitive)element).getType().getSizeInBytes() * len;
                ++paddingIdx;
                continue;
            }
            if (!(element instanceof ShaderStorageStruct)) continue;
            align = ((Collection)((ShaderStorageStruct)element).getElements()).size();
            for (int sIdx = 0; sIdx < align; ++sIdx) {
                ShaderStorageElement shaderStorageElement = ((ShaderStorageStruct)element).getElements().get(sIdx);
                Intrinsics.checkNotNull(shaderStorageElement, "null cannot be cast to non-null type org.openrndr.draw.ShaderStoragePrimitive");
                ShaderStoragePrimitive structMember = (ShaderStoragePrimitive)shaderStorageElement;
                int len = structMember.getArraySize();
                int align2 = structMember.getType().getAlignmentInBytes();
                largestAlign = Math.max(largestAlign, align2);
                if (idx + sIdx >= 1) {
                    int neededPadding;
                    paddings[paddingIdx] = neededPadding = (align2 - ints % align2) % align2;
                    ints += neededPadding;
                }
                ints += structMember.getType().getSizeInBytes() * len;
                ++paddingIdx;
            }
        }
        paddings[memberCount - 1] = endPadding = (largestAlign - ints % largestAlign) % largestAlign;
        paddingIdx = 0;
        int n5 = ((Collection)this.elements).size();
        for (int memberIdx = 0; memberIdx < n5; ++memberIdx) {
            ShaderStorageElement element = this.elements.get(memberIdx);
            if (element instanceof ShaderStoragePrimitive) {
                int padding = paddings[paddingIdx];
                ((ShaderStoragePrimitive)element).setOffset(((ShaderStoragePrimitive)element).getArraySize() * ((ShaderStoragePrimitive)element).getType().getSizeInBytes());
                ((ShaderStoragePrimitive)element).setPadding(padding);
                this.formatSize += ((ShaderStoragePrimitive)element).getOffset() + padding;
                ++paddingIdx;
                continue;
            }
            if (!(element instanceof ShaderStorageStruct)) continue;
            int totalSize = 0;
            int n6 = ((Collection)((ShaderStorageStruct)element).getElements()).size();
            for (int sIdx = 0; sIdx < n6; ++sIdx) {
                ShaderStorageElement shaderStorageElement = ((ShaderStorageStruct)element).getElements().get(sIdx);
                Intrinsics.checkNotNull(shaderStorageElement, "null cannot be cast to non-null type org.openrndr.draw.ShaderStoragePrimitive");
                ShaderStoragePrimitive structMember = (ShaderStoragePrimitive)shaderStorageElement;
                int padding = paddings[paddingIdx];
                structMember.setOffset(structMember.getArraySize() * structMember.getType().getSizeInBytes());
                structMember.setPadding(padding);
                totalSize += structMember.getOffset() + padding;
                ++paddingIdx;
            }
            this.formatSize += totalSize * ((ShaderStorageStruct)element).getArraySize();
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ShaderStorageFormat cfr_ignored_0 = (ShaderStorageFormat)other;
        return Intrinsics.areEqual(this.elements, ((ShaderStorageFormat)other).elements);
    }
}

