/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Session;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH&J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH&J)\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\r2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\u0002\b\u0014J\b\u0010 \u001a\u00020\tH&J.\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\r2\b\b\u0002\u0010$\u001a\u00020\r2\b\b\u0002\u0010%\u001a\u00020\rH&R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lorg/openrndr/draw/VertexBuffer;", "", "<init>", "()V", "session", "Lorg/openrndr/draw/Session;", "getSession", "()Lorg/openrndr/draw/Session;", "write", "", "data", "Ljava/nio/ByteBuffer;", "offsetInBytes", "", "read", "put", "elementOffset", "putter", "Lkotlin/Function1;", "Lorg/openrndr/draw/BufferWriter;", "Lkotlin/ExtensionFunctionType;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "vertexCount", "getVertexCount", "()I", "shadow", "Lorg/openrndr/draw/VertexBufferShadow;", "getShadow", "()Lorg/openrndr/draw/VertexBufferShadow;", "destroy", "source", "Lorg/openrndr/utils/buffer/MPPBuffer;", "targetByteOffset", "sourceByteOffset", "byteLength", "Companion", "openrndr-draw"})
public abstract class VertexBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract Session getSession();

    public abstract void write(@NotNull ByteBuffer var1, int var2);

    public static /* synthetic */ void write$default(VertexBuffer vertexBuffer, ByteBuffer byteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        vertexBuffer.write(byteBuffer, n);
    }

    public abstract void read(@NotNull ByteBuffer var1, int var2);

    public static /* synthetic */ void read$default(VertexBuffer vertexBuffer, ByteBuffer byteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        vertexBuffer.read(byteBuffer, n);
    }

    public final int put(int elementOffset, @NotNull Function1<? super BufferWriter, Unit> putter) {
        Intrinsics.checkNotNullParameter(putter, "putter");
        BufferWriter w = this.getShadow().writer();
        w.rewind();
        w.setPositionElements(elementOffset);
        putter.invoke(w);
        if (w.getPosition() % this.getVertexFormat().getSize() != 0) {
            throw new RuntimeException("incomplete vertices written at " + w.getPosition() + ". likely violating the specified vertex format " + this.getVertexFormat());
        }
        int count2 = w.getPositionElements() - elementOffset;
        this.getShadow().uploadElements(elementOffset, count2);
        w.rewind();
        return count2;
    }

    public static /* synthetic */ int put$default(VertexBuffer vertexBuffer, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return vertexBuffer.put(n, function1);
    }

    @NotNull
    public abstract VertexFormat getVertexFormat();

    public abstract int getVertexCount();

    @NotNull
    public abstract VertexBufferShadow getShadow();

    public abstract void destroy();

    public abstract void write(@NotNull MPPBuffer var1, int var2, int var3, int var4);

    public static /* synthetic */ void write$default(VertexBuffer vertexBuffer, MPPBuffer mPPBuffer, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = mPPBuffer.capacity();
        }
        vertexBuffer.write(mPPBuffer, n, n2, n3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/draw/VertexBuffer$Companion;", "", "<init>", "()V", "createDynamic", "Lorg/openrndr/draw/VertexBuffer;", "format", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "", "session", "Lorg/openrndr/draw/Session;", "createFromFloats", "data", "", "openrndr-draw"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VertexBuffer createDynamic(@NotNull VertexFormat format, int vertexCount, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(format, "format");
            return Driver.Companion.getInstance().createDynamicVertexBuffer(format, vertexCount, session);
        }

        public static /* synthetic */ VertexBuffer createDynamic$default(Companion companion, VertexFormat vertexFormat, int n, Session session, int n2, Object object) {
            if ((n2 & 4) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.createDynamic(vertexFormat, n, session);
        }

        @NotNull
        public final VertexBuffer createFromFloats(@NotNull VertexFormat format, @NotNull float[] data, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(format, "format");
            Intrinsics.checkNotNullParameter(data, "data");
            if (!(data.length * 4 % format.getSize() == 0)) {
                boolean bl = false;
                String string = "supplied data size doesn't match format size";
                throw new IllegalArgumentException(string.toString());
            }
            VertexBuffer vertexBuffer = this.createDynamic(format, data.length * 4 / format.getSize(), session);
            vertexBuffer.put(0, arg_0 -> Companion.createFromFloats$lambda$1(data, arg_0));
            return vertexBuffer;
        }

        private static final Unit createFromFloats$lambda$1(float[] $data, BufferWriter $this$put) {
            Intrinsics.checkNotNullParameter($data, "$data");
            Intrinsics.checkNotNullParameter($this$put, "$this$put");
            $this$put.write($data, 0, $data.length);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

