/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.VertexElement;
import org.openrndr.draw.VertexElementType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u001a\u0010\u0019\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u001a\u001a\u00020\fJ \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\fJ\b\u0010 \u001a\u00020\u001dH\u0016J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0013\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010%\u001a\u00020\fH\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/openrndr/draw/VertexFormat;", "", "<init>", "()V", "items", "", "Lorg/openrndr/draw/VertexElement;", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "vertexSize", "", "size", "getSize", "()I", "position", "", "dimensions", "padding", "paddingInBytes", "floatTypeFromDimensions", "Lorg/openrndr/draw/VertexElementType;", "normal", "color", "textureCoordinate", "index", "attribute", "name", "", "type", "arraySize", "toString", "hasAttribute", "", "equals", "other", "hashCode", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nVertexFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertexFormat.kt\norg/openrndr/draw/VertexFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1#2:104\n1755#3,3:105\n*S KotlinDebug\n*F\n+ 1 VertexFormat.kt\norg/openrndr/draw/VertexFormat\n*L\n76#1:105,3\n*E\n"})
public final class VertexFormat {
    @NotNull
    private List<VertexElement> items = new ArrayList();
    private int vertexSize;

    @NotNull
    public final List<VertexElement> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<VertexElement> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.items = list;
    }

    public final int getSize() {
        return this.vertexSize;
    }

    public final void position(int dimensions) {
        VertexFormat.attribute$default(this, "position", this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public final void padding(int paddingInBytes) {
        this.attribute("_", VertexElementType.UINT8, paddingInBytes);
    }

    private final VertexElementType floatTypeFromDimensions(int dimensions) {
        return switch (dimensions) {
            case 1 -> VertexElementType.FLOAT32;
            case 2 -> VertexElementType.VECTOR2_FLOAT32;
            case 3 -> VertexElementType.VECTOR3_FLOAT32;
            case 4 -> VertexElementType.VECTOR4_FLOAT32;
            default -> throw new IllegalArgumentException("dimensions can only be 1, 2, 3 or 4 (got " + dimensions + ")");
        };
    }

    public final void normal(int dimensions) {
        VertexFormat.attribute$default(this, "normal", this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public final void color(int dimensions) {
        VertexFormat.attribute$default(this, "color", this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public final void textureCoordinate(int dimensions, int index) {
        VertexFormat.attribute$default(this, "texCoord" + index, this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public static /* synthetic */ void textureCoordinate$default(VertexFormat vertexFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        vertexFormat.textureCoordinate(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void attribute(@NotNull String name, @NotNull VertexElementType type, int arraySize) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Iterable iterable = this.items;
        int n = 0;
        for (Object t : iterable) {
            void it;
            VertexElement vertexElement = (VertexElement)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getArraySize() * it.getType().getSizeInBytes();
            n = n2 + n3;
        }
        int offset = n;
        VertexElement item = new VertexElement(name, offset, type, arraySize);
        this.items.add(item);
        this.vertexSize += type.getSizeInBytes() * arraySize;
    }

    public static /* synthetic */ void attribute$default(VertexFormat vertexFormat, String string, VertexElementType vertexElementType, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        vertexFormat.attribute(string, vertexElementType, n);
    }

    @NotNull
    public String toString() {
        return "VertexFormat{items=" + this.items + ", vertexSize=" + this.vertexSize + "}";
    }

    public final boolean hasAttribute(@NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$any$iv = this.items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VertexElement it = (VertexElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getAttribute(), name)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VertexFormat)) {
            return false;
        }
        return Intrinsics.areEqual(this.items, ((VertexFormat)other).items);
    }

    public int hashCode() {
        return ((Object)this.items).hashCode();
    }
}

